package ink.aos.module.desensitized.factory;

import ink.aos.module.desensitized.format.DesensitizedFormatter;
import ink.aos.module.desensitized.annotation.Desensitized;
import org.springframework.format.AnnotationFormatterFactory;
import org.springframework.format.Parser;
import org.springframework.format.Printer;

import java.util.HashSet;
import java.util.Set;

/**
 * All rights Reserved, Designed By aos.ink
 *
 * @version V1.0
 * @author: lichaohn@163.com
 * @date: 3/2/21
 * @Copyright: 2019 www.aos.ink All rights reserved.
 */
public class DesensitizedAnnotationFormatterFactory implements AnnotationFormatterFactory<Desensitized> {
    /**
     * 返回为处理的变量的类型
     *
     * @return
     */
    @Override
    public Set<Class<?>> getFieldTypes() {
        Set<Class<?>> hashSet = new HashSet<>();
        hashSet.add(String.class);
        return hashSet;
    }

    @Override
    public Printer<?> getPrinter(Desensitized desensitized, Class<?> aClass) {
        return getFormatter(desensitized);
    }

    @Override
    public Parser<?> getParser(Desensitized desensitized, Class<?> aClass) {
        return getFormatter(desensitized);
    }


    private DesensitizedFormatter getFormatter(Desensitized desensitized) {
        DesensitizedFormatter formatter = new DesensitizedFormatter();
        formatter.setTypeEnum(desensitized.type());
        return formatter;
    }

}