/*
 * Decompiled with CFR 0.152.
 */
package ink.aos.module.desensitized.format;

import ink.aos.module.desensitized.enums.SensitiveTypeEnum;
import ink.aos.module.desensitized.utils.DesensitizedUtils;
import java.text.ParseException;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.springframework.format.Formatter;

public class DesensitizedFormatter
implements Formatter<String> {
    private SensitiveTypeEnum typeEnum;

    public SensitiveTypeEnum getTypeEnum() {
        return this.typeEnum;
    }

    public void setTypeEnum(SensitiveTypeEnum typeEnum) {
        this.typeEnum = typeEnum;
    }

    public String parse(String valueStr, Locale locale) throws ParseException {
        if (StringUtils.isNotBlank((CharSequence)valueStr)) {
            switch (this.typeEnum) {
                case CHINESE_NAME: {
                    valueStr = DesensitizedUtils.chineseName(valueStr);
                    break;
                }
                case ID_CARD: {
                    valueStr = DesensitizedUtils.idCardNum(valueStr);
                    break;
                }
                case FIXED_PHONE: {
                    valueStr = DesensitizedUtils.fixedPhone(valueStr);
                    break;
                }
                case MOBILE_PHONE: {
                    valueStr = DesensitizedUtils.mobilePhone(valueStr);
                    break;
                }
                case ADDRESS: {
                    valueStr = DesensitizedUtils.address(valueStr, 8);
                    break;
                }
                case EMAIL: {
                    valueStr = DesensitizedUtils.email(valueStr);
                    break;
                }
                case BANK_CARD: {
                    valueStr = DesensitizedUtils.bankCard(valueStr);
                    break;
                }
                case PASSWORD: {
                    valueStr = DesensitizedUtils.password(valueStr);
                    break;
                }
                case CARNUMBER: {
                    valueStr = DesensitizedUtils.carNumber(valueStr);
                    break;
                }
            }
        }
        return valueStr;
    }

    public String print(String s, Locale locale) {
        return s;
    }
}

