/*
 * Decompiled with CFR 0.152.
 */
package net.innig.collect;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class CollectionDiff {
    private Collection oldStuff;
    private Collection newStuff;
    private Set added;
    private Set removed;
    private Set same;

    public CollectionDiff(Collection oldStuff, Collection newStuff) {
        this(oldStuff, newStuff, false);
    }

    public CollectionDiff(Collection oldStuff, Collection newStuff, boolean copy) {
        this.oldStuff = copy ? oldStuff : new HashSet(oldStuff);
        this.newStuff = copy ? newStuff : new HashSet(newStuff);
    }

    public Set getAdded() {
        if (this.added == null) {
            this.added = new HashSet(this.newStuff);
            this.added.removeAll(this.oldStuff);
        }
        return this.added;
    }

    public Set getRemoved() {
        if (this.removed == null) {
            this.removed = new HashSet(this.oldStuff);
            this.removed.removeAll(this.newStuff);
        }
        return this.removed;
    }

    public Set getSame() {
        if (this.same == null) {
            this.same = new HashSet(this.oldStuff);
            this.same.retainAll(this.newStuff);
        }
        return this.same;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        CollectionDiff otherdiff = (CollectionDiff)other;
        return otherdiff.oldStuff.equals(this.oldStuff) && otherdiff.newStuff.equals(this.newStuff);
    }

    public int hashCode() {
        return this.oldStuff.hashCode() * 41 + this.newStuff.hashCode();
    }
}

