/*
 * Decompiled with CFR 0.152.
 */
package net.innig.collect;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.innig.collect.MultiMap;

public class CompositeMultiMap
implements MultiMap,
Serializable {
    private Map map;
    private Class setClass;
    private int size;
    private transient Collection values;
    private transient Set entries;
    private transient long version;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$util$Set;

    public CompositeMultiMap(Class mapClass, Class setClass) {
        if (!(class$java$util$Map == null ? (class$java$util$Map = CompositeMultiMap.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(mapClass)) {
            throw new IllegalArgumentException("map class " + mapClass.getName() + " doesn't implement java.util.Map");
        }
        if (!(class$java$util$Set == null ? (class$java$util$Set = CompositeMultiMap.class$("java.util.Set")) : class$java$util$Set).isAssignableFrom(setClass)) {
            throw new IllegalArgumentException("set class " + mapClass.getName() + " doesn't implement java.util.Set");
        }
        try {
            this.map = (Map)mapClass.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new RuntimeException("Can't instantiate " + setClass + ": " + e);
        }
        this.setClass = setClass;
    }

    public CompositeMultiMap(Class mapClass, Class setClass, MultiMap multimap) {
        this(mapClass, setClass);
        this.putAll(multimap);
    }

    public CompositeMultiMap(Class mapClass, Class setClass, Map map) {
        this(mapClass, setClass);
        this.putAll(map);
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(Object value) {
        java.util.Iterator i = this.values().iterator();
        while (i.hasNext()) {
            if (!(value == null ? i.next() == null : i.next().equals(value))) continue;
            return true;
        }
        return true;
    }

    public Set get(Object key) {
        Set values = (Set)this.map.get(key);
        return values == null ? null : Collections.unmodifiableSet(values);
    }

    public boolean put(Object key, Object value) {
        if (!this.getValueSet(key).add(value)) {
            return false;
        }
        ++this.size;
        return true;
    }

    public boolean putAll(Object key, Collection values) {
        Set valueSet = this.getValueSet(key);
        this.size -= valueSet.size();
        boolean added = valueSet.addAll(values);
        this.size += valueSet.size();
        return added;
    }

    public boolean remove(Object key, Object value) {
        Set valueSet = (Set)this.map.get(key);
        if (valueSet != null && valueSet.remove(value)) {
            --this.size;
            if (valueSet.isEmpty()) {
                this.removeKey(key);
            }
            return true;
        }
        return false;
    }

    public Set removeKey(Object key) {
        Set valueSet = (Set)this.map.get(key);
        if (valueSet == null) {
            return null;
        }
        this.size -= valueSet.size();
        this.map.remove(key);
        return valueSet;
    }

    public void putAll(MultiMap multimap) {
        java.util.Iterator i = multimap.keySet().iterator();
        while (i.hasNext()) {
            Object key = i.next();
            this.putAll(key, multimap.get(key));
        }
    }

    public void putAll(Map map) {
        java.util.Iterator i = map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void clear() {
        this.map.clear();
        this.size = 0;
    }

    public Set keySet() {
        return this.map.keySet();
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new AbstractCollection(){

                public java.util.Iterator iterator() {
                    return new Iterator(false);
                }

                public int size() {
                    return CompositeMultiMap.this.size();
                }

                public void clear() {
                    CompositeMultiMap.this.clear();
                }
            };
        }
        return this.values;
    }

    public Set entrySet() {
        if (this.entries == null) {
            this.entries = new AbstractSet(){

                public java.util.Iterator iterator() {
                    return new Iterator(true);
                }

                public int size() {
                    return CompositeMultiMap.this.size;
                }

                public boolean remove(Object obj) {
                    if (!(obj instanceof MultiMap.Entry)) {
                        return false;
                    }
                    MultiMap.Entry entry = (MultiMap.Entry)obj;
                    return CompositeMultiMap.this.remove(entry.getKey(), entry.getValue());
                }

                public void clear() {
                    CompositeMultiMap.this.clear();
                }
            };
        }
        return this.entries;
    }

    public boolean equals(Object other) {
        if (!(other instanceof MultiMap)) {
            return false;
        }
        MultiMap otherMultimap = (MultiMap)other;
        if (other instanceof CompositeMultiMap) {
            return this.map.equals(((CompositeMultiMap)other).map);
        }
        return this.entrySet().equals(otherMultimap.entrySet());
    }

    public int hashCode() {
        int hash = 0;
        java.util.Iterator keyEntryIter = this.map.entrySet().iterator();
        while (keyEntryIter.hasNext()) {
            hash += ((Object)keyEntryIter.next()).hashCode();
        }
        return hash;
    }

    private Set getValueSet(Object key) {
        Set valueSet = (Set)this.map.get(key);
        if (valueSet == null) {
            try {
                valueSet = (Set)this.setClass.newInstance();
                this.map.put(key, valueSet);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                throw new RuntimeException("Can't instantiate " + this.setClass + ": " + e);
            }
        }
        return valueSet;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("{");
        java.util.Iterator keyIter = this.map.entrySet().iterator();
        while (keyIter.hasNext()) {
            Map.Entry entry = keyIter.next();
            buf.append(entry.getKey());
            buf.append('=');
            buf.append(entry.getValue());
            if (!keyIter.hasNext()) continue;
            buf.append(", ");
        }
        buf.append('}');
        return buf.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class Iterator
    implements java.util.Iterator {
        private boolean isEntryIter;
        private long expectedVersion;
        private java.util.Iterator keyIter;
        private java.util.Iterator valueIter;
        private java.util.Iterator removableIter;
        private Object curKey;

        public Iterator(boolean isEntryIter) {
            this.isEntryIter = isEntryIter;
            this.expectedVersion = CompositeMultiMap.this.version;
            this.keyIter = CompositeMultiMap.this.map.entrySet().iterator();
        }

        public boolean hasNext() {
            this.normalize();
            return this.valueIter != null;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.removableIter = this.valueIter;
            if (this.isEntryIter) {
                return new Entry(this.curKey, this.valueIter.next());
            }
            return this.valueIter.next();
        }

        public void remove() {
            if (CompositeMultiMap.this.version != this.expectedVersion) {
                throw new ConcurrentModificationException();
            }
            if (this.removableIter == null) {
                throw new IllegalStateException();
            }
            this.removableIter.remove();
            this.removableIter = null;
            CompositeMultiMap.this.size--;
            this.expectedVersion = ++CompositeMultiMap.this.version;
        }

        private void normalize() {
            if (CompositeMultiMap.this.version != this.expectedVersion) {
                throw new ConcurrentModificationException();
            }
            if (this.valueIter != null && this.valueIter.hasNext()) {
                return;
            }
            if (!this.keyIter.hasNext()) {
                this.valueIter = null;
                return;
            }
            Map.Entry entry = (Map.Entry)this.keyIter.next();
            this.curKey = entry.getKey();
            this.valueIter = ((Set)entry.getValue()).iterator();
        }
    }

    public class Entry
    implements MultiMap.Entry {
        private Object key;
        private Object value;

        public Entry(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean equals(Object other) {
            if (other == null || !(other instanceof MultiMap.Entry)) {
                return false;
            }
            MultiMap.Entry otherEntry = (MultiMap.Entry)other;
            return this.key.equals(otherEntry.getKey()) && (this.value == null ? otherEntry.getValue() == null : this.value.equals(otherEntry.getValue()));
        }

        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) + (this.value == null ? 0 : this.value.hashCode()) * 17;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

