/*
 * Decompiled with CFR 0.152.
 */
package net.innig.collect;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.innig.collect.GraphWalker;

public abstract class Graphs {
    public static Set reachableNodes(Object initial, GraphWalker walker) {
        return Graphs.reachableNodes(Collections.singleton(initial), walker);
    }

    public static Set reachableNodes(Set initial, GraphWalker walker) {
        HashSet nodes = new HashSet();
        HashSet newNodes = initial;
        HashSet newerNodes = new HashSet();
        while (!newNodes.isEmpty()) {
            nodes.addAll(newNodes);
            Iterator i = newNodes.iterator();
            while (i.hasNext()) {
                newerNodes.addAll(walker.getEdgesFrom(i.next()));
            }
            newerNodes.removeAll(nodes);
            newNodes = newerNodes;
            newerNodes = new HashSet();
        }
        return nodes;
    }

    public static Set findCycles(Object initial, GraphWalker walker) {
        HashSet cycles = new HashSet();
        Graphs.findCycles(initial, cycles, walker, new ArrayList(), new HashSet());
        return cycles;
    }

    private static void findCycles(Object node, Set cycles, GraphWalker walker, List curPath, Set visited) {
        curPath.add(node);
        if (visited.contains(node)) {
            cycles.add(Collections.unmodifiableList(new ArrayList(curPath)));
        } else {
            visited.add(node);
            Iterator i = walker.getEdgesFrom(node).iterator();
            while (i.hasNext()) {
                Graphs.findCycles(i.next(), cycles, walker, curPath, visited);
            }
            visited.remove(node);
        }
        curPath.remove(curPath.size() - 1);
    }

    private Graphs() {
    }
}

