/*
 * Decompiled with CFR 0.152.
 */
package net.innig.collect;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.innig.collect.HashMultiMap;
import net.innig.collect.Mapper;
import net.innig.collect.MultiMap;
import net.innig.collect.Radix;
import net.innig.collect.Selector;

public class InnigCollections {
    public static final MultiMap EMPTY_MULTIMAP = new MultiMap(){
        private final String unsupported = "InnigCollections.EMPTY_MULTIMAP is immutable";

        public int size() {
            return 0;
        }

        public boolean isEmpty() {
            return true;
        }

        public boolean containsKey(Object key) {
            return false;
        }

        public boolean containsValue(Object value) {
            return false;
        }

        public Set get(Object key) {
            return null;
        }

        public boolean put(Object key, Object value) {
            throw new UnsupportedOperationException("InnigCollections.EMPTY_MULTIMAP is immutable");
        }

        public boolean putAll(Object key, Collection values) {
            throw new UnsupportedOperationException("InnigCollections.EMPTY_MULTIMAP is immutable");
        }

        public boolean remove(Object key, Object value) {
            throw new UnsupportedOperationException("InnigCollections.EMPTY_MULTIMAP is immutable");
        }

        public Set removeKey(Object key) {
            throw new UnsupportedOperationException("InnigCollections.EMPTY_MULTIMAP is immutable");
        }

        public void putAll(MultiMap multimap) {
            throw new UnsupportedOperationException("InnigCollections.EMPTY_MULTIMAP is immutable");
        }

        public void putAll(Map map) {
            throw new UnsupportedOperationException("InnigCollections.EMPTY_MULTIMAP is immutable");
        }

        public void clear() {
            throw new UnsupportedOperationException("InnigCollections.EMPTY_MULTIMAP is immutable");
        }

        public Set keySet() {
            return Collections.EMPTY_SET;
        }

        public Collection values() {
            return Collections.EMPTY_SET;
        }

        public Set entrySet() {
            return Collections.EMPTY_SET;
        }

        public boolean equals(Object o) {
            return o instanceof MultiMap && ((MultiMap)o).isEmpty();
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }

        public String toString() {
            return "{}";
        }
    };

    public static MultiMap unmodifiableMultiMap(MultiMap mm) {
        return new UnmodifiableMultiMap(mm);
    }

    public static MultiMap synchronizedMultiMap(MultiMap mm) {
        return InnigCollections.synchronizedMultiMap(mm, new Object());
    }

    public static MultiMap synchronizedMultiMap(MultiMap mm, Object sync) {
        return new SynchronizedMultiMap(mm, sync);
    }

    public static Set uniqueCollectionAsSet(final Collection c) {
        if (c instanceof Set) {
            return Collections.unmodifiableSet((Set)c);
        }
        return new AbstractSet(){
            private final String unsupported = "sets returned by InnigCollections.uniqueCollectionAsSet() are immutable";

            public int size() {
                return c.size();
            }

            public boolean isEmpty() {
                return c.isEmpty();
            }

            public boolean contains(Object o) {
                return c.contains(o);
            }

            public boolean containsAll(Collection other) {
                return c.containsAll(other);
            }

            public Object[] toArray() {
                return c.toArray();
            }

            public Object[] toArray(Object[] a) {
                return c.toArray(a);
            }

            public boolean add(Object o) {
                throw new UnsupportedOperationException("sets returned by InnigCollections.uniqueCollectionAsSet() are immutable");
            }

            public boolean remove(Object o) {
                throw new UnsupportedOperationException("sets returned by InnigCollections.uniqueCollectionAsSet() are immutable");
            }

            public boolean addAll(Collection other) {
                throw new UnsupportedOperationException("sets returned by InnigCollections.uniqueCollectionAsSet() are immutable");
            }

            public boolean retainAll(Collection other) {
                throw new UnsupportedOperationException("sets returned by InnigCollections.uniqueCollectionAsSet() are immutable");
            }

            public boolean removeAll(Collection other) {
                throw new UnsupportedOperationException("sets returned by InnigCollections.uniqueCollectionAsSet() are immutable");
            }

            public void clear() {
                throw new UnsupportedOperationException("sets returned by InnigCollections.uniqueCollectionAsSet() are immutable");
            }

            public Iterator iterator() {
                Iterator i = c.iterator();
                return new Iterator(this, i){
                    private final /* synthetic */ Iterator val$i;
                    private final /* synthetic */ 2 this$0;
                    {
                        this.this$0 = this$0;
                        this.val$i = val$i;
                    }

                    public boolean hasNext() {
                        return this.val$i.hasNext();
                    }

                    public Object next() {
                        return this.val$i.next();
                    }

                    public void remove() {
                        throw new UnsupportedOperationException("sets returned by InnigCollections.uniqueCollectionAsSet() are immutable");
                    }
                };
            }
        };
    }

    public static void addAll(Collection c, Iterator i) {
        while (i.hasNext()) {
            c.add(i.next());
        }
    }

    public static void addAll(Collection c, Enumeration e) {
        while (e.hasMoreElements()) {
            c.add(e.nextElement());
        }
    }

    public static List asList(Iterator i) {
        ArrayList l = new ArrayList();
        InnigCollections.addAll(l, i);
        return l;
    }

    public static List asList(Enumeration e) {
        ArrayList l = new ArrayList();
        InnigCollections.addAll(l, e);
        return l;
    }

    public static Iterator asIterator(final Enumeration e) {
        return new Iterator(){

            public boolean hasNext() {
                return e.hasMoreElements();
            }

            public Object next() {
                return e.nextElement();
            }

            public void remove() {
                throw new UnsupportedOperationException("Iterator based on Enumeration doesn't support remove()");
            }
        };
    }

    public static Iterator select(final Iterator iter, final Selector selector) {
        return new Iterator(){
            private boolean dirty = true;
            private Object nextObject;

            /*
             * Unable to fully structure code
             */
            public boolean hasNext() {
                if (this.dirty) ** GOTO lbl7
                return true;
lbl-1000:
                // 1 sources

                {
                    this.nextObject = iter.next();
                    if (!selector.select(this.nextObject)) continue;
                    this.dirty = false;
                    return true;
lbl7:
                    // 2 sources

                    ** while (iter.hasNext())
                }
lbl8:
                // 1 sources

                this.nextObject = null;
                return false;
            }

            public Object next() throws NoSuchElementException {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.dirty = true;
                Object result = this.nextObject;
                this.nextObject = null;
                return result;
            }

            public void remove() throws UnsupportedOperationException, IllegalStateException {
                iter.remove();
            }
        };
    }

    public static Collection select(Collection c, Selector selector) {
        return InnigCollections.asList(InnigCollections.select(c.iterator(), selector));
    }

    public static List select(List l, Selector selector) {
        return InnigCollections.asList(InnigCollections.select(l.iterator(), selector));
    }

    public static Set select(Set s, Selector selector) {
        HashSet out = new HashSet();
        InnigCollections.addAll(out, InnigCollections.select(s.iterator(), selector));
        return out;
    }

    public static Iterator map(final Iterator iter, final Mapper mapper) {
        return new Iterator(){

            public boolean hasNext() {
                return iter.hasNext();
            }

            public Object next() throws NoSuchElementException {
                return mapper.map(iter.next());
            }

            public void remove() throws UnsupportedOperationException, IllegalStateException {
                iter.remove();
            }
        };
    }

    public static void radixSort(List list, Radix radix) {
        int bucketCount = radix.getBase() + 1;
        List[] ibuckets = new List[bucketCount];
        List[] obuckets = new List[bucketCount];
        ibuckets[0] = list;
        int initialBucketSize = list.size() / bucketCount * 4 / 3 + 2;
        boolean first = true;
        int minPos = radix.getMinPositionForAll(list);
        int maxPos = radix.getMaxPositionForAll(list);
        int pos = minPos;
        while (pos <= maxPos) {
            int n = 0;
            while (n < bucketCount) {
                if (ibuckets[n] != null && !ibuckets[n].isEmpty()) {
                    Iterator i = ibuckets[n].iterator();
                    while (i.hasNext()) {
                        Object o = i.next();
                        int digitp1 = radix.digit(o, pos) + 1;
                        ArrayList bucket = obuckets[digitp1];
                        if (bucket == null) {
                            bucket = obuckets[digitp1] = new ArrayList(initialBucketSize);
                        }
                        bucket.add(o);
                    }
                }
                ++n;
            }
            List[] swap = ibuckets;
            ibuckets = obuckets;
            obuckets = swap;
            if (first) {
                first = false;
                obuckets[0] = null;
            } else if (pos < maxPos) {
                int n2 = 0;
                while (n2 < bucketCount) {
                    if (obuckets[n2] != null) {
                        obuckets[n2].clear();
                    }
                    ++n2;
                }
            }
            ++pos;
        }
        if (first) {
            return;
        }
        obuckets = null;
        ListIterator listIter = list.listIterator();
        int n = 0;
        while (n < bucketCount) {
            if (ibuckets[n] != null && !ibuckets[n].isEmpty()) {
                Iterator bucketIter = ibuckets[n].iterator();
                while (bucketIter.hasNext()) {
                    listIter.next();
                    listIter.set(bucketIter.next());
                }
            }
            ++n;
        }
    }

    public static MultiMap inverse(MultiMap multiMap) {
        HashMultiMap out = new HashMultiMap();
        Iterator i = multiMap.entrySet().iterator();
        while (i.hasNext()) {
            MultiMap.Entry entry = (MultiMap.Entry)i.next();
            out.put(entry.getValue(), entry.getKey());
        }
        return out;
    }

    public static MultiMap inverse(Map map) {
        HashMultiMap out = new HashMultiMap();
        Iterator i = map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            out.put(entry.getValue(), entry.getKey());
        }
        return out;
    }

    private static class SynchronizedMultiMap
    implements MultiMap,
    Serializable {
        private MultiMap mm;
        private Object sync;

        public SynchronizedMultiMap(MultiMap mm, Object sync) {
            if (mm == null) {
                throw new IllegalArgumentException("multimap is null");
            }
            if (sync == null) {
                throw new IllegalArgumentException("sync object is null");
            }
            this.mm = mm;
            this.sync = sync;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int size() {
            Object object = this.sync;
            synchronized (object) {
                return this.mm.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEmpty() {
            Object object = this.sync;
            synchronized (object) {
                return this.mm.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsKey(Object key) {
            Object object = this.sync;
            synchronized (object) {
                return this.mm.containsKey(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsValue(Object value) {
            Object object = this.sync;
            synchronized (object) {
                return this.mm.containsValue(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set get(Object key) {
            Object object = this.sync;
            synchronized (object) {
                return this.mm.get(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean put(Object key, Object value) {
            Object object = this.sync;
            synchronized (object) {
                return this.put(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean putAll(Object key, Collection values) {
            Object object = this.sync;
            synchronized (object) {
                return this.putAll(key, values);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove(Object key, Object value) {
            Object object = this.sync;
            synchronized (object) {
                return this.remove(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set removeKey(Object key) {
            Object object = this.sync;
            synchronized (object) {
                return this.removeKey(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void putAll(MultiMap multimap) {
            Object object = this.sync;
            synchronized (object) {
                this.putAll(multimap);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void putAll(Map map) {
            Object object = this.sync;
            synchronized (object) {
                this.putAll(map);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            Object object = this.sync;
            synchronized (object) {
                this.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set keySet() {
            Object object = this.sync;
            synchronized (object) {
                return this.mm.keySet();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection values() {
            Object object = this.sync;
            synchronized (object) {
                return this.mm.values();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set entrySet() {
            Object object = this.sync;
            synchronized (object) {
                return this.mm.entrySet();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean equals(Object o) {
            Object object = this.sync;
            synchronized (object) {
                return this.mm.equals(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int hashCode() {
            Object object = this.sync;
            synchronized (object) {
                return this.mm.hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Object object = this.sync;
            synchronized (object) {
                return this.mm.toString();
            }
        }
    }

    private static class UnmodifiableMultiMap
    implements MultiMap,
    Serializable {
        private MultiMap mm;
        private final String unsupported = "multimap is immutable";

        public UnmodifiableMultiMap(MultiMap mm) {
            if (mm == null) {
                throw new IllegalArgumentException("multimap is null");
            }
            this.mm = mm;
        }

        public int size() {
            return this.mm.size();
        }

        public boolean isEmpty() {
            return this.mm.isEmpty();
        }

        public boolean containsKey(Object key) {
            return this.mm.containsKey(key);
        }

        public boolean containsValue(Object value) {
            return this.mm.containsValue(value);
        }

        public Set get(Object key) {
            return Collections.unmodifiableSet(this.mm.get(key));
        }

        public boolean put(Object key, Object value) {
            throw new UnsupportedOperationException("multimap is immutable");
        }

        public boolean putAll(Object key, Collection values) {
            throw new UnsupportedOperationException("multimap is immutable");
        }

        public boolean remove(Object key, Object value) {
            throw new UnsupportedOperationException("multimap is immutable");
        }

        public Set removeKey(Object key) {
            throw new UnsupportedOperationException("multimap is immutable");
        }

        public void putAll(MultiMap multimap) {
            throw new UnsupportedOperationException("multimap is immutable");
        }

        public void putAll(Map map) {
            throw new UnsupportedOperationException("multimap is immutable");
        }

        public void clear() {
            throw new UnsupportedOperationException("multimap is immutable");
        }

        public Set keySet() {
            return Collections.unmodifiableSet(this.mm.keySet());
        }

        public Collection values() {
            return Collections.unmodifiableCollection(this.mm.values());
        }

        public Set entrySet() {
            return Collections.unmodifiableSet(this.mm.entrySet());
        }

        public boolean equals(Object o) {
            return this.mm.equals(o);
        }

        public int hashCode() {
            return this.mm.hashCode();
        }

        public String toString() {
            return this.mm.toString();
        }
    }
}

