/*
 * Decompiled with CFR 0.152.
 */
package net.innig.collect;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.innig.collect.Radix;

public class IntegralRadix
implements Radix,
Serializable {
    private static Map defaultRadices;
    private final int numberBits;
    private final int digitBits;
    private final int base;
    private final int maxDigits;
    private final boolean signed;
    private final long signCorrection;
    private final long signAntiCorrection;
    static /* synthetic */ Class class$net$innig$collect$Radix;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;

    public static int bitsNeeded(long n, boolean signed) {
        int numberBits = 1;
        if (signed && n < 0L) {
            n = -n;
            numberBits = 2;
        }
        while ((n >>>= 1) != 0L) {
            ++numberBits;
        }
        return numberBits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Radix forType(Class numberType) {
        Class clazz = class$net$innig$collect$Radix == null ? (class$net$innig$collect$Radix = IntegralRadix.class$("net.innig.collect.Radix")) : class$net$innig$collect$Radix;
        synchronized (clazz) {
            if (defaultRadices == null) {
                defaultRadices = new HashMap();
                defaultRadices.put(class$java$lang$Byte == null ? (class$java$lang$Byte = IntegralRadix.class$("java.lang.Byte")) : class$java$lang$Byte, new IntegralRadix(8, 8, true));
                defaultRadices.put(class$java$lang$Short == null ? (class$java$lang$Short = IntegralRadix.class$("java.lang.Short")) : class$java$lang$Short, new IntegralRadix(16, 8, true));
                defaultRadices.put(class$java$lang$Integer == null ? (class$java$lang$Integer = IntegralRadix.class$("java.lang.Integer")) : class$java$lang$Integer, new IntegralRadix(32, 8, true));
                defaultRadices.put(class$java$lang$Long == null ? (class$java$lang$Long = IntegralRadix.class$("java.lang.Long")) : class$java$lang$Long, new IntegralRadix(64, 8, true));
            }
        }
        Radix radix = (Radix)defaultRadices.get(numberType);
        if (radix != null) {
            return radix;
        }
        throw new IllegalArgumentException(numberType + " must be Byte, Short, Integer, or Long");
    }

    public IntegralRadix(int numberBits, int digitBits, boolean signed) {
        if (numberBits < 1 || numberBits > 64) {
            throw new IllegalArgumentException("invalid numberBits (" + numberBits + ")");
        }
        if (digitBits > 30) {
            throw new IllegalArgumentException("invalid digitBits (" + digitBits + " > 30)");
        }
        if (numberBits % digitBits != 0) {
            throw new IllegalArgumentException("digitBits=" + digitBits + " does not divide numberBits=" + numberBits);
        }
        this.numberBits = numberBits;
        this.digitBits = digitBits;
        this.signed = signed;
        this.base = 1 << digitBits;
        this.maxDigits = numberBits / digitBits;
        this.signCorrection = signed ? 1L << numberBits - 1 : 0L;
        this.signAntiCorrection = !signed ? 1L << numberBits - 1 : 0L;
    }

    public int getBase() {
        return this.base;
    }

    public int digit(Object o, int pos) {
        return pos < 0 ? -1 : (int)((((Number)o).longValue() ^ this.signCorrection) >>> pos * this.digitBits) & this.base - 1;
    }

    public int getMaxPosition(Object o) {
        return this.maxDigits - 1;
    }

    public int getMinPosition(Object o) {
        return 0;
    }

    public int getMaxPositionForAll(Collection values) {
        return this.maxDigits - 1;
    }

    public int getMinPositionForAll(Collection values) {
        return 0;
    }

    public Object objectFromDigits(int[] digits) {
        return this.objectFromDigits(digits, 0, digits.length);
    }

    public Object objectFromDigits(int[] digits, int offset, int len) {
        if (len > this.maxDigits) {
            throw new IllegalArgumentException("too many digits (" + len + " > " + this.maxDigits + ")");
        }
        long value = this.signed && (digits[offset + len - 1] & this.base >> 1) != 0 ? -1L : 0L;
        int n = offset + len - 1;
        while (n >= offset) {
            value = (value << this.digitBits) + (long)digits[n];
            --n;
        }
        if (this.numberBits <= 8) {
            return new Byte((byte)value);
        }
        if (this.numberBits <= 16) {
            return new Short((short)value);
        }
        if (this.numberBits <= 32) {
            return new Integer((int)value);
        }
        return new Long(value);
    }

    public int compare(Object aObj, Object bObj) {
        long b;
        long a = this.normalizeForCompare(((Number)aObj).longValue());
        return a == (b = this.normalizeForCompare(((Number)bObj).longValue())) ? 0 : (a < b ? -1 : 1);
    }

    private long normalizeForCompare(long x) {
        return (x ^ this.signAntiCorrection) << 64 - this.numberBits >> 64 - this.numberBits;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        IntegralRadix thatIR = (IntegralRadix)that;
        return this.numberBits == thatIR.numberBits && this.digitBits == thatIR.digitBits && this.signed == thatIR.signed;
    }

    public int hashCode() {
        return ((this.getClass().hashCode() * 17 + this.numberBits) * 23 + this.digitBits) * 29 + (this.signed ? 1 : 0);
    }

    public String toString() {
        return "IntegralRadix[numberBits=" + this.numberBits + ", digitBits=" + this.digitBits + ", " + (this.signed ? "" : "un") + "signed]";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

