/*
 * Decompiled with CFR 0.152.
 */
package net.innig.collect;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import net.innig.collect.CollectionDiff;
import net.innig.collect.ListMutator;

public class ListDiff
extends CollectionDiff {
    private List oldStuff;
    private List newStuff;
    private List steps;

    public static void main(String[] args) throws Exception {
        block0: while (true) {
            System.out.println();
            System.out.println();
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            LinkedList<String> a = new LinkedList<String>();
            LinkedList<String> b = new LinkedList<String>();
            System.out.print("Old: ");
            StringTokenizer st = new StringTokenizer(in.readLine());
            while (st.hasMoreTokens()) {
                a.add(st.nextToken());
            }
            System.out.print("New: ");
            st = new StringTokenizer(in.readLine());
            while (st.hasMoreTokens()) {
                b.add(st.nextToken());
            }
            Iterator i = new ListDiff(a, b).getSteps();
            while (true) {
                if (!i.hasNext()) continue block0;
                System.out.println(i.next());
            }
            break;
        }
    }

    public ListDiff(List oldStuff, List newStuff) {
        super(oldStuff, newStuff, true);
        this.oldStuff = oldStuff;
        this.newStuff = newStuff;
        this.calculateSteps();
    }

    public Iterator getSteps() {
        return this.steps.iterator();
    }

    public void applySteps(ListMutator mutator) {
        Iterator i = this.getSteps();
        while (i.hasNext()) {
            Step step = (Step)i.next();
            if (step instanceof Insert) {
                mutator.insert(step.getObject(), step.getIndex());
                continue;
            }
            if (step instanceof Remove) {
                mutator.remove(step.getObject(), step.getIndex());
                continue;
            }
            if (!(step instanceof Move)) continue;
            mutator.move(step.getObject(), step.getIndex(), ((Move)step).getToIndex());
        }
    }

    public boolean equals(Object other) {
        ListDiff otherdiff = (ListDiff)other;
        return otherdiff.oldStuff.equals(this.oldStuff) && otherdiff.newStuff.equals(this.newStuff);
    }

    private void calculateSteps() {
        this.steps = new LinkedList();
        ArrayList oldWork = new ArrayList(this.oldStuff);
        ArrayList newWork = new ArrayList(this.newStuff);
        int curPos = 0;
        while (curPos < oldWork.size() && curPos < newWork.size()) {
            Object nextObject = newWork.get(curPos);
            int oldPos = -1;
            int j = curPos;
            while (j < oldWork.size()) {
                if (oldWork.get(j).equals(nextObject)) {
                    oldPos = j;
                    break;
                }
                ++j;
            }
            if (oldPos == -1) {
                this.steps.add(new Insert(nextObject, curPos));
                oldWork.add(curPos, nextObject);
            } else if (curPos != oldPos) {
                this.steps.add(new Move(nextObject, oldPos, curPos));
                oldWork.remove(oldPos);
                oldWork.add(curPos, nextObject);
            }
            ++curPos;
        }
        while (curPos < newWork.size()) {
            this.steps.add(new Insert(newWork.get(curPos), curPos));
            ++curPos;
        }
        int j = curPos;
        while (j < oldWork.size()) {
            this.steps.add(new Remove(oldWork.get(curPos), curPos));
            ++j;
        }
    }

    public final class Move
    extends Step {
        private int toIndex;

        public Move(Object object, int index, int toIndex) {
            super(object, index);
            this.toIndex = toIndex;
        }

        public int getToIndex() {
            return this.toIndex;
        }

        public String toString() {
            return "Insert " + this.getObject() + " from position " + this.getIndex() + " to " + this.getToIndex();
        }
    }

    public final class Remove
    extends Step {
        public Remove(Object object, int index) {
            super(object, index);
        }

        public String toString() {
            return "Remove " + this.getObject() + " at position " + this.getIndex();
        }
    }

    public final class Insert
    extends Step {
        public Insert(Object object, int index) {
            super(object, index);
        }

        public String toString() {
            return "Insert " + this.getObject() + " at position " + this.getIndex();
        }
    }

    public abstract class Step {
        private Object object;
        private int index;

        Step(Object object, int index) {
            this.index = index;
            this.object = object;
        }

        public Object getObject() {
            return this.object;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

