/*
 * Decompiled with CFR 0.152.
 */
package net.innig.collect;

import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.innig.collect.Radix;
import net.innig.util.EnumeratedType;

public class RadixMap
extends AbstractMap {
    private int size;
    private Radix radix;
    private RadixTree root;
    private Set keys;
    private Set entries;
    private Collection values;
    private transient long version;

    public RadixMap(Radix radix) {
        this.radix = radix;
    }

    public RadixMap(Radix radix, Map otherMap) {
        this(radix);
        this.putAll(otherMap);
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean containsKey(Object key) {
        RadixTree tree = this.getRadixTree(key, false);
        return tree == null ? true : tree.hasValue();
    }

    public Object get(Object key) {
        RadixTree tree = this.getRadixTree(key, false);
        return tree == null ? null : tree.getValue();
    }

    public Object put(Object key, Object value) {
        RadixTree tree = this.getRadixTree(key, true);
        Object oldValue = tree.getValue();
        tree.setValue(value);
        ++this.size;
        ++this.version;
        return oldValue;
    }

    public Object remove(Object key) {
        RadixTree tree = this.getRadixTree(key, false);
        if (tree == null || !tree.hasValue()) {
            return null;
        }
        Object oldValue = tree.getValue();
        tree.removeValue();
        --this.size;
        ++this.version;
        return oldValue;
    }

    public void clear() {
        ++this.version;
        this.size = 0;
        this.root = null;
    }

    public Set keySet() {
        if (this.keys == null) {
            this.keys = new AbstractSet(){

                public java.util.Iterator iterator() {
                    return new Iterator(RadixMap.this.root.getInitialPosition(), RadixMap.this.root, IteratorType.ENTRIES);
                }

                public int size() {
                    return RadixMap.this.size;
                }

                public boolean remove(Object obj) {
                    return RadixMap.this.remove(obj) != null;
                }

                public void clear() {
                    RadixMap.this.clear();
                }
            };
        }
        return this.keys;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new AbstractCollection(){

                public java.util.Iterator iterator() {
                    return new Iterator(RadixMap.this.root.getInitialPosition(), RadixMap.this.root, IteratorType.VALUES);
                }

                public int size() {
                    return RadixMap.this.size();
                }

                public void clear() {
                    RadixMap.this.clear();
                }
            };
        }
        return this.values;
    }

    public Set entrySet() {
        if (this.entries == null) {
            this.entries = new AbstractSet(){

                public java.util.Iterator iterator() {
                    return new Iterator(RadixMap.this.root.getInitialPosition(), RadixMap.this.root, IteratorType.ENTRIES);
                }

                public int size() {
                    return RadixMap.this.size;
                }

                public boolean remove(Object obj) {
                    if (!(obj instanceof Entry)) {
                        return false;
                    }
                    Entry entry = (Entry)obj;
                    return RadixMap.this.remove(entry.getKey()) != null;
                }

                public void clear() {
                    RadixMap.this.clear();
                }
            };
        }
        return this.entries;
    }

    public Radix getRadix() {
        return this.radix;
    }

    private RadixTree getRadixTree(Object value, boolean create) {
        int valueMaxPos = this.radix.getMaxPosition(value);
        int valueMinPos = this.radix.getMinPosition(value);
        if (this.root == null || this.root.getInitialPosition() < valueMaxPos) {
            if (!create) {
                return null;
            }
            this.root = new RadixTree(value, valueMaxPos, valueMinPos);
        }
        RadixTree curTree = this.root;
        int pos = valueMaxPos;
        while (pos >= valueMinPos) {
            int digit = this.radix.digit(value, pos);
            RadixTree nextTree = curTree.getChild(pos, digit);
            if (nextTree == null) {
                if (!create) {
                    return null;
                }
                nextTree = new RadixTree(value, pos - 1, valueMinPos);
                curTree.setChild(pos, digit, nextTree);
            }
            curTree = nextTree;
            --pos;
        }
        return curTree;
    }

    public String toString() {
        return this.getClass().getName();
    }

    public void dump() {
        this.root.dumpTree(0);
    }

    private class Iterator
    implements java.util.Iterator {
        private final int position;
        private final RadixTree tree;
        private final IteratorType type;
        private long expectedVersion;
        private int curDigit;
        private int nextDigit;
        private Iterator curIter;
        private Iterator nextIter;
        private boolean handledValue;

        public Iterator(int position, RadixTree tree, IteratorType type) {
            this.position = position;
            this.tree = tree;
            this.type = type;
            this.expectedVersion = RadixMap.this.version;
            this.curDigit = -1;
            if (tree != null) {
                this.handledValue = !tree.hasValue();
            }
        }

        public boolean hasNext() {
            this.checkModification();
            if (this.tree == null) {
                return false;
            }
            if (this.curIter != null && this.curIter.hasNext()) {
                return true;
            }
            if (!this.handledValue) {
                return true;
            }
            this.nextDigit = this.curDigit + 1;
            while (this.nextDigit < RadixMap.this.radix.getBase()) {
                RadixTree subTree = this.tree.getChild(this.position, this.nextDigit);
                if (subTree != null) {
                    this.nextIter = new Iterator(this.position - 1, subTree, this.type);
                    if (this.nextIter.hasNext()) {
                        return true;
                    }
                }
                ++this.nextDigit;
            }
            return false;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (!this.handledValue) {
                this.handledValue = true;
                if (this.type == IteratorType.VALUES) {
                    return this.tree.getValue();
                }
                throw new UnsupportedOperationException();
            }
            this.curDigit = this.nextDigit;
            this.curIter = this.nextIter;
            return this.curIter.next();
        }

        public void remove() {
            if (this.curIter != null) {
                this.curIter.remove();
                this.expectedVersion = RadixMap.this.version;
                return;
            }
            this.checkModification();
            if (this.tree == null || !this.tree.hasValue()) {
                throw new IllegalStateException("no element to remove");
            }
            this.tree.removeValue();
            RadixMap.this.size--;
            this.expectedVersion = ++RadixMap.this.version;
        }

        private void checkModification() {
            if (RadixMap.this.version != this.expectedVersion) {
                throw new ConcurrentModificationException("radix map modified (" + RadixMap.this.version + " != " + this.expectedVersion + ")");
            }
        }
    }

    private static class IteratorType
    extends EnumeratedType {
        public static final IteratorType KEYS = new IteratorType("keys");
        public static final IteratorType VALUES = new IteratorType("values");
        public static final IteratorType ENTRIES = new IteratorType("entries");

        private IteratorType(String name) {
            super(name);
        }
    }

    private class Entry
    implements Map.Entry {
        private Object key;
        private Object value;

        public Entry(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            Object oldValue = value;
            this.value = value;
            return oldValue;
        }

        public boolean equals(Object that) {
            if (this == that) {
                return true;
            }
            if (that == null || !(that instanceof Map.Entry)) {
                return false;
            }
            Map.Entry thatEntry = (Map.Entry)that;
            return this.key.equals(thatEntry.getKey()) && (this.value == null ? thatEntry.getValue() == null : this.value.equals(thatEntry.getValue()));
        }

        public int hashCode() {
            return this.key.hashCode() + (this.value == null ? 0 : this.value.hashCode() * 23);
        }
    }

    private class RadixTree {
        private int minPos;
        private int maxPos;
        private boolean hasValue;
        private Object value;
        private int childCount;
        private RadixTree[] children;

        public RadixTree(Object value, int maxPos, int minPos) {
            this.minPos = this.maxPos = maxPos;
            if (minPos <= maxPos) {
                this.setChild(maxPos, RadixMap.this.radix.digit(value, maxPos), new RadixTree(value, maxPos - 1, minPos));
            }
        }

        public int getInitialPosition() {
            return this.minPos;
        }

        public RadixTree getChild(int position, int digit) {
            if (position < this.minPos || position > this.maxPos) {
                throw new IllegalArgumentException("illegal position (" + position + " not in [" + this.minPos + "," + this.maxPos + "])");
            }
            if (this.children == null) {
                return null;
            }
            return this.children[digit];
        }

        public void setChild(int position, int digit, RadixTree tree) {
            if (position < this.minPos || position > this.maxPos) {
                throw new IllegalArgumentException("illegal position (" + position + " not in [" + this.minPos + "," + this.maxPos + "])");
            }
            if (digit < 0 || digit > RadixMap.this.radix.getBase()) {
                throw new IllegalArgumentException("illegal digit (" + digit + " not in [" + 0 + "," + (this.children.length - 1) + "])");
            }
            if (this.children == null) {
                this.children = new RadixTree[RadixMap.this.radix.getBase()];
            }
            if (this.children[digit] == null != (tree == null)) {
                this.childCount += tree == null ? -1 : 1;
            }
            this.children[digit] = tree;
        }

        public boolean hasValue() {
            return this.hasValue;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.hasValue = true;
            this.value = value;
        }

        public void removeValue() {
            this.hasValue = false;
            this.value = null;
        }

        public boolean isEmpty() {
            return !this.hasValue && this.childCount == 0;
        }

        public void dumpTree(int i) {
            int n = i;
            while (n > 0) {
                System.out.print(' ');
                --n;
            }
            System.out.println("tree @ " + this.maxPos);
            if (this.hasValue) {
                int n2 = i;
                while (n2 > 0) {
                    System.out.print(' ');
                    --n2;
                }
                System.out.println("value: " + this.value);
            }
            if (this.children != null) {
                int child = 0;
                while (child < this.children.length) {
                    if (this.children[child] != null) {
                        int n3 = i;
                        while (n3 > 0) {
                            System.out.print(' ');
                            --n3;
                        }
                        System.out.println(child + ": ");
                        this.children[child].dumpTree(i + 3);
                    }
                    ++child;
                }
            }
        }
    }
}

