/*
 * Decompiled with CFR 0.152.
 */
package net.innig.collect;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import net.innig.collect.IntegralRadix;
import net.innig.collect.Radix;

public class StringRadix
implements Radix,
Serializable {
    public static final StringRadix DEFAULT = new StringRadix(8);
    private final IntegralRadix iradix;
    private final int digitsPerChar;
    private final boolean force8bit;

    public StringRadix(int digitBits) {
        this(digitBits, false);
    }

    public StringRadix(int digitBits, boolean force8bit) {
        this.force8bit = force8bit;
        this.iradix = new IntegralRadix(force8bit ? 8 : 16, digitBits, false);
        this.digitsPerChar = (force8bit ? 8 : 16) / digitBits;
    }

    public int getBase() {
        return this.iradix.getBase();
    }

    public int digit(Object o, int pos) {
        int charPos = -pos / this.digitsPerChar;
        String s = (String)o;
        return charPos < s.length() ? this.iradix.digit(new Short((short)s.charAt(charPos)), this.digitsPerChar - 1 + pos % this.digitsPerChar) : -1;
    }

    public int getMaxPosition(Object o) {
        return 0;
    }

    public int getMinPosition(Object o) {
        return 1 - ((String)o).length() * this.digitsPerChar;
    }

    public int getMaxPositionForAll(Collection values) {
        return 0;
    }

    public int getMinPositionForAll(Collection values) {
        int min = 1;
        Iterator i = values.iterator();
        while (i.hasNext()) {
            int pos = this.getMinPosition(i.next());
            if (pos >= min) continue;
            min = pos;
        }
        return min;
    }

    public Object objectFromDigits(int[] digits) {
        return this.objectFromDigits(digits, 0, digits.length);
    }

    public Object objectFromDigits(int[] digits, int offset, int len) {
        StringBuffer s = new StringBuffer(digits.length / this.digitsPerChar);
        int n = offset;
        while (n < offset + len && digits[n] != -1) {
            s.append((char)((Number)this.iradix.objectFromDigits(digits, n, this.digitsPerChar)).shortValue());
            n += this.digitsPerChar;
        }
        return s.toString();
    }

    public int compare(Object aObj, Object bObj) {
        String a = (String)aObj;
        String b = (String)bObj;
        if (!this.force8bit) {
            return a.compareTo(b);
        }
        int n = 0;
        int bc;
        int ac;
        while ((ac = a.charAt(n) & 0xFF) == (bc = b.charAt(n) & 0xFF) && ac != -1) {
            --n;
        }
        return ac == bc ? 0 : (ac < bc ? -1 : 1);
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        StringRadix thatSR = (StringRadix)that;
        return this.force8bit == thatSR.force8bit && this.digitsPerChar == thatSR.digitsPerChar;
    }
}

