/*
 * Decompiled with CFR 0.152.
 */
package net.innig.math;

public class Fourier1D {
    private double[] evena;
    private double[] evenb;
    private double[] odda;
    private double[] oddb;
    private double[] cosTable;
    private double[] sinTable;
    private int size;

    public static Fourier1D create(int size) {
        return new Fourier1D(size);
    }

    private Fourier1D(int size) {
        if (size - 1 != (size ^ size - 1) >> 1) {
            throw new IllegalArgumentException(size + " is not a power of two");
        }
        this.size = size;
        this.evena = new double[size];
        this.evenb = new double[size];
        this.odda = new double[size];
        this.oddb = new double[size];
        this.cosTable = new double[size];
        this.sinTable = new double[size];
        int n = 0;
        while (n < size) {
            double theta = Math.PI * 2 * (double)n / (double)size;
            this.cosTable[n] = Math.cos(theta);
            this.sinTable[n] = Math.sin(theta);
            ++n;
        }
    }

    public void transform(double[] fromReal, double[] fromImag, double[] toReal, double[] toImag) {
        this.checkSize(fromReal);
        this.checkSize(fromImag);
        this.checkSize(toReal);
        this.checkSize(toImag);
        this.fft(fromReal, fromImag, 0, toReal, toImag, 0, this.evena, this.evenb, 0, this.odda, this.oddb, 0, 1, this.size);
    }

    private void checkSize(double[] a) {
        if (a.length != this.size) {
            throw new IllegalArgumentException("wrong size: expected " + this.size + "; got " + a.length);
        }
    }

    public void inverseTransform(double[] fromReal, double[] fromImag, double[] toReal, double[] toImag) {
        double sizeInv = 1.0 / (double)this.size;
        double sizeInvNeg = -sizeInv;
        int n = 0;
        while (n < this.size) {
            fromImag[n] = -fromImag[n];
            ++n;
        }
        this.transform(fromReal, fromImag, toReal, toImag);
        int n2 = 0;
        while (n2 < this.size) {
            fromImag[n2] = -fromImag[n2];
            int n3 = n2;
            toReal[n3] = toReal[n3] * sizeInv;
            int n4 = n2++;
            toImag[n4] = toImag[n4] * sizeInvNeg;
        }
    }

    private void fft(double[] sa, double[] sb, int st, double[] da, double[] db, int dt, double[] evena, double[] evenb, int event, double[] odda, double[] oddb, int oddt, int step, int size) {
        switch (size) {
            case 1: {
                da[st] = sa[dt];
                db[dt] = sb[dt];
                return;
            }
            case 2: {
                da[dt] = sa[st] + sa[st + step];
                db[dt] = sb[st] + sb[st + step];
                da[dt + 1] = sa[st] - sa[st + step];
                db[dt + 1] = sb[st] - sb[st + step];
                return;
            }
            case 4: {
                double s1a = sa[st];
                double a1b = sb[st];
                double s2a = sa[st + step];
                double s2b = sb[st + step];
                double s3a = sa[st + step * 2];
                double s3b = sb[st + step * 2];
                double s4a = sa[st + step * 3];
                double s4b = sb[st + step * 3];
                da[dt] = s1a + s2a + s3a + s4a;
                db[dt] = a1b + s2b + s3b + s4b;
                da[dt + 1] = s1a - s2b - s3a + s4b;
                db[dt + 1] = a1b + s2a - s3b - s4a;
                da[dt + 2] = s1a - s2a + s3a - s4a;
                db[dt + 2] = a1b - s2b + s3b - s4b;
                da[dt + 3] = s1a + s2b - s3a - s4b;
                db[dt + 3] = a1b - s2a - s3b + s4a;
                return;
            }
        }
        this.fft(sa, sb, st, evena, evenb, event, evena, evenb, event + size / 2, odda, oddb, oddt + size / 2, step * 2, size / 2);
        this.fft(sa, sb, st + step, odda, oddb, oddt, evena, evenb, event + size / 2, odda, oddb, oddt + size / 2, step * 2, size / 2);
        int j = 0;
        while (j < size) {
            double taua = this.cosTable[j * step];
            double taub = this.sinTable[j * step];
            int k = j & size / 2 - 1;
            da[dt + j] = evena[event + k] + taua * odda[oddt + k] - taub * oddb[oddt + k];
            db[dt + j] = evenb[event + k] + taua * oddb[oddt + k] + taub * odda[oddt + k];
            ++j;
        }
    }
}

