/*
 * Decompiled with CFR 0.152.
 */
package net.innig.util;

import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.innig.collect.InnigCollections;
import net.innig.io.NullOutputStream;
import net.innig.util.CorruptConfigurationException;
import net.innig.util.MissingConfigurationException;

public abstract class Conf {
    private static Map mergedPropCache = new HashMap();

    public static Properties getMergedProperties(String confName) {
        return Conf.getMergedProperties(null, confName);
    }

    public static Properties getMergedProperties(String confName, ClassLoader classLoader) {
        return Conf.getMergedProperties(null, confName, classLoader);
    }

    public static Properties getMergedProperties(Class owner, String confName) {
        return Conf.getMergedProperties(owner, confName, Thread.currentThread().getContextClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Properties getMergedProperties(Class owner, String confName, ClassLoader classLoader) {
        Map map = mergedPropCache;
        synchronized (map) {
            String resource = owner == null ? Conf.confToResourceName(confName) : Conf.confToResourceName(owner, confName);
            Properties props = (Properties)mergedPropCache.get(resource);
            if (props == null) {
                PrintStream realOut = System.out;
                PrintStream realErr = System.err;
                try {
                    try {
                        System.setOut(new PrintStream(new NullOutputStream()));
                        System.setErr(new PrintStream(new NullOutputStream()));
                        props = new Properties();
                        Enumeration<URL> enumeration = classLoader.getResources(resource);
                        if (enumeration == null || !enumeration.hasMoreElements()) {
                            throw new MissingConfigurationException(confName, resource);
                        }
                        List urls = InnigCollections.asList(enumeration);
                        Collections.reverse(urls);
                        Iterator i = urls.iterator();
                        while (true) {
                            if (!i.hasNext()) {
                                mergedPropCache.put(resource, props);
                                break;
                            }
                            props.load(((URL)i.next()).openStream());
                        }
                    }
                    catch (IOException ioe) {
                        throw new CorruptConfigurationException(confName, ioe);
                    }
                    Object var12_12 = null;
                }
                catch (Throwable throwable) {
                    Object var12_13 = null;
                    System.setOut(realOut);
                    System.setErr(realErr);
                    throw throwable;
                }
                System.setOut(realOut);
                System.setErr(realErr);
            }
            return props;
        }
    }

    public static String confToResourceName(Class owner, String confName) {
        String ownerName = owner.getName();
        return Conf.confToResourceName(ownerName.substring(ownerName.lastIndexOf(46) + 1) + '.' + confName);
    }

    public static String confToResourceName(String confName) {
        int next;
        StringBuffer resName = new StringBuffer();
        int pos = 0;
        while ((next = confName.indexOf(46, pos)) != -1) {
            resName.append(confName.substring(pos, next));
            resName.append('/');
            pos = next + 1;
        }
        resName.append(confName.substring(pos));
        resName.append(".properties");
        return resName.toString();
    }

    private Conf() {
    }
}

