/*
 * Decompiled with CFR 0.152.
 */
package net.innig.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;

public class DelegatingProxy
implements InvocationHandler {
    public static final InvocationHandler UNSUPPORTED_OPERATION_HANDLER = new InvocationHandler(){

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            throw new UnsupportedOperationException();
        }
    };
    private final Object[] delegates;
    private final InvocationHandler finalHandler;
    private Map methodCache;

    public static Object newProxyInstance(Class iface, Object[] delegates) {
        return Proxy.newProxyInstance(iface.getClassLoader(), new Class[]{iface}, (InvocationHandler)new DelegatingProxy(delegates));
    }

    public static Object newProxyInstance(Class iface, Object[] delegates, InvocationHandler finalHandler) {
        return Proxy.newProxyInstance(iface.getClassLoader(), new Class[]{iface}, (InvocationHandler)new DelegatingProxy(delegates, finalHandler));
    }

    public static Object newProxyInstance(ClassLoader classLoader, Class[] interfaces, Object[] delegates) {
        return Proxy.newProxyInstance(classLoader, interfaces, (InvocationHandler)new DelegatingProxy(delegates));
    }

    public static Object newProxyInstance(ClassLoader classLoader, Class[] interfaces, Object[] delegates, InvocationHandler finalHandler) {
        return Proxy.newProxyInstance(classLoader, interfaces, (InvocationHandler)new DelegatingProxy(delegates, finalHandler));
    }

    public DelegatingProxy(Object[] delegates) {
        this(delegates, UNSUPPORTED_OPERATION_HANDLER);
    }

    public DelegatingProxy(Object[] delegates, InvocationHandler finalHandler) {
        this.delegates = delegates;
        this.finalHandler = finalHandler;
        this.methodCache = new HashMap();
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        int n = 0;
        while (n < this.delegates.length) {
            try {
                return this.delegates[n].getClass().getMethod(method.getName(), method.getParameterTypes()).invoke(this.delegates[n], args);
            }
            catch (NoSuchMethodException nsme) {
            }
            catch (IllegalArgumentException iae) {
            }
            catch (IllegalAccessException iae2) {
            }
            catch (InvocationTargetException ite) {
                throw ite.getTargetException();
            }
            ++n;
        }
        return this.finalHandler.invoke(proxy, method, args);
    }
}

