/*
 * Decompiled with CFR 0.152.
 */
package net.innig.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.innig.collect.GraphWalker;
import net.innig.collect.Graphs;
import net.innig.collect.HashMultiMap;
import net.innig.collect.MultiMap;
import net.innig.util.EnumeratedType;

public abstract class GraphType
extends EnumeratedType {
    private static final MultiMap childMap = new HashMultiMap();
    private static final MultiMap descendentMap = new HashMultiMap();
    private transient Set parents;
    private transient Set ancestors;
    private transient Set children;
    private transient Set descendents;

    public GraphType(String name) {
        this(name, Collections.EMPTY_SET);
    }

    public GraphType(String name, GraphType parent) {
        this(name, Collections.singleton(parent));
    }

    public GraphType(String name, GraphType[] parents) {
        this(name, Arrays.asList(parents));
    }

    public GraphType(String name, Collection parents) {
        super(name);
        this.setParents(parents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setParents(Collection parents) {
        if (parents == null) {
            throw new IllegalArgumentException("parents == null");
        }
        if (this.parents != null) {
            throw new IllegalArgumentException("You can only set the parents once. Sorry.");
        }
        this.parents = Collections.unmodifiableSet(new HashSet(parents));
        this.ancestors = Collections.unmodifiableSet(Graphs.reachableNodes(this, new GraphWalker(){

            public Collection getEdgesFrom(Object node) {
                return ((GraphType)node).getParents();
            }
        }));
        MultiMap multiMap = childMap;
        synchronized (multiMap) {
            Iterator i = parents.iterator();
            while (i.hasNext()) {
                childMap.put(i.next(), this);
            }
            Iterator i2 = this.ancestors.iterator();
            while (i2.hasNext()) {
                descendentMap.put(i2.next(), this);
            }
        }
    }

    public boolean is(GraphType that) {
        return this.getAncestors().contains(that);
    }

    public Set getParents() {
        return this.parents;
    }

    public Set getAncestors() {
        return this.ancestors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getChildren() {
        MultiMap multiMap = childMap;
        synchronized (multiMap) {
            return this.emptyIfNull(childMap.get(this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getDescendents() {
        MultiMap multiMap = childMap;
        synchronized (multiMap) {
            return this.emptyIfNull(descendentMap.get(this));
        }
    }

    private Set emptyIfNull(Set s) {
        return s == null ? Collections.EMPTY_SET : s;
    }
}

