/*
 * Decompiled with CFR 0.152.
 */
package net.innig.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import net.innig.collect.GraphWalker;
import net.innig.collect.Graphs;
import net.innig.collect.InnigCollections;
import net.innig.collect.Selector;
import net.innig.util.DelegatingProxy;

public abstract class LoggingProxy
extends DelegatingProxy {
    private Object delegate;

    public static Object newProxyInstance(Object delegate, LoggingProxy logger) {
        Set interfaces = InnigCollections.select(Graphs.reachableNodes(delegate.getClass(), new GraphWalker(){

            public Collection getEdgesFrom(Object node) {
                Class parent = (Class)node;
                ArrayList edges = new ArrayList(Arrays.asList(parent.getInterfaces()));
                if (parent.getSuperclass() != null) {
                    edges.add(parent.getSuperclass());
                }
                return edges;
            }
        }), new Selector(){

            public boolean select(Object o) {
                return ((Class)o).isInterface();
            }
        });
        return Proxy.newProxyInstance(delegate.getClass().getClassLoader(), new ArrayList(interfaces).toArray(new Class[0]), (InvocationHandler)logger);
    }

    public LoggingProxy(Object delegate) {
        super(new Object[]{delegate});
        this.delegate = delegate;
    }

    public LoggingProxy(Object delegate, InvocationHandler finalHandler) {
        super(new Object[]{delegate}, finalHandler);
        this.delegate = delegate;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        this.logStart(proxy, method, args);
        long startTime = System.currentTimeMillis();
        try {
            Object result = super.invoke(proxy, method, args);
            this.logEnd(proxy, method, args, result, System.currentTimeMillis() - startTime);
            return result;
        }
        catch (Throwable t) {
            this.logError(proxy, method, args, t, System.currentTimeMillis() - startTime);
            throw t;
        }
    }

    public String getDelegateName() {
        return this.getDelegate().getClass().getName();
    }

    protected abstract void logStart(Object var1, Method var2, Object[] var3);

    protected abstract void logEnd(Object var1, Method var2, Object[] var3, Object var4, long var5);

    protected abstract void logError(Object var1, Method var2, Object[] var3, Throwable var4, long var5);

    protected String getStartMessage(Object proxy, Method method, Object[] args) {
        return "-> " + this.getDelegateName() + '.' + method.getName() + this.paramsToString(method);
    }

    protected String getEndMessage(Object proxy, Method method, Object[] args, Object result, long time) {
        return "<- " + this.getDelegateName() + '.' + method.getName() + this.paramsToString(method) + " [" + time + "ms]";
    }

    protected String getErrorMessage(Object proxy, Method method, Object[] args, Throwable thrown, long time) {
        return "X- " + this.getDelegateName() + '.' + method.getName() + this.paramsToString(method) + " [" + time + "ms]" + " threw " + thrown;
    }

    protected final Object getDelegate() {
        return this.delegate;
    }

    private String paramsToString(Method method) {
        StringBuffer buf = new StringBuffer("(");
        Class<?>[] paramTypes = method.getParameterTypes();
        int p = 0;
        while (p < paramTypes.length) {
            if (p > 0) {
                buf.append(',');
            }
            buf.append(paramTypes[p].getName());
            ++p;
        }
        buf.append(')');
        return buf.toString();
    }
}

