/*
 * Decompiled with CFR 0.152.
 */
package net.innig.util;

import java.util.Collections;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import net.innig.util.EnumeratedType;

public abstract class OrderedType
extends EnumeratedType
implements Comparable {
    private static long naturalOrder = 0L;
    private static final Object naturalOrderSync = new Object();
    private final transient Comparable order;
    static /* synthetic */ Class class$net$innig$util$OrderedType;

    public static SortedSet allTypesSorted(Class orderedTypeClass) {
        OrderedType.checkOrdered(orderedTypeClass);
        return Collections.unmodifiableSortedSet(new TreeSet(EnumeratedType.allTypes(orderedTypeClass)));
    }

    public static SortedSet allTypeNamesSorted(Class orderedTypeClass) {
        OrderedType.checkOrdered(orderedTypeClass);
        TreeSet result = new TreeSet(OrderedType.nameComparator(orderedTypeClass));
        result.addAll(EnumeratedType.allTypeNames(orderedTypeClass));
        return Collections.unmodifiableSortedSet(result);
    }

    public static Comparator comparator(final Class orderedTypeClass) {
        OrderedType.checkOrdered(orderedTypeClass);
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                if (!orderedTypeClass.isInstance(o1)) {
                    throw new IllegalArgumentException(o1 + " is not an instance of " + orderedTypeClass);
                }
                if (!orderedTypeClass.isInstance(o2)) {
                    throw new IllegalArgumentException(o2 + " is not an instance of " + orderedTypeClass);
                }
                return ((OrderedType)o1).compareTo((OrderedType)o2);
            }
        };
    }

    public static Comparator nameComparator(final Class orderedTypeClass) {
        OrderedType.checkOrdered(orderedTypeClass);
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                OrderedType t1 = (OrderedType)EnumeratedType.resolveFromName(orderedTypeClass, (String)o1);
                OrderedType t2 = (OrderedType)EnumeratedType.resolveFromName(orderedTypeClass, (String)o2);
                return t1.compareTo(t2);
            }
        };
    }

    private static void checkOrdered(Class orderedTypeClass) {
        if (!(class$net$innig$util$OrderedType == null ? (class$net$innig$util$OrderedType = OrderedType.class$("net.innig.util.OrderedType")) : class$net$innig$util$OrderedType).isAssignableFrom(orderedTypeClass)) {
            throw new IllegalArgumentException(orderedTypeClass.getName() + " is not a subclass of " + (class$net$innig$util$OrderedType == null ? (class$net$innig$util$OrderedType = OrderedType.class$("net.innig.util.OrderedType")) : class$net$innig$util$OrderedType).getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Comparable nextNaturalOrder() {
        Object object = naturalOrderSync;
        synchronized (object) {
            return new Long(naturalOrder++);
        }
    }

    public OrderedType(String name) {
        this(name, OrderedType.nextNaturalOrder());
    }

    public OrderedType(String name, int order) {
        this(name, new Integer(order));
    }

    public OrderedType(String name, Comparable order) {
        super(name);
        this.order = order;
    }

    public final int compareTo(Object that) {
        if (this.getClass() != that.getClass()) {
            throw new ClassCastException("Unable to compare unmatching OrderedType classes: " + this.getClass().getName() + " != " + that.getClass().getName());
        }
        return this.order.compareTo(((OrderedType)that).order);
    }

    public final boolean greaterThan(OrderedType that) {
        return this.compareTo(that) > 0;
    }

    public final boolean greaterThanEq(OrderedType that) {
        return this.compareTo(that) >= 0;
    }

    public final boolean lessThan(OrderedType that) {
        return this.compareTo(that) < 0;
    }

    public final boolean lessThanEq(OrderedType that) {
        return this.compareTo(that) <= 0;
    }

    protected Comparable getOrder() {
        return this.order;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

