/*
 * Decompiled with CFR 0.152.
 */
package net.innig.util;

import java.util.ArrayList;

public class ThreadFlock {
    private Runnable runnable;
    private ArrayList threads;
    private int priority;
    private boolean daemon;

    public ThreadFlock(Runnable runnable) {
        this(runnable, 1);
    }

    public ThreadFlock(Runnable runnable, int threadCount) {
        this.runnable = runnable;
        this.threads = new ArrayList();
        this.setPriority(5);
        this.setThreadCount(threadCount, false);
    }

    public ThreadFlock(Thread thread) {
        this(thread, 1);
    }

    public ThreadFlock(Thread thread, int threadCount) {
        this((Runnable)thread, threadCount);
        this.setDaemon(thread.isDaemon());
        this.setPriority(thread.getPriority());
    }

    public int getThreadCount() {
        return this.threads.size();
    }

    public void setThreadCount(int threadCount, boolean start) {
        if (threadCount < 0) {
            throw new IllegalArgumentException("threadCount < 0");
        }
        int oldCount = this.threads.size();
        if (threadCount == oldCount) {
            return;
        }
        int n = threadCount;
        while (n < oldCount) {
            ((Thread)this.threads.get(n)).interrupt();
            this.threads.remove(n);
            ++n;
        }
        int n2 = oldCount;
        while (n2 < threadCount) {
            Thread t = new Thread(this.runnable);
            this.threads.add(t);
            if (start) {
                t.start();
            }
            ++n2;
        }
        this.setPriority(this.priority);
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
        int n = 0;
        while (n < this.threads.size()) {
            ((Thread)this.threads.get(n)).setPriority(priority);
            ++n;
        }
    }

    public boolean isDaemon() {
        return this.daemon;
    }

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
        int n = 0;
        while (n < this.threads.size()) {
            ((Thread)this.threads.get(n)).setDaemon(daemon);
            ++n;
        }
    }

    public void start() {
        int n = 0;
        while (n < this.threads.size()) {
            ((Thread)this.threads.get(n)).start();
            ++n;
        }
    }

    public void interrupt() {
        int n = 0;
        while (n < this.threads.size()) {
            ((Thread)this.threads.get(n)).interrupt();
            ++n;
        }
    }

    public void join(long time) throws InterruptedException {
        int n = 0;
        while (n < this.threads.size()) {
            ((Thread)this.threads.get(n)).join(time);
            ++n;
        }
    }
}

