/*
 * Decompiled with CFR 0.152.
 */
package net.innig.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public final class WrappingProxy
implements InvocationHandler {
    public static final InvocationHandler UNSUPPORTED_OPERATION_HANDLER = new InvocationHandler(){

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            throw new UnsupportedOperationException();
        }
    };
    private final Object delegate;
    private final InvocationHandler pre;
    private final InvocationHandler post;

    public static Object newProxyInstance(Class iface, Object delegate, InvocationHandler pre, InvocationHandler post) {
        if (!iface.isInterface()) {
            throw new IllegalArgumentException(iface.getName() + " is not an interface");
        }
        if (!iface.isInstance(delegate)) {
            throw new IllegalArgumentException("Delegate object is an instance of " + delegate.getClass().getName() + ", which does not implement " + iface.getName());
        }
        return Proxy.newProxyInstance(iface.getClassLoader(), new Class[]{iface}, (InvocationHandler)new WrappingProxy(delegate, pre, post));
    }

    public WrappingProxy(Object delegate, InvocationHandler pre, InvocationHandler post) {
        this.delegate = delegate;
        this.pre = pre;
        this.post = post;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object object;
        if (this.pre != null) {
            this.pre.invoke(proxy, method, args);
        }
        try {
            try {
                object = this.delegate.getClass().getMethod(method.getName(), method.getParameterTypes()).invoke(this.delegate, args);
                Object var8_6 = null;
                if (this.post == null) return object;
            }
            catch (NoSuchMethodException nsme) {
                throw new IllegalStateException("Unable to invoke WrappingProxy delegate: " + nsme);
            }
            catch (IllegalAccessException iae) {
                throw new IllegalStateException("Unable to invoke WrappingProxy delegate: " + iae);
            }
            catch (InvocationTargetException ite) {
                throw ite.getTargetException();
            }
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            if (this.post == null) throw throwable;
            this.post.invoke(proxy, method, args);
            throw throwable;
        }
        this.post.invoke(proxy, method, args);
        return object;
    }
}

