/*
 * Decompiled with CFR 0.152.
 */
package org.mpr.util;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.LinkedList;

public class StreamSplitter
extends Thread {
    private InputStream in;
    private OutputStream[] out;
    private long byteCount;
    private int bufferSize;
    private int latency;
    private boolean done;
    private boolean haltOnEOF;
    private boolean running;
    private boolean verbose;

    public static void main(String[] args) throws IOException {
        String inName;
        int latency = -1;
        int bufferSize = -1;
        boolean verbose = false;
        boolean haltOnEOF = true;
        int arg = 0;
        try {
            while (args[arg].charAt(0) == '-') {
                if (args[arg].startsWith("-v")) {
                    ++arg;
                    System.err.println("Verbose output enabled");
                    verbose = true;
                }
                if (args[arg].startsWith("-l")) {
                    int n = ++arg;
                    ++arg;
                    latency = Integer.parseInt(args[n]);
                    if (verbose) {
                        System.err.println("Latency = " + latency + "ms");
                    }
                }
                if (args[arg].startsWith("-b")) {
                    int n = ++arg;
                    ++arg;
                    bufferSize = Integer.parseInt(args[n]);
                    if (verbose) {
                        System.err.println("Buffer size = " + bufferSize + " bytes");
                    }
                }
                if (!args[arg].startsWith("-f")) continue;
                ++arg;
                if (verbose) {
                    System.err.println("Will not halt on EOF");
                }
                haltOnEOF = false;
            }
            inName = args[arg++];
        }
        catch (Exception e) {
            System.err.println("usage: java org.mpr.util.StreamSplitter [-v(erbose)] [-f(ollow)] [-l(atency) millis] [-b(uffer) bytes] input output*...");
            System.err.println("   where input = in|<filename>");
            System.err.println("        output = out|err|<filename>");
            return;
        }
        InputStream in = inName.equals("in") ? System.in : new FileInputStream(inName);
        LinkedList<OutputStream> outs = new LinkedList<OutputStream>();
        while (arg < args.length) {
            String outName;
            if ((outName = args[arg++]).equals("out")) {
                outs.add(System.out);
                continue;
            }
            if (outName.equals("err")) {
                outs.add(System.err);
                continue;
            }
            outs.add(new FileOutputStream(outName));
        }
        StreamSplitter splitter = new StreamSplitter(in, outs);
        splitter.setVerbose(verbose);
        splitter.setHaltOnEOF(haltOnEOF);
        if (latency > 0) {
            splitter.setLatency(latency);
        }
        if (bufferSize > 0) {
            splitter.setBufferSize(bufferSize);
        }
        splitter.run();
        if (verbose) {
            System.err.println(splitter.getByteCount() + " bytes transferred");
        }
    }

    public StreamSplitter(InputStream in, OutputStream[] out) {
        this.in = in;
        this.out = new OutputStream[out.length];
        System.arraycopy(out, 0, this.out, 0, out.length);
        this.byteCount = 0L;
        this.bufferSize = 32768;
        this.latency = 30;
        this.running = true;
        this.done = false;
        this.haltOnEOF = true;
        this.verbose = true;
    }

    public StreamSplitter(InputStream in, Collection outs) {
        this(in, outs.toArray(new OutputStream[outs.size()]));
    }

    public StreamSplitter(InputStream in, OutputStream out) {
        this(in, new OutputStream[]{out});
    }

    public StreamSplitter(InputStream in, OutputStream out1, OutputStream out2) {
        this(in, new OutputStream[]{out1, out2});
    }

    public void run() {
        block11: {
            block10: {
                this.done = false;
                byte[] buf = new byte[this.bufferSize];
                try {
                    while (this.running) {
                        int size = Math.max(1, Math.min(this.in.available(), buf.length));
                        if ((size = this.in.read(buf, 0, size)) == -1) {
                            if (this.haltOnEOF) {
                                break;
                            }
                        } else {
                            int n = 0;
                            while (n < this.out.length) {
                                if (this.out[n] != null) {
                                    this.out[n].write(buf, 0, size);
                                    this.out[n].flush();
                                }
                                ++n;
                            }
                            this.byteCount += (long)size;
                        }
                        if (size >= buf.length) continue;
                        Thread.sleep(this.latency);
                    }
                }
                catch (Exception e) {
                    if (!this.verbose) break block10;
                    e.printStackTrace(System.err);
                }
            }
            try {
                this.in.close();
            }
            catch (Exception e) {
                if (!this.verbose) break block11;
                e.printStackTrace(System.err);
            }
        }
        this.done = true;
    }

    public void halt() {
        this.running = false;
    }

    public boolean isDone() {
        return this.done;
    }

    public boolean getHaltOnEOF() {
        return this.haltOnEOF;
    }

    public void setHaltOnEOF(boolean haltOnEOF) {
        this.haltOnEOF = haltOnEOF;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public int getLatency() {
        return this.latency;
    }

    public void setLatency(int latency) {
        this.latency = latency;
    }

    public long getByteCount() {
        return this.byteCount;
    }
}

