/*
 * Decompiled with CFR 0.152.
 */
package org.mpr.util;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Date;
import org.mpr.util.StreamSplitter;

public class TCPTunnel
extends Thread {
    private int localPort;
    private int remotePort;
    private String remoteHost;
    private ServerSocket listener;
    private OutputStream inTraffic;
    private OutputStream outTraffic;
    private boolean verbose;
    private boolean multi;
    private int latency;
    private int bufferSize;

    public static void main(String[] args) throws IOException {
        int remotePort;
        String remoteHost;
        int localPort;
        OutputStream inTraffic = null;
        OutputStream outTraffic = null;
        boolean multi = false;
        boolean verbose = false;
        int latency = -1;
        int bufferSize = -1;
        try {
            int arg = 0;
            while (args[arg].charAt(0) == '-') {
                if (args[arg].startsWith("-v")) {
                    ++arg;
                    System.err.println("Verbose output enabled");
                    verbose = true;
                }
                if (args[arg].startsWith("-o")) {
                    int n = ++arg;
                    ++arg;
                    String logName = args[n];
                    if (logName.equals("out")) {
                        if (verbose) {
                            System.err.println("Outputting traffic to console");
                        }
                        inTraffic = outTraffic = System.out;
                    } else {
                        if (verbose) {
                            System.err.println("Outputting traffic to " + logName + "_in.log and " + logName + "_out.log");
                        }
                        inTraffic = new FileOutputStream(logName + "_in.log");
                        outTraffic = new FileOutputStream(logName + "_out.log");
                    }
                }
                if (args[arg].startsWith("-m")) {
                    ++arg;
                    if (verbose) {
                        System.err.println("Allowing multiple simultaneous connections");
                    }
                    multi = true;
                }
                if (args[arg].startsWith("-l")) {
                    int n = ++arg;
                    ++arg;
                    latency = Integer.parseInt(args[n]);
                    if (verbose) {
                        System.err.println("Latency = " + latency + "ms");
                    }
                }
                if (!args[arg].startsWith("-b")) continue;
                int n = ++arg;
                ++arg;
                bufferSize = Integer.parseInt(args[n]);
                if (!verbose) continue;
                System.err.println("Buffer size = " + bufferSize + " bytes");
            }
            localPort = Integer.parseInt(args[arg++]);
            remoteHost = args[arg++];
            remotePort = Integer.parseInt(args[arg++]);
        }
        catch (Exception e) {
            System.err.println("usage: java org.mpr.util.TCPTunnel [options] local-port remote-host remote-port");
            System.err.println("  where options include:");
            System.err.println("    [-o(utput) {out|<file>}]  Log traffic to console or a file");
            System.err.println("    [-m(ulti)]                Allow multiple simultaneous connections");
            System.err.println("    [-v(erbose)]              Print connect/disconnect/error information");
            System.err.println("    [-l(atency) millis]       Read latency (set low for faster response; default=30)");
            System.err.println("    [-b(uffer) bytes]         Read buffer (set high for better throughput; default=32768)");
            return;
        }
        TCPTunnel tunnel = new TCPTunnel(localPort, remoteHost, remotePort, inTraffic, outTraffic);
        tunnel.setVerbose(verbose);
        tunnel.setMultiConnection(multi);
        if (latency > 0) {
            tunnel.setLatency(latency);
        }
        if (bufferSize > 0) {
            tunnel.setBufferSize(bufferSize);
        }
        tunnel.run();
    }

    public TCPTunnel(int localPort, String remoteHost, int remotePort) throws IOException {
        this(localPort, remoteHost, remotePort, null, null);
    }

    public TCPTunnel(int localPort, String remoteHost, int remotePort, OutputStream inTraffic, OutputStream outTraffic) throws IOException {
        this.localPort = localPort;
        this.remoteHost = remoteHost;
        this.remotePort = remotePort;
        this.inTraffic = inTraffic;
        this.outTraffic = outTraffic;
        this.listener = new ServerSocket(localPort);
        this.verbose = false;
        this.multi = true;
        this.bufferSize = -1;
        this.latency = -1;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean getMultiConnection() {
        return this.multi;
    }

    public void setMultiConnection(boolean multi) {
        this.multi = multi;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public int getLatency() {
        return this.latency;
    }

    public void setLatency(int latency) {
        this.latency = latency;
    }

    public void run() {
        try {
            while (true) {
                if (this.verbose) {
                    System.err.println("TCPTunnel listening...");
                }
                SocketTunnel tunnel = new SocketTunnel(this.listener.accept(), this.remoteHost, this.remotePort);
                if (this.multi) {
                    tunnel.start();
                    continue;
                }
                tunnel.run();
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            System.err.println("TCPTunnel stopped");
            return;
        }
    }

    private class SocketTunnel
    extends Thread {
        private Socket remoteSock;
        private Socket bounceSock;
        private String bounceHost;
        private int bouncePort;

        public SocketTunnel(Socket remoteSock, String bounceHost, int bouncePort) {
            this.remoteSock = remoteSock;
            this.bounceHost = bounceHost;
            this.bouncePort = bouncePort;
        }

        public void run() {
            Thread splitOut;
            Thread splitIn;
            PrintWriter inMsg;
            PrintWriter outMsg;
            block19: {
                block18: {
                    block17: {
                        outMsg = null;
                        inMsg = null;
                        if (TCPTunnel.this.verbose) {
                            if (TCPTunnel.this.outTraffic != null) {
                                outMsg = new PrintWriter(new OutputStreamWriter(TCPTunnel.this.outTraffic));
                            }
                            if (TCPTunnel.this.inTraffic != null) {
                                inMsg = new PrintWriter(new OutputStreamWriter(TCPTunnel.this.inTraffic));
                            }
                            String msg = "Got connection on port " + TCPTunnel.this.localPort + " from " + this.remoteSock.getInetAddress().toString() + " at " + new Date();
                            System.err.println(msg);
                            if (outMsg != null) {
                                outMsg.println(msg);
                            }
                            if (inMsg != null) {
                                inMsg.println(msg);
                            }
                        }
                        splitIn = null;
                        splitOut = null;
                        try {
                            this.bounceSock = new Socket(this.bounceHost, this.bouncePort);
                            OutputStream[] inSplits = new OutputStream[]{TCPTunnel.this.inTraffic, this.bounceSock.getOutputStream()};
                            OutputStream[] outSplits = new OutputStream[]{TCPTunnel.this.outTraffic, this.remoteSock.getOutputStream()};
                            splitIn = new StreamSplitter(this.remoteSock.getInputStream(), inSplits);
                            splitOut = new StreamSplitter(this.bounceSock.getInputStream(), outSplits);
                            ((StreamSplitter)splitIn).setVerbose(TCPTunnel.this.verbose);
                            ((StreamSplitter)splitOut).setVerbose(TCPTunnel.this.verbose);
                            if (TCPTunnel.this.latency != -1) {
                                ((StreamSplitter)splitIn).setLatency(TCPTunnel.this.latency);
                                ((StreamSplitter)splitOut).setLatency(TCPTunnel.this.latency);
                            }
                            if (TCPTunnel.this.bufferSize != -1) {
                                ((StreamSplitter)splitIn).setBufferSize(TCPTunnel.this.bufferSize);
                                ((StreamSplitter)splitOut).setBufferSize(TCPTunnel.this.bufferSize);
                            }
                            splitIn.start();
                            splitOut.start();
                            while (!((StreamSplitter)splitIn).isDone() && !((StreamSplitter)splitOut).isDone()) {
                                Thread.sleep(162L);
                            }
                        }
                        catch (Exception e) {
                            if (!TCPTunnel.this.verbose) break block17;
                            e.printStackTrace(System.err);
                        }
                    }
                    try {
                        this.remoteSock.close();
                    }
                    catch (Exception e) {
                        if (!TCPTunnel.this.verbose) break block18;
                        e.printStackTrace(System.err);
                    }
                }
                try {
                    this.bounceSock.close();
                }
                catch (Exception e) {
                    if (!TCPTunnel.this.verbose) break block19;
                    e.printStackTrace(System.err);
                }
            }
            splitIn.interrupt();
            splitOut.interrupt();
            if (TCPTunnel.this.verbose) {
                String msg = "Connection from " + this.remoteSock.getInetAddress().toString() + " closed at " + new Date() + "  In bytes: " + (splitIn != null ? ((StreamSplitter)splitIn).getByteCount() : 0L) + "  Out bytes: " + (splitOut != null ? ((StreamSplitter)splitOut).getByteCount() : 0L);
                System.err.println(msg);
                if (outMsg != null) {
                    outMsg.println(msg);
                }
                if (inMsg != null) {
                    inMsg.println(msg);
                }
            }
        }
    }
}

