package org.ccsds.moims.mo.mal.structures;

/**
 * The NamedValue structure shall represent a simple pair type of an identifier
 * and abstract Attribute value.
 */
public final class NamedValue implements org.ccsds.moims.mo.mal.structures.Composite {

    private static final long serialVersionUID = 281475027043310L;
    /**
     * The TypeId of this Element as a long.
     */
    public static final Long SHORT_FORM = 281475027043310L;
    /**
     * The TypeId of this Element.
     */
    public static final org.ccsds.moims.mo.mal.TypeId TYPE_ID = new org.ccsds.moims.mo.mal.TypeId(SHORT_FORM);

    /**
     * The Identifier value.
     */
    private org.ccsds.moims.mo.mal.structures.Identifier name;

    /**
     * The Attribute value.
     */
    private org.ccsds.moims.mo.mal.structures.Attribute value;

    /**
     * Default constructor for NamedValue.
     * 
     */
    public NamedValue() {
    }

    /**
     * Constructor that initialises the values of the structure.
     * 
     * @param name The Identifier value.
     * @param value The Attribute value.
     */
    public NamedValue(org.ccsds.moims.mo.mal.structures.Identifier name,
            org.ccsds.moims.mo.mal.structures.Attribute value) {
        this.name = name;
        this.value = value;
    }

    /**
     * Constructor that initialises the non-nullable values of the structure.
     * 
     * @param name The Identifier value.
     */
    public NamedValue(org.ccsds.moims.mo.mal.structures.Identifier name) {
        this.name = name;
        this.value = null;
    }

    @Override
    public org.ccsds.moims.mo.mal.structures.Element createElement() {
        return new org.ccsds.moims.mo.mal.structures.NamedValue();
    }

    /**
     * Returns the field name.
     * 
     * @return The field name.
     */
    public org.ccsds.moims.mo.mal.structures.Identifier getName() {
        return name;
    }

    /**
     * Sets the field name.
     * 
     * @param __newValue The new value.
     */
    @Deprecated
    public void setName(org.ccsds.moims.mo.mal.structures.Identifier __newValue) {
        name = __newValue;
    }

    /**
     * Returns the field value.
     * 
     * @return The field value.
     */
    public org.ccsds.moims.mo.mal.structures.Attribute getValue() {
        return value;
    }

    /**
     * Sets the field value.
     * 
     * @param __newValue The new value.
     */
    @Deprecated
    public void setValue(org.ccsds.moims.mo.mal.structures.Attribute __newValue) {
        value = __newValue;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof NamedValue) {
            NamedValue other = (NamedValue) obj;
            if (name == null) {
                if (other.name != null) {
                    return false;
                }
            } else {
                if (! name.equals(other.name)) {
                    return false;
                }
            }
            if (value == null) {
                if (other.value != null) {
                    return false;
                }
            } else {
                if (! value.equals(other.value)) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 83 * hash + (name != null ? name.hashCode() : 0);
        hash = 83 * hash + (value != null ? value.hashCode() : 0);
        return hash;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("(NamedValue: ");
        buf.append("name=").append(name);
        buf.append(", value=").append(value);
        buf.append(')');
        return buf.toString();
    }

    @Override
    public void encode(org.ccsds.moims.mo.mal.MALEncoder encoder) throws org.ccsds.moims.mo.mal.MALException {
        if (name == null) {
            throw new org.ccsds.moims.mo.mal.MALException("The field 'name' cannot be null!");
        }
        encoder.encodeIdentifier(name);
        encoder.encodeNullableAttribute(value);
    }

    @Override
    public org.ccsds.moims.mo.mal.structures.Element decode(org.ccsds.moims.mo.mal.MALDecoder decoder) throws org.ccsds.moims.mo.mal.MALException {
        name = decoder.decodeIdentifier();
        value = (org.ccsds.moims.mo.mal.structures.Attribute) decoder.decodeNullableAttribute();
        return this;
    }

    @Override
    public org.ccsds.moims.mo.mal.TypeId getTypeId() {
        return TYPE_ID;
    }

}
