package org.ccsds.moims.mo.com.activitytracking.provider;

/**
 * Provider Inheritance skeleton for ActivityTrackingInheritanceSkeleton service.
 */
public abstract class ActivityTrackingInheritanceSkeleton implements org.ccsds.moims.mo.mal.provider.MALInteractionHandler, org.ccsds.moims.mo.com.activitytracking.provider.ActivityTrackingSkeleton, org.ccsds.moims.mo.com.activitytracking.provider.ActivityTrackingHandler {

    private org.ccsds.moims.mo.mal.provider.MALProviderSet providerSet = new org.ccsds.moims.mo.mal.provider.MALProviderSet(org.ccsds.moims.mo.com.activitytracking.ActivityTrackingHelper.ACTIVITYTRACKING_SERVICE);

    /**
     * Returns the connection object for this provider.
     * 
     * @return the connection object for this provider.
     * @throws java.io.IOException if the method was not implemented yet.
     */
    public org.ccsds.moims.mo.mal.helpertools.connections.ConnectionProvider getConnection() throws java.io.IOException {
        throw new java.io.IOException("This method needs to be overridden!");
    }

    /**
     * Implements the setSkeleton method of the handler interface but does nothing
     * as this is the skeleton.
     * 
     * @param skeleton Not used in the inheritance pattern (the skeleton is &quot;this&quot;.
     */
    public void setSkeleton(org.ccsds.moims.mo.com.activitytracking.provider.ActivityTrackingSkeleton skeleton) {
        // Not used in the inheritance pattern (the skeleton is 'this');
    }

    /**
     * Adds the supplied MAL provider to the internal list of providers used for
     * PubSub.
     * 
     * @param provider The provider to be added.
     * @throws org.ccsds.moims.mo.mal.MALException If an error is detected.
     */
    public void malInitialize(org.ccsds.moims.mo.mal.provider.MALProvider provider) throws org.ccsds.moims.mo.mal.MALException {
        providerSet.addProvider(provider);
    }

    /**
     * Removes the supplied MAL provider from the internal list of providers used
     * for PubSub.
     * 
     * @param provider The provider to be added.
     * @throws org.ccsds.moims.mo.mal.MALException If an error is detected.
     */
    public void malFinalize(org.ccsds.moims.mo.mal.provider.MALProvider provider) throws org.ccsds.moims.mo.mal.MALException {
        providerSet.removeProvider(provider);
    }

    /**
     * Called by the provider MAL layer on reception of a message to handle the
     * interaction.
     * 
     * @param interaction The interaction object.
     * @param body The message body.
     * @throws org.ccsds.moims.mo.mal.MALException if there is a internal error.
     * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a operation
     * interaction error.
     */
    public void handleSend(org.ccsds.moims.mo.mal.provider.MALInteraction interaction,
            org.ccsds.moims.mo.mal.transport.MALMessageBody body) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException {
        int opNumber = interaction.getOperation().getNumber().getValue();;
        switch (opNumber) {
          default:
            throw new org.ccsds.moims.mo.mal.MALInteractionException(new org.ccsds.moims.mo.mal.UnsupportedOperationException(
                    org.ccsds.moims.mo.mal.provider.MALInteractionHandler.ERROR_MSG_UNSUPPORTED + opNumber));
        }
    }

    /**
     * Called by the provider MAL layer on reception of a message to handle the
     * interaction.
     * 
     * @param interaction The interaction object.
     * @param body The message body.
     * @throws org.ccsds.moims.mo.mal.MALException if there is a internal error.
     * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a operation
     * interaction error.
     */
    public void handleSubmit(org.ccsds.moims.mo.mal.provider.MALSubmit interaction,
            org.ccsds.moims.mo.mal.transport.MALMessageBody body) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException {
        int opNumber = interaction.getOperation().getNumber().getValue();
        switch (opNumber) {
          default:
            interaction.sendError(new org.ccsds.moims.mo.mal.UnsupportedOperationException(
                    org.ccsds.moims.mo.mal.provider.MALInteractionHandler.ERROR_MSG_UNSUPPORTED + opNumber));
            throw new org.ccsds.moims.mo.mal.MALInteractionException(new org.ccsds.moims.mo.mal.UnsupportedOperationException(
                    org.ccsds.moims.mo.mal.provider.MALInteractionHandler.ERROR_MSG_UNSUPPORTED + opNumber));
        }
    }

    /**
     * Called by the provider MAL layer on reception of a message to handle the
     * interaction.
     * 
     * @param interaction The interaction object.
     * @param body The message body.
     * @throws org.ccsds.moims.mo.mal.MALException if there is a internal error.
     * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a operation
     * interaction error.
     */
    public void handleRequest(org.ccsds.moims.mo.mal.provider.MALRequest interaction,
            org.ccsds.moims.mo.mal.transport.MALMessageBody body) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException {
        int opNumber = interaction.getOperation().getNumber().getValue();
        switch (opNumber) {
          default:
            interaction.sendError(new org.ccsds.moims.mo.mal.UnsupportedOperationException(
                    org.ccsds.moims.mo.mal.provider.MALInteractionHandler.ERROR_MSG_UNSUPPORTED + opNumber));
            throw new org.ccsds.moims.mo.mal.MALInteractionException(new org.ccsds.moims.mo.mal.UnsupportedOperationException(
                    org.ccsds.moims.mo.mal.provider.MALInteractionHandler.ERROR_MSG_UNSUPPORTED + opNumber));
        }
    }

    /**
     * Called by the provider MAL layer on reception of a message to handle the
     * interaction.
     * 
     * @param interaction The interaction object.
     * @param body The message body.
     * @throws org.ccsds.moims.mo.mal.MALException if there is a internal error.
     * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a operation
     * interaction error.
     */
    public void handleInvoke(org.ccsds.moims.mo.mal.provider.MALInvoke interaction,
            org.ccsds.moims.mo.mal.transport.MALMessageBody body) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException {
        int opNumber = interaction.getOperation().getNumber().getValue();
        switch (opNumber) {
          default:
            interaction.sendError(new org.ccsds.moims.mo.mal.UnsupportedOperationException(
                    org.ccsds.moims.mo.mal.provider.MALInteractionHandler.ERROR_MSG_UNSUPPORTED + opNumber));
            throw new org.ccsds.moims.mo.mal.MALInteractionException(new org.ccsds.moims.mo.mal.UnsupportedOperationException(
                    org.ccsds.moims.mo.mal.provider.MALInteractionHandler.ERROR_MSG_UNSUPPORTED + opNumber));
        }
    }

    /**
     * Called by the provider MAL layer on reception of a message to handle the
     * interaction.
     * 
     * @param interaction The interaction object.
     * @param body The message body.
     * @throws org.ccsds.moims.mo.mal.MALException if there is a internal error.
     * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a operation
     * interaction error.
     */
    public void handleProgress(org.ccsds.moims.mo.mal.provider.MALProgress interaction,
            org.ccsds.moims.mo.mal.transport.MALMessageBody body) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException {
        int opNumber = interaction.getOperation().getNumber().getValue();
        switch (opNumber) {
          default:
            interaction.sendError(new org.ccsds.moims.mo.mal.UnsupportedOperationException(
                    org.ccsds.moims.mo.mal.provider.MALInteractionHandler.ERROR_MSG_UNSUPPORTED + opNumber));
            throw new org.ccsds.moims.mo.mal.MALInteractionException(new org.ccsds.moims.mo.mal.UnsupportedOperationException(
                    org.ccsds.moims.mo.mal.provider.MALInteractionHandler.ERROR_MSG_UNSUPPORTED + opNumber));
        }
    }

}
