package org.ccsds.moims.mo.com.archive;

/**
 * Helper class for Archive service.
 */
public class ArchiveServiceInfo extends org.ccsds.moims.mo.com.COMService {

    /**
     * Service number literal.
     */
    public static final int _ARCHIVE_SERVICE_NUMBER = 2;

    /**
     * Service number instance.
     */
    public static final org.ccsds.moims.mo.mal.structures.UShort ARCHIVE_SERVICE_NUMBER = new org.ccsds.moims.mo.mal.structures.UShort(_ARCHIVE_SERVICE_NUMBER);

    /**
     * Service name constant.
     */
    public static final org.ccsds.moims.mo.mal.structures.Identifier ARCHIVE_SERVICE_NAME = new org.ccsds.moims.mo.mal.structures.Identifier("Archive");

    /**
     * The service key of this service.
     */
    public static final org.ccsds.moims.mo.mal.ServiceKey SERVICE_KEY = new org.ccsds.moims.mo.mal.ServiceKey(
            2,1,ARCHIVE_SERVICE_NUMBER);

    /**
     * Operation number literal for operation RETRIEVE.
     */
    public static final int _RETRIEVE_OP_NUMBER = 1;

    /**
     * Operation number instance for operation RETRIEVE.
     */
    public static final org.ccsds.moims.mo.mal.structures.UShort RETRIEVE_OP_NUMBER = new org.ccsds.moims.mo.mal.structures.UShort(_RETRIEVE_OP_NUMBER);

    /**
     * Operation instance for operation RETRIEVE.
     */
    public static final org.ccsds.moims.mo.mal.MALInvokeOperation RETRIEVE_OP = new org.ccsds.moims.mo.mal.MALInvokeOperation(SERVICE_KEY, 
            RETRIEVE_OP_NUMBER, 
            new org.ccsds.moims.mo.mal.structures.Identifier("retrieve"), 
            new org.ccsds.moims.mo.mal.structures.UShort(1), 
            new org.ccsds.moims.mo.mal.OperationField[] {
                new org.ccsds.moims.mo.mal.OperationField("objType", true, org.ccsds.moims.mo.com.structures.ObjectType.SHORT_FORM),
                new org.ccsds.moims.mo.mal.OperationField("domain", true, org.ccsds.moims.mo.mal.structures.IdentifierList.SHORT_FORM),
                new org.ccsds.moims.mo.mal.OperationField("objInstIds", true, org.ccsds.moims.mo.mal.structures.LongList.SHORT_FORM)}, 
            new org.ccsds.moims.mo.mal.OperationField[] {}, 
            new org.ccsds.moims.mo.mal.OperationField[] {
                new org.ccsds.moims.mo.mal.OperationField("objDetails", true, org.ccsds.moims.mo.com.archive.structures.ArchiveDetailsList.SHORT_FORM),
                new org.ccsds.moims.mo.mal.OperationField("objBodies", true, null)});

    /**
     * Operation number literal for operation QUERY.
     */
    public static final int _QUERY_OP_NUMBER = 2;

    /**
     * Operation number instance for operation QUERY.
     */
    public static final org.ccsds.moims.mo.mal.structures.UShort QUERY_OP_NUMBER = new org.ccsds.moims.mo.mal.structures.UShort(_QUERY_OP_NUMBER);

    /**
     * Operation instance for operation QUERY.
     */
    public static final org.ccsds.moims.mo.mal.MALProgressOperation QUERY_OP = new org.ccsds.moims.mo.mal.MALProgressOperation(SERVICE_KEY, 
            QUERY_OP_NUMBER, 
            new org.ccsds.moims.mo.mal.structures.Identifier("query"), 
            new org.ccsds.moims.mo.mal.structures.UShort(1), 
            new org.ccsds.moims.mo.mal.OperationField[] {
                new org.ccsds.moims.mo.mal.OperationField("returnBody", true, org.ccsds.moims.mo.mal.structures.Attribute.BOOLEAN_SHORT_FORM),
                new org.ccsds.moims.mo.mal.OperationField("objType", true, org.ccsds.moims.mo.com.structures.ObjectType.SHORT_FORM),
                new org.ccsds.moims.mo.mal.OperationField("archiveQuery", true, org.ccsds.moims.mo.com.archive.structures.ArchiveQueryList.SHORT_FORM),
                new org.ccsds.moims.mo.mal.OperationField("queryFilter", true, null)}, 
            new org.ccsds.moims.mo.mal.OperationField[] {}, 
            new org.ccsds.moims.mo.mal.OperationField[] {
                new org.ccsds.moims.mo.mal.OperationField("objType", true, org.ccsds.moims.mo.com.structures.ObjectType.SHORT_FORM),
                new org.ccsds.moims.mo.mal.OperationField("domain", true, org.ccsds.moims.mo.mal.structures.IdentifierList.SHORT_FORM),
                new org.ccsds.moims.mo.mal.OperationField("objDetails", true, org.ccsds.moims.mo.com.archive.structures.ArchiveDetailsList.SHORT_FORM),
                new org.ccsds.moims.mo.mal.OperationField("objBodies", true, null)}, 
            new org.ccsds.moims.mo.mal.OperationField[] {
                new org.ccsds.moims.mo.mal.OperationField("objType", true, org.ccsds.moims.mo.com.structures.ObjectType.SHORT_FORM),
                new org.ccsds.moims.mo.mal.OperationField("domain", true, org.ccsds.moims.mo.mal.structures.IdentifierList.SHORT_FORM),
                new org.ccsds.moims.mo.mal.OperationField("objDetails", true, org.ccsds.moims.mo.com.archive.structures.ArchiveDetailsList.SHORT_FORM),
                new org.ccsds.moims.mo.mal.OperationField("objBodies", true, null)});

    /**
     * Operation number literal for operation COUNT.
     */
    public static final int _COUNT_OP_NUMBER = 3;

    /**
     * Operation number instance for operation COUNT.
     */
    public static final org.ccsds.moims.mo.mal.structures.UShort COUNT_OP_NUMBER = new org.ccsds.moims.mo.mal.structures.UShort(_COUNT_OP_NUMBER);

    /**
     * Operation instance for operation COUNT.
     */
    public static final org.ccsds.moims.mo.mal.MALInvokeOperation COUNT_OP = new org.ccsds.moims.mo.mal.MALInvokeOperation(SERVICE_KEY, 
            COUNT_OP_NUMBER, 
            new org.ccsds.moims.mo.mal.structures.Identifier("count"), 
            new org.ccsds.moims.mo.mal.structures.UShort(1), 
            new org.ccsds.moims.mo.mal.OperationField[] {
                new org.ccsds.moims.mo.mal.OperationField("objType", true, org.ccsds.moims.mo.com.structures.ObjectType.SHORT_FORM),
                new org.ccsds.moims.mo.mal.OperationField("archiveQuery", true, org.ccsds.moims.mo.com.archive.structures.ArchiveQueryList.SHORT_FORM),
                new org.ccsds.moims.mo.mal.OperationField("queryFilter", true, null)}, 
            new org.ccsds.moims.mo.mal.OperationField[] {}, 
            new org.ccsds.moims.mo.mal.OperationField[] {
                new org.ccsds.moims.mo.mal.OperationField("counts", true, org.ccsds.moims.mo.mal.structures.LongList.SHORT_FORM)});

    /**
     * Operation number literal for operation STORE.
     */
    public static final int _STORE_OP_NUMBER = 4;

    /**
     * Operation number instance for operation STORE.
     */
    public static final org.ccsds.moims.mo.mal.structures.UShort STORE_OP_NUMBER = new org.ccsds.moims.mo.mal.structures.UShort(_STORE_OP_NUMBER);

    /**
     * Operation instance for operation STORE.
     */
    public static final org.ccsds.moims.mo.mal.MALRequestOperation STORE_OP = new org.ccsds.moims.mo.mal.MALRequestOperation(SERVICE_KEY, 
            STORE_OP_NUMBER, 
            new org.ccsds.moims.mo.mal.structures.Identifier("store"), 
            new org.ccsds.moims.mo.mal.structures.UShort(2), 
            new org.ccsds.moims.mo.mal.OperationField[] {
                new org.ccsds.moims.mo.mal.OperationField("returnObjInstIds", true, org.ccsds.moims.mo.mal.structures.Attribute.BOOLEAN_SHORT_FORM),
                new org.ccsds.moims.mo.mal.OperationField("objType", true, org.ccsds.moims.mo.com.structures.ObjectType.SHORT_FORM),
                new org.ccsds.moims.mo.mal.OperationField("domain", true, org.ccsds.moims.mo.mal.structures.IdentifierList.SHORT_FORM),
                new org.ccsds.moims.mo.mal.OperationField("objDetails", true, org.ccsds.moims.mo.com.archive.structures.ArchiveDetailsList.SHORT_FORM),
                new org.ccsds.moims.mo.mal.OperationField("objBodies", true, null)}, 
            new org.ccsds.moims.mo.mal.OperationField[] {
                new org.ccsds.moims.mo.mal.OperationField("objInstIds", true, org.ccsds.moims.mo.mal.structures.LongList.SHORT_FORM)});

    /**
     * Operation number literal for operation UPDATE.
     */
    public static final int _UPDATE_OP_NUMBER = 5;

    /**
     * Operation number instance for operation UPDATE.
     */
    public static final org.ccsds.moims.mo.mal.structures.UShort UPDATE_OP_NUMBER = new org.ccsds.moims.mo.mal.structures.UShort(_UPDATE_OP_NUMBER);

    /**
     * Operation instance for operation UPDATE.
     */
    public static final org.ccsds.moims.mo.mal.MALSubmitOperation UPDATE_OP = new org.ccsds.moims.mo.mal.MALSubmitOperation(SERVICE_KEY, 
            UPDATE_OP_NUMBER, 
            new org.ccsds.moims.mo.mal.structures.Identifier("update"), 
            new org.ccsds.moims.mo.mal.structures.UShort(3), 
            new org.ccsds.moims.mo.mal.OperationField[] {
                new org.ccsds.moims.mo.mal.OperationField("objType", true, org.ccsds.moims.mo.com.structures.ObjectType.SHORT_FORM),
                new org.ccsds.moims.mo.mal.OperationField("domain", true, org.ccsds.moims.mo.mal.structures.IdentifierList.SHORT_FORM),
                new org.ccsds.moims.mo.mal.OperationField("objDetails", true, org.ccsds.moims.mo.com.archive.structures.ArchiveDetailsList.SHORT_FORM),
                new org.ccsds.moims.mo.mal.OperationField("objBodies", true, null)});

    /**
     * Operation number literal for operation DELETE.
     */
    public static final int _DELETE_OP_NUMBER = 6;

    /**
     * Operation number instance for operation DELETE.
     */
    public static final org.ccsds.moims.mo.mal.structures.UShort DELETE_OP_NUMBER = new org.ccsds.moims.mo.mal.structures.UShort(_DELETE_OP_NUMBER);

    /**
     * Operation instance for operation DELETE.
     */
    public static final org.ccsds.moims.mo.mal.MALRequestOperation DELETE_OP = new org.ccsds.moims.mo.mal.MALRequestOperation(SERVICE_KEY, 
            DELETE_OP_NUMBER, 
            new org.ccsds.moims.mo.mal.structures.Identifier("delete"), 
            new org.ccsds.moims.mo.mal.structures.UShort(4), 
            new org.ccsds.moims.mo.mal.OperationField[] {
                new org.ccsds.moims.mo.mal.OperationField("objType", true, org.ccsds.moims.mo.com.structures.ObjectType.SHORT_FORM),
                new org.ccsds.moims.mo.mal.OperationField("domain", true, org.ccsds.moims.mo.mal.structures.IdentifierList.SHORT_FORM),
                new org.ccsds.moims.mo.mal.OperationField("objInstIds", true, org.ccsds.moims.mo.mal.structures.LongList.SHORT_FORM)}, 
            new org.ccsds.moims.mo.mal.OperationField[] {
                new org.ccsds.moims.mo.mal.OperationField("deletedObjInstIds", true, org.ccsds.moims.mo.mal.structures.LongList.SHORT_FORM)});

    /**
     * Area elements.
     */
    public static final org.ccsds.moims.mo.mal.structures.Element[] ARCHIVE_SERVICE_ELEMENTS = {
        new org.ccsds.moims.mo.com.archive.structures.ExpressionOperator(),
        new org.ccsds.moims.mo.com.archive.structures.ExpressionOperatorList(),
        new org.ccsds.moims.mo.com.archive.structures.ArchiveDetails(),
        new org.ccsds.moims.mo.com.archive.structures.ArchiveDetailsList(),
        new org.ccsds.moims.mo.com.archive.structures.ArchiveQuery(),
        new org.ccsds.moims.mo.com.archive.structures.ArchiveQueryList(),
        new org.ccsds.moims.mo.com.archive.structures.CompositeFilter(),
        new org.ccsds.moims.mo.com.archive.structures.CompositeFilterList(),
        new org.ccsds.moims.mo.com.archive.structures.CompositeFilterSet(),
        new org.ccsds.moims.mo.com.archive.structures.CompositeFilterSetList(),};

    /**
     * The set of operations for this service.
     */
    public static final org.ccsds.moims.mo.mal.MALOperation[] OPERATIONS = new org.ccsds.moims.mo.mal.MALOperation[]{RETRIEVE_OP,
        QUERY_OP,
        COUNT_OP,
        STORE_OP,
        UPDATE_OP,
        DELETE_OP};

    /**
     * Literal for object OBJECTSTORED.
     */
    @Deprecated
    public static final int _OBJECTSTORED_OBJECT_NUMBER = 1;

    /**
     * Instance for object OBJECTSTORED.
     */
    @Deprecated
    public static final org.ccsds.moims.mo.mal.structures.UShort OBJECTSTORED_OBJECT_NUMBER = new org.ccsds.moims.mo.mal.structures.UShort(_OBJECTSTORED_OBJECT_NUMBER);

    /**
     * Object name constant.
     */
    @Deprecated
    public static final org.ccsds.moims.mo.mal.structures.Identifier OBJECTSTORED_OBJECT_NAME = new org.ccsds.moims.mo.mal.structures.Identifier("ObjectStored");

    /**
     * Object type constant.
     */
    @Deprecated
    public static final org.ccsds.moims.mo.com.structures.ObjectType OBJECTSTORED_OBJECT_TYPE = new org.ccsds.moims.mo.com.structures.ObjectType(new org.ccsds.moims.mo.mal.structures.UShort(2), ARCHIVE_SERVICE_NUMBER, new org.ccsds.moims.mo.mal.structures.UOctet(1), OBJECTSTORED_OBJECT_NUMBER);

    /**
     * Object instance.
     */
    @Deprecated
    public static org.ccsds.moims.mo.com.COMObject OBJECTSTORED_OBJECT = new org.ccsds.moims.mo.com.COMObject(OBJECTSTORED_OBJECT_TYPE, OBJECTSTORED_OBJECT_NAME, null, false, null, true, null, true);

    /**
     * Literal for object OBJECTUPDATED.
     */
    @Deprecated
    public static final int _OBJECTUPDATED_OBJECT_NUMBER = 2;

    /**
     * Instance for object OBJECTUPDATED.
     */
    @Deprecated
    public static final org.ccsds.moims.mo.mal.structures.UShort OBJECTUPDATED_OBJECT_NUMBER = new org.ccsds.moims.mo.mal.structures.UShort(_OBJECTUPDATED_OBJECT_NUMBER);

    /**
     * Object name constant.
     */
    @Deprecated
    public static final org.ccsds.moims.mo.mal.structures.Identifier OBJECTUPDATED_OBJECT_NAME = new org.ccsds.moims.mo.mal.structures.Identifier("ObjectUpdated");

    /**
     * Object type constant.
     */
    @Deprecated
    public static final org.ccsds.moims.mo.com.structures.ObjectType OBJECTUPDATED_OBJECT_TYPE = new org.ccsds.moims.mo.com.structures.ObjectType(new org.ccsds.moims.mo.mal.structures.UShort(2), ARCHIVE_SERVICE_NUMBER, new org.ccsds.moims.mo.mal.structures.UOctet(1), OBJECTUPDATED_OBJECT_NUMBER);

    /**
     * Object instance.
     */
    @Deprecated
    public static org.ccsds.moims.mo.com.COMObject OBJECTUPDATED_OBJECT = new org.ccsds.moims.mo.com.COMObject(OBJECTUPDATED_OBJECT_TYPE, OBJECTUPDATED_OBJECT_NAME, null, false, null, true, null, true);

    /**
     * Literal for object OBJECTDELETED.
     */
    @Deprecated
    public static final int _OBJECTDELETED_OBJECT_NUMBER = 3;

    /**
     * Instance for object OBJECTDELETED.
     */
    @Deprecated
    public static final org.ccsds.moims.mo.mal.structures.UShort OBJECTDELETED_OBJECT_NUMBER = new org.ccsds.moims.mo.mal.structures.UShort(_OBJECTDELETED_OBJECT_NUMBER);

    /**
     * Object name constant.
     */
    @Deprecated
    public static final org.ccsds.moims.mo.mal.structures.Identifier OBJECTDELETED_OBJECT_NAME = new org.ccsds.moims.mo.mal.structures.Identifier("ObjectDeleted");

    /**
     * Object type constant.
     */
    @Deprecated
    public static final org.ccsds.moims.mo.com.structures.ObjectType OBJECTDELETED_OBJECT_TYPE = new org.ccsds.moims.mo.com.structures.ObjectType(new org.ccsds.moims.mo.mal.structures.UShort(2), ARCHIVE_SERVICE_NUMBER, new org.ccsds.moims.mo.mal.structures.UOctet(1), OBJECTDELETED_OBJECT_NUMBER);

    /**
     * Object instance.
     */
    @Deprecated
    public static org.ccsds.moims.mo.com.COMObject OBJECTDELETED_OBJECT = new org.ccsds.moims.mo.com.COMObject(OBJECTDELETED_OBJECT_TYPE, OBJECTDELETED_OBJECT_NAME, null, false, null, true, null, true);

    /**
     * Object instance.
     */
    public static final org.ccsds.moims.mo.com.COMObject[] COM_OBJECTS = {
        OBJECTSTORED_OBJECT,
        OBJECTUPDATED_OBJECT,
        OBJECTDELETED_OBJECT,};

    /**
     * 
     */
    public ArchiveServiceInfo() {
        super(SERVICE_KEY, ARCHIVE_SERVICE_NAME, ARCHIVE_SERVICE_ELEMENTS, OPERATIONS, COM_OBJECTS);
    }

    @Override
    public org.ccsds.moims.mo.mal.MALArea getArea() {
        return org.ccsds.moims.mo.com.COMHelper.COM_AREA;
    }

}
