/**
 * An event is a specific object representing &quot;something that happens
 * in the system at a given point in time&quot;. The event service provides
 * a generic mechanism for the distribution of events.
 * An event is a special type of COM object and is identified by the normal
 * object fields (domain, object type, and object instance identifier).
 * It may also contain:
 * <ul>
 * <li>a link to a source object (that caused the event to be generated)</li>
 * <li>a link to a service specific related object</li>
 * <li>a body that is specific to the event type and whose data structure
 * is defined by the service that declares the event.</li>
 * </ul>
 * The event service only defines a single operation that supports the publishing
 * of events and subscription of events generated by other components.
 * Events are published with a MAL update type of DELETION. Events are something
 * that happens at a given point in time, therefore they in themselves have
 * no lifetime, they are created and deleted at the time instant in time.
 * For efficiency purposes only the deletion update is used.
*/
package org.ccsds.moims.mo.com.event;
