package org.ccsds.moims.mo.mc;

/**
 * The ReadOnlyException exception. The operation attempted to modify read-only
 * data, which cannot be changed.
 */
public final class ReadOnlyException extends org.ccsds.moims.mo.mal.MOErrorException {

    /**
     * Constructs a new ReadOnlyException exception.
     * 
     */
    public ReadOnlyException() {
        super(MCHelper.READ_ONLY_ERROR_NUMBER, "");
    }

    /**
     * Constructs a new ReadOnlyException exception.
     * 
     * @param extraInformation The extraInformation of the exception.
     */
    public ReadOnlyException(Object extraInformation) {
        super(MCHelper.READ_ONLY_ERROR_NUMBER, extraInformation);
    }

}
