package org.ccsds.moims.mo.mc.action.consumer;

/**
 * Consumer stub for Action service.
 */
public class ActionStub {

    private final org.ccsds.moims.mo.mal.consumer.MALConsumer consumer;

    /**
     * Wraps a MALconsumer connection with service specific methods that map from
     * the high level service API to the generic MAL API.
     * 
     * @param consumer consumer The MALConsumer to use in this stub.
     */
    public ActionStub(org.ccsds.moims.mo.mal.consumer.MALConsumer consumer) {
        this.consumer = consumer;
    }

    /**
     * Returns the internal MAL consumer object used for sending of messages from
     * this interface.
     * 
     * @return The MAL consumer object.
     */
    public org.ccsds.moims.mo.mal.consumer.MALConsumer getConsumer() {
        return consumer;
    }

    /**
     * The execute operation allows a consumer to request a provider to execute
     * an action.
     * 
     * @param executionRequest .
     * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem
     * during the interaction as defined by the MAL specification.
     * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation
     * exception.
     */
    public void execute(org.ccsds.moims.mo.mc.structures.ActionExecutionRequest executionRequest) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException {
        consumer.submit(org.ccsds.moims.mo.mc.action.ActionServiceInfo.EXECUTE_OP, executionRequest);
    }

    /**
     * Asynchronous version of method execute.
     * 
     * @param executionRequest .
     * @param adapter adapter Listener in charge of receiving the messages from
     * the service provider.
     * @return the MAL message sent to initiate the interaction.
     * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem
     * during the interaction as defined by the MAL specification.
     * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation
     * exception.
     */
    public org.ccsds.moims.mo.mal.transport.MALMessage asyncExecute(org.ccsds.moims.mo.mc.structures.ActionExecutionRequest executionRequest,
            org.ccsds.moims.mo.mc.action.consumer.ActionAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException {
        return consumer.asyncSubmit(org.ccsds.moims.mo.mc.action.ActionServiceInfo.EXECUTE_OP, adapter, executionRequest);
    }

    /**
     * Continues a previously started interaction.
     * 
     * @param lastInteractionStage lastInteractionStage The last stage of the
     * interaction to continue.
     * @param initiationTimestamp initiationTimestamp Timestamp of the interaction
     * initiation message.
     * @param transactionId transactionId Transaction identifier of the interaction
     * to continue.
     * @param adapter adapter Listener in charge of receiving the messages from
     * the service provider.
     * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem
     * during the interaction as defined by the MAL specification.
     * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation
     * exception.
     */
    public void continueExecute(org.ccsds.moims.mo.mal.structures.UOctet lastInteractionStage,
            org.ccsds.moims.mo.mal.structures.Time initiationTimestamp,
            Long transactionId,
            org.ccsds.moims.mo.mc.action.consumer.ActionAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException {
        consumer.continueInteraction(org.ccsds.moims.mo.mc.action.ActionServiceInfo.EXECUTE_OP, lastInteractionStage, initiationTimestamp, transactionId, adapter);
    }

    /**
     * Register method for the monitorExecution PubSub interaction.
     * 
     * @param subscription subscription the subscription to register for.
     * @param adapter adapter Listener in charge of receiving the messages from
     * the service provider.
     * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem
     * during the interaction as defined by the MAL specification.
     * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation
     * exception.
     */
    public void monitorExecutionRegister(org.ccsds.moims.mo.mal.structures.Subscription subscription,
            org.ccsds.moims.mo.mc.action.consumer.ActionAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException {
        consumer.register(org.ccsds.moims.mo.mc.action.ActionServiceInfo.MONITOREXECUTION_OP, subscription, adapter);
    }

    /**
     * Asynchronous version of method monitorExecutionRegister.
     * 
     * @param subscription subscription the subscription to register for.
     * @param adapter adapter Listener in charge of receiving the messages from
     * the service provider.
     * @return the MAL message sent to initiate the interaction.
     * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem
     * during the interaction as defined by the MAL specification.
     * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation
     * exception.
     */
    public org.ccsds.moims.mo.mal.transport.MALMessage asyncMonitorExecutionRegister(org.ccsds.moims.mo.mal.structures.Subscription subscription,
            org.ccsds.moims.mo.mc.action.consumer.ActionAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException {
        return consumer.asyncRegister(org.ccsds.moims.mo.mc.action.ActionServiceInfo.MONITOREXECUTION_OP, subscription, adapter);
    }

    /**
     * Deregister method for the monitorExecution PubSub interaction.
     * 
     * @param identifierList identifierList the subscription identifiers to deregister.
     * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem
     * during the interaction as defined by the MAL specification.
     * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation
     * exception.
     */
    public void monitorExecutionDeregister(org.ccsds.moims.mo.mal.structures.IdentifierList identifierList) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException {
        consumer.deregister(org.ccsds.moims.mo.mc.action.ActionServiceInfo.MONITOREXECUTION_OP, identifierList);
    }

    /**
     * Asynchronous version of method monitorExecutionDeregister.
     * 
     * @param identifierList identifierList the subscription identifiers to deregister.
     * @param adapter adapter Listener in charge of receiving the messages from
     * the service provider.
     * @return the MAL message sent to initiate the interaction.
     * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem
     * during the interaction as defined by the MAL specification.
     * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation
     * exception.
     */
    public org.ccsds.moims.mo.mal.transport.MALMessage asyncMonitorExecutionDeregister(org.ccsds.moims.mo.mal.structures.IdentifierList identifierList,
            org.ccsds.moims.mo.mc.action.consumer.ActionAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException {
        return consumer.asyncDeregister(org.ccsds.moims.mo.mc.action.ActionServiceInfo.MONITOREXECUTION_OP, identifierList, adapter);
    }

}
