package org.ccsds.moims.mo.mc.aggregation;

/**
 * Helper class for Aggregation service.
 */
public class AggregationServiceInfo extends org.ccsds.moims.mo.mal.ServiceInfo {

    /**
     * Service number literal.
     */
    public static final int _AGGREGATION_SERVICE_NUMBER = 6;

    /**
     * Service number instance.
     */
    public static final org.ccsds.moims.mo.mal.structures.UShort AGGREGATION_SERVICE_NUMBER = new org.ccsds.moims.mo.mal.structures.UShort(_AGGREGATION_SERVICE_NUMBER);

    /**
     * Service name constant.
     */
    public static final org.ccsds.moims.mo.mal.structures.Identifier AGGREGATION_SERVICE_NAME = new org.ccsds.moims.mo.mal.structures.Identifier("Aggregation");

    /**
     * The service key of this service.
     */
    public static final org.ccsds.moims.mo.mal.ServiceKey SERVICE_KEY = new org.ccsds.moims.mo.mal.ServiceKey(
            4,2,AGGREGATION_SERVICE_NUMBER);

    /**
     * Operation number literal for operation MONITORVALUE.
     */
    public static final int _MONITORVALUE_OP_NUMBER = 1;

    /**
     * Operation number instance for operation MONITORVALUE.
     */
    public static final org.ccsds.moims.mo.mal.structures.UShort MONITORVALUE_OP_NUMBER = new org.ccsds.moims.mo.mal.structures.UShort(_MONITORVALUE_OP_NUMBER);

    /**
     * Operation instance for operation MONITORVALUE.
     */
    public static final org.ccsds.moims.mo.mal.MALPubSubOperation MONITORVALUE_OP = new org.ccsds.moims.mo.mal.MALPubSubOperation(SERVICE_KEY, 
            MONITORVALUE_OP_NUMBER, 
            new org.ccsds.moims.mo.mal.structures.Identifier("monitorValue"), 
            new org.ccsds.moims.mo.mal.structures.UShort(1), 
            new org.ccsds.moims.mo.mal.OperationField[] {
                new org.ccsds.moims.mo.mal.OperationField("timestamp", false, org.ccsds.moims.mo.mal.structures.Attribute.TIME_SHORT_FORM),
                new org.ccsds.moims.mo.mal.OperationField("values", false, org.ccsds.moims.mo.mc.structures.ParameterValueDataList.SHORT_FORM)});

    /**
     * Key names instance for MONITORVALUE operation of pubsub interaction pattern.
     */
    public static final org.ccsds.moims.mo.mal.structures.Identifier [] _MONITORVALUE_OP_KEY_NAMES = {new org.ccsds.moims.mo.mal.structures.Identifier("aggregationKey"),
            new org.ccsds.moims.mo.mal.structures.Identifier("aggregationVersion")};

    /**
     * Key names instance for MONITORVALUE operation of pubsub interaction pattern.
     */
    public static final org.ccsds.moims.mo.mal.structures.IdentifierList MONITORVALUE_OP_KEY_NAMES = new org.ccsds.moims.mo.mal.structures.IdentifierList(new java.util.ArrayList<>(java.util.Arrays.asList(_MONITORVALUE_OP_KEY_NAMES)));

    /**
     * Operation number literal for operation GETVALUE.
     */
    public static final int _GETVALUE_OP_NUMBER = 2;

    /**
     * Operation number instance for operation GETVALUE.
     */
    public static final org.ccsds.moims.mo.mal.structures.UShort GETVALUE_OP_NUMBER = new org.ccsds.moims.mo.mal.structures.UShort(_GETVALUE_OP_NUMBER);

    /**
     * Operation instance for operation GETVALUE.
     */
    public static final org.ccsds.moims.mo.mal.MALRequestOperation GETVALUE_OP = new org.ccsds.moims.mo.mal.MALRequestOperation(SERVICE_KEY, 
            GETVALUE_OP_NUMBER, 
            new org.ccsds.moims.mo.mal.structures.Identifier("getValue"), 
            new org.ccsds.moims.mo.mal.structures.UShort(2), 
            new org.ccsds.moims.mo.mal.OperationField[] {
                new org.ccsds.moims.mo.mal.OperationField("domain", true, org.ccsds.moims.mo.mal.structures.IdentifierList.SHORT_FORM),
                new org.ccsds.moims.mo.mal.OperationField("keys", false, org.ccsds.moims.mo.mal.structures.IdentifierList.SHORT_FORM)}, 
            new org.ccsds.moims.mo.mal.OperationField[] {
                new org.ccsds.moims.mo.mal.OperationField("aggregationValues", false, org.ccsds.moims.mo.mc.structures.AggregationValueList.SHORT_FORM)});

    /**
     * Operation number literal for operation GETREPORTINGCONFIGURATION.
     */
    public static final int _GETREPORTINGCONFIGURATION_OP_NUMBER = 3;

    /**
     * Operation number instance for operation GETREPORTINGCONFIGURATION.
     */
    public static final org.ccsds.moims.mo.mal.structures.UShort GETREPORTINGCONFIGURATION_OP_NUMBER = new org.ccsds.moims.mo.mal.structures.UShort(_GETREPORTINGCONFIGURATION_OP_NUMBER);

    /**
     * Operation instance for operation GETREPORTINGCONFIGURATION.
     */
    public static final org.ccsds.moims.mo.mal.MALRequestOperation GETREPORTINGCONFIGURATION_OP = new org.ccsds.moims.mo.mal.MALRequestOperation(SERVICE_KEY, 
            GETREPORTINGCONFIGURATION_OP_NUMBER, 
            new org.ccsds.moims.mo.mal.structures.Identifier("getReportingConfiguration"), 
            new org.ccsds.moims.mo.mal.structures.UShort(3), 
            new org.ccsds.moims.mo.mal.OperationField[] {
                new org.ccsds.moims.mo.mal.OperationField("domain", true, org.ccsds.moims.mo.mal.structures.IdentifierList.SHORT_FORM),
                new org.ccsds.moims.mo.mal.OperationField("keys", false, org.ccsds.moims.mo.mal.structures.IdentifierList.SHORT_FORM)}, 
            new org.ccsds.moims.mo.mal.OperationField[] {
                new org.ccsds.moims.mo.mal.OperationField("reportConfigs", false, org.ccsds.moims.mo.mc.structures.ReportConfigurationList.SHORT_FORM)});

    /**
     * Operation number literal for operation ENABLEREPORTING.
     */
    public static final int _ENABLEREPORTING_OP_NUMBER = 4;

    /**
     * Operation number instance for operation ENABLEREPORTING.
     */
    public static final org.ccsds.moims.mo.mal.structures.UShort ENABLEREPORTING_OP_NUMBER = new org.ccsds.moims.mo.mal.structures.UShort(_ENABLEREPORTING_OP_NUMBER);

    /**
     * Operation instance for operation ENABLEREPORTING.
     */
    public static final org.ccsds.moims.mo.mal.MALSubmitOperation ENABLEREPORTING_OP = new org.ccsds.moims.mo.mal.MALSubmitOperation(SERVICE_KEY, 
            ENABLEREPORTING_OP_NUMBER, 
            new org.ccsds.moims.mo.mal.structures.Identifier("enableReporting"), 
            new org.ccsds.moims.mo.mal.structures.UShort(3), 
            new org.ccsds.moims.mo.mal.OperationField[] {
                new org.ccsds.moims.mo.mal.OperationField("domain", true, org.ccsds.moims.mo.mal.structures.IdentifierList.SHORT_FORM),
                new org.ccsds.moims.mo.mal.OperationField("keys", true, org.ccsds.moims.mo.mal.structures.IdentifierList.SHORT_FORM)});

    /**
     * Operation number literal for operation DISABLEREPORTING.
     */
    public static final int _DISABLEREPORTING_OP_NUMBER = 5;

    /**
     * Operation number instance for operation DISABLEREPORTING.
     */
    public static final org.ccsds.moims.mo.mal.structures.UShort DISABLEREPORTING_OP_NUMBER = new org.ccsds.moims.mo.mal.structures.UShort(_DISABLEREPORTING_OP_NUMBER);

    /**
     * Operation instance for operation DISABLEREPORTING.
     */
    public static final org.ccsds.moims.mo.mal.MALSubmitOperation DISABLEREPORTING_OP = new org.ccsds.moims.mo.mal.MALSubmitOperation(SERVICE_KEY, 
            DISABLEREPORTING_OP_NUMBER, 
            new org.ccsds.moims.mo.mal.structures.Identifier("disableReporting"), 
            new org.ccsds.moims.mo.mal.structures.UShort(3), 
            new org.ccsds.moims.mo.mal.OperationField[] {
                new org.ccsds.moims.mo.mal.OperationField("domain", true, org.ccsds.moims.mo.mal.structures.IdentifierList.SHORT_FORM),
                new org.ccsds.moims.mo.mal.OperationField("keys", true, org.ccsds.moims.mo.mal.structures.IdentifierList.SHORT_FORM)});

    /**
     * Operation number literal for operation SETREPORTINGPERIOD.
     */
    public static final int _SETREPORTINGPERIOD_OP_NUMBER = 6;

    /**
     * Operation number instance for operation SETREPORTINGPERIOD.
     */
    public static final org.ccsds.moims.mo.mal.structures.UShort SETREPORTINGPERIOD_OP_NUMBER = new org.ccsds.moims.mo.mal.structures.UShort(_SETREPORTINGPERIOD_OP_NUMBER);

    /**
     * Operation instance for operation SETREPORTINGPERIOD.
     */
    public static final org.ccsds.moims.mo.mal.MALSubmitOperation SETREPORTINGPERIOD_OP = new org.ccsds.moims.mo.mal.MALSubmitOperation(SERVICE_KEY, 
            SETREPORTINGPERIOD_OP_NUMBER, 
            new org.ccsds.moims.mo.mal.structures.Identifier("setReportingPeriod"), 
            new org.ccsds.moims.mo.mal.structures.UShort(3), 
            new org.ccsds.moims.mo.mal.OperationField[] {
                new org.ccsds.moims.mo.mal.OperationField("domain", true, org.ccsds.moims.mo.mal.structures.IdentifierList.SHORT_FORM),
                new org.ccsds.moims.mo.mal.OperationField("keys", false, org.ccsds.moims.mo.mal.structures.IdentifierList.SHORT_FORM),
                new org.ccsds.moims.mo.mal.OperationField("reportInterval", false, org.ccsds.moims.mo.mal.structures.Attribute.DURATION_SHORT_FORM)});

    /**
     * Operation number literal for operation LISTDEFINITION.
     */
    public static final int _LISTDEFINITION_OP_NUMBER = 7;

    /**
     * Operation number instance for operation LISTDEFINITION.
     */
    public static final org.ccsds.moims.mo.mal.structures.UShort LISTDEFINITION_OP_NUMBER = new org.ccsds.moims.mo.mal.structures.UShort(_LISTDEFINITION_OP_NUMBER);

    /**
     * Operation instance for operation LISTDEFINITION.
     */
    public static final org.ccsds.moims.mo.mal.MALRequestOperation LISTDEFINITION_OP = new org.ccsds.moims.mo.mal.MALRequestOperation(SERVICE_KEY, 
            LISTDEFINITION_OP_NUMBER, 
            new org.ccsds.moims.mo.mal.structures.Identifier("listDefinition"), 
            new org.ccsds.moims.mo.mal.structures.UShort(4), 
            new org.ccsds.moims.mo.mal.OperationField[] {
                new org.ccsds.moims.mo.mal.OperationField("domain", true, org.ccsds.moims.mo.mal.structures.IdentifierList.SHORT_FORM),
                new org.ccsds.moims.mo.mal.OperationField("keys", true, org.ccsds.moims.mo.mal.structures.IdentifierList.SHORT_FORM)}, 
            new org.ccsds.moims.mo.mal.OperationField[] {
                new org.ccsds.moims.mo.mal.OperationField("definitions", false, org.ccsds.moims.mo.mc.structures.AggregationDefinitionList.SHORT_FORM)});

    /**
     * Operation number literal for operation ADDAGGREGATION.
     */
    public static final int _ADDAGGREGATION_OP_NUMBER = 8;

    /**
     * Operation number instance for operation ADDAGGREGATION.
     */
    public static final org.ccsds.moims.mo.mal.structures.UShort ADDAGGREGATION_OP_NUMBER = new org.ccsds.moims.mo.mal.structures.UShort(_ADDAGGREGATION_OP_NUMBER);

    /**
     * Operation instance for operation ADDAGGREGATION.
     */
    public static final org.ccsds.moims.mo.mal.MALSubmitOperation ADDAGGREGATION_OP = new org.ccsds.moims.mo.mal.MALSubmitOperation(SERVICE_KEY, 
            ADDAGGREGATION_OP_NUMBER, 
            new org.ccsds.moims.mo.mal.structures.Identifier("addAggregation"), 
            new org.ccsds.moims.mo.mal.structures.UShort(5), 
            new org.ccsds.moims.mo.mal.OperationField[] {
                new org.ccsds.moims.mo.mal.OperationField("newObjects", false, org.ccsds.moims.mo.mc.structures.AggregationDefinitionList.SHORT_FORM)});

    /**
     * Operation number literal for operation REMOVEAGGREGATION.
     */
    public static final int _REMOVEAGGREGATION_OP_NUMBER = 9;

    /**
     * Operation number instance for operation REMOVEAGGREGATION.
     */
    public static final org.ccsds.moims.mo.mal.structures.UShort REMOVEAGGREGATION_OP_NUMBER = new org.ccsds.moims.mo.mal.structures.UShort(_REMOVEAGGREGATION_OP_NUMBER);

    /**
     * Operation instance for operation REMOVEAGGREGATION.
     */
    public static final org.ccsds.moims.mo.mal.MALSubmitOperation REMOVEAGGREGATION_OP = new org.ccsds.moims.mo.mal.MALSubmitOperation(SERVICE_KEY, 
            REMOVEAGGREGATION_OP_NUMBER, 
            new org.ccsds.moims.mo.mal.structures.Identifier("removeAggregation"), 
            new org.ccsds.moims.mo.mal.structures.UShort(5), 
            new org.ccsds.moims.mo.mal.OperationField[] {
                new org.ccsds.moims.mo.mal.OperationField("domain", true, org.ccsds.moims.mo.mal.structures.IdentifierList.SHORT_FORM),
                new org.ccsds.moims.mo.mal.OperationField("keys", false, org.ccsds.moims.mo.mal.structures.IdentifierList.SHORT_FORM)});

    /**
     * Area elements.
     */
    public static final org.ccsds.moims.mo.mal.structures.Element[] AGGREGATION_SERVICE_ELEMENTS = {};

    /**
     * The set of operations for this service.
     */
    public static final org.ccsds.moims.mo.mal.MALOperation[] OPERATIONS = new org.ccsds.moims.mo.mal.MALOperation[]{MONITORVALUE_OP,
        GETVALUE_OP,
        GETREPORTINGCONFIGURATION_OP,
        ENABLEREPORTING_OP,
        DISABLEREPORTING_OP,
        SETREPORTINGPERIOD_OP,
        LISTDEFINITION_OP,
        ADDAGGREGATION_OP,
        REMOVEAGGREGATION_OP};

    /**
     * 
     */
    public AggregationServiceInfo() {
        super(SERVICE_KEY, AGGREGATION_SERVICE_NAME, AGGREGATION_SERVICE_ELEMENTS, OPERATIONS);
    }

    @Override
    public org.ccsds.moims.mo.mal.MALArea getArea() {
        return org.ccsds.moims.mo.mc.MCHelper.MC_AREA;
    }

}
