package org.ccsds.moims.mo.mc.aggregation.consumer;

/**
 * Consumer adapter for Aggregation service.
 */
public abstract class AggregationAdapter extends org.ccsds.moims.mo.mal.consumer.MALInteractionAdapter {

    /**
     * Called by the MAL when a PubSub register acknowledgement is received from
     * a broker for the operation monitorValue.
     * 
     * @param msgHeader msgHeader The header of the received message.
     * @param qosProperties qosProperties The QoS properties associated with the
     * message.
     */
    public void monitorValueRegisterAckReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader,
            java.util.Map qosProperties) {
    }

    /**
     * Called by the MAL when a PubSub register acknowledgement error is received
     * from a broker for the operation monitorValue.
     * 
     * @param msgHeader msgHeader The header of the received message.
     * @param error error The received error message.
     * @param qosProperties qosProperties The QoS properties associated with the
     * message.
     */
    public void monitorValueRegisterErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader,
            org.ccsds.moims.mo.mal.MOErrorException error,
            java.util.Map qosProperties) {
    }

    /**
     * Called by the MAL when a PubSub deregister acknowledgement is received
     * from a broker for the operation monitorValue.
     * 
     * @param msgHeader msgHeader The header of the received message.
     * @param qosProperties qosProperties The QoS properties associated with the
     * message.
     */
    public void monitorValueDeregisterAckReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader,
            java.util.Map qosProperties) {
    }

    /**
     * Called by the MAL when a PubSub update is received from a broker for the
     * operation monitorValue.
     * 
     * @param msgHeader msgHeader The header of the received message.
     * @param subscriptionId The subscriptionId of the subscription.
     * @param updateHeader The Update header.
     * @param timestamp .
     * @param values .
     * @param qosProperties qosProperties The QoS properties associated with the
     * message.
     */
    public void monitorValueNotifyReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader,
            org.ccsds.moims.mo.mal.structures.Identifier subscriptionId,
            org.ccsds.moims.mo.mal.structures.UpdateHeader updateHeader,
            org.ccsds.moims.mo.mal.structures.Time timestamp,
            org.ccsds.moims.mo.mc.structures.ParameterValueDataList values,
            java.util.Map qosProperties) {
    }

    /**
     * Called by the MAL when a PubSub update error is received from a broker
     * for the operation monitorValue.
     * 
     * @param msgHeader msgHeader The header of the received message.
     * @param error error The received error message.
     * @param qosProperties qosProperties The QoS properties associated with the
     * message.
     */
    public void monitorValueNotifyErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader,
            org.ccsds.moims.mo.mal.MOErrorException error,
            java.util.Map qosProperties) {
    }

    /**
     * Called by the MAL when a REQUEST response is received from a provider for
     * the operation getValue.
     * 
     * @param msgHeader msgHeader The header of the received message.
     * @param aggregationValues .
     * @param qosProperties qosProperties The QoS properties associated with the
     * message.
     */
    public void getValueResponseReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader,
            org.ccsds.moims.mo.mc.structures.AggregationValueList aggregationValues,
            java.util.Map qosProperties) {
    }

    /**
     * Called by the MAL when a REQUEST response error is received from a provider
     * for the operation getValue.
     * 
     * @param msgHeader msgHeader The header of the received message.
     * @param error error The received error message.
     * @param qosProperties qosProperties The QoS properties associated with the
     * message.
     */
    public void getValueErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader,
            org.ccsds.moims.mo.mal.MOErrorException error,
            java.util.Map qosProperties) {
    }

    /**
     * Called by the MAL when a REQUEST response is received from a provider for
     * the operation getReportingConfiguration.
     * 
     * @param msgHeader msgHeader The header of the received message.
     * @param reportConfigs .
     * @param qosProperties qosProperties The QoS properties associated with the
     * message.
     */
    public void getReportingConfigurationResponseReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader,
            org.ccsds.moims.mo.mc.structures.ReportConfigurationList reportConfigs,
            java.util.Map qosProperties) {
    }

    /**
     * Called by the MAL when a REQUEST response error is received from a provider
     * for the operation getReportingConfiguration.
     * 
     * @param msgHeader msgHeader The header of the received message.
     * @param error error The received error message.
     * @param qosProperties qosProperties The QoS properties associated with the
     * message.
     */
    public void getReportingConfigurationErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader,
            org.ccsds.moims.mo.mal.MOErrorException error,
            java.util.Map qosProperties) {
    }

    /**
     * Called by the MAL when a SUBMIT acknowledgement is received from a provider
     * for the operation enableReporting.
     * 
     * @param msgHeader msgHeader The header of the received message.
     * @param qosProperties qosProperties The QoS properties associated with the
     * message.
     */
    public void enableReportingAckReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader,
            java.util.Map qosProperties) {
    }

    /**
     * Called by the MAL when a SUBMIT acknowledgement error is received from
     * a provider for the operation enableReporting.
     * 
     * @param msgHeader msgHeader The header of the received message.
     * @param error error The received error message.
     * @param qosProperties qosProperties The QoS properties associated with the
     * message.
     */
    public void enableReportingErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader,
            org.ccsds.moims.mo.mal.MOErrorException error,
            java.util.Map qosProperties) {
    }

    /**
     * Called by the MAL when a SUBMIT acknowledgement is received from a provider
     * for the operation disableReporting.
     * 
     * @param msgHeader msgHeader The header of the received message.
     * @param qosProperties qosProperties The QoS properties associated with the
     * message.
     */
    public void disableReportingAckReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader,
            java.util.Map qosProperties) {
    }

    /**
     * Called by the MAL when a SUBMIT acknowledgement error is received from
     * a provider for the operation disableReporting.
     * 
     * @param msgHeader msgHeader The header of the received message.
     * @param error error The received error message.
     * @param qosProperties qosProperties The QoS properties associated with the
     * message.
     */
    public void disableReportingErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader,
            org.ccsds.moims.mo.mal.MOErrorException error,
            java.util.Map qosProperties) {
    }

    /**
     * Called by the MAL when a SUBMIT acknowledgement is received from a provider
     * for the operation setReportingPeriod.
     * 
     * @param msgHeader msgHeader The header of the received message.
     * @param qosProperties qosProperties The QoS properties associated with the
     * message.
     */
    public void setReportingPeriodAckReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader,
            java.util.Map qosProperties) {
    }

    /**
     * Called by the MAL when a SUBMIT acknowledgement error is received from
     * a provider for the operation setReportingPeriod.
     * 
     * @param msgHeader msgHeader The header of the received message.
     * @param error error The received error message.
     * @param qosProperties qosProperties The QoS properties associated with the
     * message.
     */
    public void setReportingPeriodErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader,
            org.ccsds.moims.mo.mal.MOErrorException error,
            java.util.Map qosProperties) {
    }

    /**
     * Called by the MAL when a REQUEST response is received from a provider for
     * the operation listDefinition.
     * 
     * @param msgHeader msgHeader The header of the received message.
     * @param definitions .
     * @param qosProperties qosProperties The QoS properties associated with the
     * message.
     */
    public void listDefinitionResponseReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader,
            org.ccsds.moims.mo.mc.structures.AggregationDefinitionList definitions,
            java.util.Map qosProperties) {
    }

    /**
     * Called by the MAL when a REQUEST response error is received from a provider
     * for the operation listDefinition.
     * 
     * @param msgHeader msgHeader The header of the received message.
     * @param error error The received error message.
     * @param qosProperties qosProperties The QoS properties associated with the
     * message.
     */
    public void listDefinitionErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader,
            org.ccsds.moims.mo.mal.MOErrorException error,
            java.util.Map qosProperties) {
    }

    /**
     * Called by the MAL when a SUBMIT acknowledgement is received from a provider
     * for the operation addAggregation.
     * 
     * @param msgHeader msgHeader The header of the received message.
     * @param qosProperties qosProperties The QoS properties associated with the
     * message.
     */
    public void addAggregationAckReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader,
            java.util.Map qosProperties) {
    }

    /**
     * Called by the MAL when a SUBMIT acknowledgement error is received from
     * a provider for the operation addAggregation.
     * 
     * @param msgHeader msgHeader The header of the received message.
     * @param error error The received error message.
     * @param qosProperties qosProperties The QoS properties associated with the
     * message.
     */
    public void addAggregationErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader,
            org.ccsds.moims.mo.mal.MOErrorException error,
            java.util.Map qosProperties) {
    }

    /**
     * Called by the MAL when a SUBMIT acknowledgement is received from a provider
     * for the operation removeAggregation.
     * 
     * @param msgHeader msgHeader The header of the received message.
     * @param qosProperties qosProperties The QoS properties associated with the
     * message.
     */
    public void removeAggregationAckReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader,
            java.util.Map qosProperties) {
    }

    /**
     * Called by the MAL when a SUBMIT acknowledgement error is received from
     * a provider for the operation removeAggregation.
     * 
     * @param msgHeader msgHeader The header of the received message.
     * @param error error The received error message.
     * @param qosProperties qosProperties The QoS properties associated with the
     * message.
     */
    public void removeAggregationErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader,
            org.ccsds.moims.mo.mal.MOErrorException error,
            java.util.Map qosProperties) {
    }

    /**
     * Called by the MAL when a SUBMIT acknowledgement is received from a provider.
     * 
     * @param msgHeader msgHeader The header of the received message.
     * @param qosProperties qosProperties The QoS properties associated with the
     * message.
     * @throws org.ccsds.moims.mo.mal.MALException if an error is detected processing
     * the message.
     */
    public final void submitAckReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader,
            java.util.Map qosProperties) throws org.ccsds.moims.mo.mal.MALException {
        switch (msgHeader.getOperation().getValue()) {
          case org.ccsds.moims.mo.mc.aggregation.AggregationServiceInfo._ENABLEREPORTING_OP_NUMBER:
            enableReportingAckReceived(msgHeader, qosProperties);
            break;
          case org.ccsds.moims.mo.mc.aggregation.AggregationServiceInfo._DISABLEREPORTING_OP_NUMBER:
            disableReportingAckReceived(msgHeader, qosProperties);
            break;
          case org.ccsds.moims.mo.mc.aggregation.AggregationServiceInfo._SETREPORTINGPERIOD_OP_NUMBER:
            setReportingPeriodAckReceived(msgHeader, qosProperties);
            break;
          case org.ccsds.moims.mo.mc.aggregation.AggregationServiceInfo._ADDAGGREGATION_OP_NUMBER:
            addAggregationAckReceived(msgHeader, qosProperties);
            break;
          case org.ccsds.moims.mo.mc.aggregation.AggregationServiceInfo._REMOVEAGGREGATION_OP_NUMBER:
            removeAggregationAckReceived(msgHeader, qosProperties);
            break;
          default:
            throw new org.ccsds.moims.mo.mal.MALException("Consumer adapter was not expecting operation number " + msgHeader.getOperation().getValue());
        }
    }

    /**
     * Called by the MAL when a SUBMIT acknowledgement error is received from
     * a provider.
     * 
     * @param msgHeader msgHeader The header of the received message.
     * @param body body The body of the received message.
     * @param qosProperties qosProperties The QoS properties associated with the
     * message.
     * @throws org.ccsds.moims.mo.mal.MALException if an error is detected processing
     * the message.
     */
    public final void submitErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader,
            org.ccsds.moims.mo.mal.transport.MALErrorBody body,
            java.util.Map qosProperties) throws org.ccsds.moims.mo.mal.MALException {
        switch (msgHeader.getOperation().getValue()) {
          case org.ccsds.moims.mo.mc.aggregation.AggregationServiceInfo._ENABLEREPORTING_OP_NUMBER:
            enableReportingErrorReceived(msgHeader, body.getError(), qosProperties);
            break;
          case org.ccsds.moims.mo.mc.aggregation.AggregationServiceInfo._DISABLEREPORTING_OP_NUMBER:
            disableReportingErrorReceived(msgHeader, body.getError(), qosProperties);
            break;
          case org.ccsds.moims.mo.mc.aggregation.AggregationServiceInfo._SETREPORTINGPERIOD_OP_NUMBER:
            setReportingPeriodErrorReceived(msgHeader, body.getError(), qosProperties);
            break;
          case org.ccsds.moims.mo.mc.aggregation.AggregationServiceInfo._ADDAGGREGATION_OP_NUMBER:
            addAggregationErrorReceived(msgHeader, body.getError(), qosProperties);
            break;
          case org.ccsds.moims.mo.mc.aggregation.AggregationServiceInfo._REMOVEAGGREGATION_OP_NUMBER:
            removeAggregationErrorReceived(msgHeader, body.getError(), qosProperties);
            break;
          default:
            throw new org.ccsds.moims.mo.mal.MALException("Consumer adapter was not expecting operation number " + msgHeader.getOperation().getValue());
        }
    }

    /**
     * Called by the MAL when a REQUEST response is received from a provider.
     * 
     * @param msgHeader msgHeader The header of the received message.
     * @param body body The body of the received message.
     * @param qosProperties qosProperties The QoS properties associated with the
     * message.
     * @throws org.ccsds.moims.mo.mal.MALException if an error is detected processing
     * the message.
     */
    public final void requestResponseReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader,
            org.ccsds.moims.mo.mal.transport.MALMessageBody body,
            java.util.Map qosProperties) throws org.ccsds.moims.mo.mal.MALException {
        switch (msgHeader.getOperation().getValue()) {
          case org.ccsds.moims.mo.mc.aggregation.AggregationServiceInfo._GETVALUE_OP_NUMBER:
            getValueResponseReceived(msgHeader,
                (org.ccsds.moims.mo.mc.structures.AggregationValueList) body.getBodyElement(0, new org.ccsds.moims.mo.mc.structures.AggregationValueList()), qosProperties);
            break;
          case org.ccsds.moims.mo.mc.aggregation.AggregationServiceInfo._GETREPORTINGCONFIGURATION_OP_NUMBER:
            getReportingConfigurationResponseReceived(msgHeader,
                (org.ccsds.moims.mo.mc.structures.ReportConfigurationList) body.getBodyElement(0, new org.ccsds.moims.mo.mc.structures.ReportConfigurationList()), qosProperties);
            break;
          case org.ccsds.moims.mo.mc.aggregation.AggregationServiceInfo._LISTDEFINITION_OP_NUMBER:
            listDefinitionResponseReceived(msgHeader,
                (org.ccsds.moims.mo.mc.structures.AggregationDefinitionList) body.getBodyElement(0, new org.ccsds.moims.mo.mc.structures.AggregationDefinitionList()), qosProperties);
            break;
          default:
            throw new org.ccsds.moims.mo.mal.MALException("Consumer adapter was not expecting operation number " + msgHeader.getOperation().getValue());
        }
    }

    /**
     * Called by the MAL when a REQUEST response error is received from a provider.
     * 
     * @param msgHeader msgHeader The header of the received message.
     * @param body body The body of the received message.
     * @param qosProperties qosProperties The QoS properties associated with the
     * message.
     * @throws org.ccsds.moims.mo.mal.MALException if an error is detected processing
     * the message.
     */
    public final void requestErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader,
            org.ccsds.moims.mo.mal.transport.MALErrorBody body,
            java.util.Map qosProperties) throws org.ccsds.moims.mo.mal.MALException {
        switch (msgHeader.getOperation().getValue()) {
          case org.ccsds.moims.mo.mc.aggregation.AggregationServiceInfo._GETVALUE_OP_NUMBER:
            getValueErrorReceived(msgHeader, body.getError(), qosProperties);
            break;
          case org.ccsds.moims.mo.mc.aggregation.AggregationServiceInfo._GETREPORTINGCONFIGURATION_OP_NUMBER:
            getReportingConfigurationErrorReceived(msgHeader, body.getError(), qosProperties);
            break;
          case org.ccsds.moims.mo.mc.aggregation.AggregationServiceInfo._LISTDEFINITION_OP_NUMBER:
            listDefinitionErrorReceived(msgHeader, body.getError(), qosProperties);
            break;
          default:
            throw new org.ccsds.moims.mo.mal.MALException("Consumer adapter was not expecting operation number " + msgHeader.getOperation().getValue());
        }
    }

    /**
     * Called by the MAL when a PubSub register acknowledgement is received from
     * a broker.
     * 
     * @param msgHeader msgHeader The header of the received message.
     * @param qosProperties qosProperties The QoS properties associated with the
     * message.
     * @throws org.ccsds.moims.mo.mal.MALException if an error is detected processing
     * the message.
     */
    public final void registerAckReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader,
            java.util.Map qosProperties) throws org.ccsds.moims.mo.mal.MALException {
        switch (msgHeader.getOperation().getValue()) {
          case org.ccsds.moims.mo.mc.aggregation.AggregationServiceInfo._MONITORVALUE_OP_NUMBER:
            monitorValueRegisterAckReceived(msgHeader, qosProperties);
            break;
          default:
            throw new org.ccsds.moims.mo.mal.MALException("Consumer adapter was not expecting operation number " + msgHeader.getOperation().getValue());
        }
    }

    /**
     * Called by the MAL when a PubSub register acknowledgement error is received
     * from a broker.
     * 
     * @param msgHeader msgHeader The header of the received message.
     * @param body body The body of the received message.
     * @param qosProperties qosProperties The QoS properties associated with the
     * message.
     * @throws org.ccsds.moims.mo.mal.MALException if an error is detected processing
     * the message.
     */
    public final void registerErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader,
            org.ccsds.moims.mo.mal.transport.MALErrorBody body,
            java.util.Map qosProperties) throws org.ccsds.moims.mo.mal.MALException {
        switch (msgHeader.getOperation().getValue()) {
          case org.ccsds.moims.mo.mc.aggregation.AggregationServiceInfo._MONITORVALUE_OP_NUMBER:
            monitorValueRegisterErrorReceived(msgHeader, body.getError(), qosProperties);
            break;
          default:
            throw new org.ccsds.moims.mo.mal.MALException("Consumer adapter was not expecting operation number " + msgHeader.getOperation().getValue());
        }
    }

    /**
     * Called by the MAL when a PubSub update is received from a broker.
     * 
     * @param msgHeader msgHeader The header of the received message.
     * @param body body The body of the received message.
     * @param qosProperties qosProperties The QoS properties associated with the
     * message.
     * @throws org.ccsds.moims.mo.mal.MALException if an error is detected processing
     * the message.
     */
    public final void notifyReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader,
            org.ccsds.moims.mo.mal.transport.MALNotifyBody body,
            java.util.Map qosProperties) throws org.ccsds.moims.mo.mal.MALException {
        if ((org.ccsds.moims.mo.mc.MCHelper.MC_AREA_NUMBER.equals(msgHeader.getServiceArea())) && (org.ccsds.moims.mo.mc.aggregation.AggregationServiceInfo.AGGREGATION_SERVICE_NUMBER.equals(msgHeader.getService()))) {
          switch (msgHeader.getOperation().getValue()) {
            case org.ccsds.moims.mo.mc.aggregation.AggregationServiceInfo._MONITORVALUE_OP_NUMBER:
              monitorValueNotifyReceived(msgHeader,
                (org.ccsds.moims.mo.mal.structures.Identifier) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Identifier()),
                (org.ccsds.moims.mo.mal.structures.UpdateHeader) body.getBodyElement(1, new org.ccsds.moims.mo.mal.structures.UpdateHeader()),
                (org.ccsds.moims.mo.mal.structures.Time) body.getBodyElement(2, new org.ccsds.moims.mo.mal.structures.Time()),
                (org.ccsds.moims.mo.mc.structures.ParameterValueDataList) body.getBodyElement(3, new org.ccsds.moims.mo.mc.structures.ParameterValueDataList()), qosProperties);
              break;
            default:
              throw new org.ccsds.moims.mo.mal.MALException("Consumer adapter was not expecting operation number " + msgHeader.getOperation().getValue());
          }
        }
        else {
          notifyReceivedFromOtherService(msgHeader, body, qosProperties);
        }
    }

    /**
     * Called by the MAL when a PubSub update error is received from a broker.
     * 
     * @param msgHeader msgHeader The header of the received message.
     * @param body body The body of the received message.
     * @param qosProperties qosProperties The QoS properties associated with the
     * message.
     * @throws org.ccsds.moims.mo.mal.MALException if an error is detected processing
     * the message.
     */
    public final void notifyErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader,
            org.ccsds.moims.mo.mal.transport.MALErrorBody body,
            java.util.Map qosProperties) throws org.ccsds.moims.mo.mal.MALException {
        switch (msgHeader.getOperation().getValue()) {
          case org.ccsds.moims.mo.mc.aggregation.AggregationServiceInfo._MONITORVALUE_OP_NUMBER:
            monitorValueNotifyErrorReceived(msgHeader, body.getError(), qosProperties);
            break;
          default:
            throw new org.ccsds.moims.mo.mal.MALException("Consumer adapter was not expecting operation number " + msgHeader.getOperation().getValue());
        }
    }

    /**
     * Called by the MAL when a PubSub deregister acknowledgement is received
     * from a broker.
     * 
     * @param msgHeader msgHeader The header of the received message.
     * @param qosProperties qosProperties The QoS properties associated with the
     * message.
     * @throws org.ccsds.moims.mo.mal.MALException if an error is detected processing
     * the message.
     */
    public final void deregisterAckReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader,
            java.util.Map qosProperties) throws org.ccsds.moims.mo.mal.MALException {
        switch (msgHeader.getOperation().getValue()) {
          case org.ccsds.moims.mo.mc.aggregation.AggregationServiceInfo._MONITORVALUE_OP_NUMBER:
            monitorValueDeregisterAckReceived(msgHeader, qosProperties);
            break;
          default:
            throw new org.ccsds.moims.mo.mal.MALException("Consumer adapter was not expecting operation number " + msgHeader.getOperation().getValue());
        }
    }

    /**
     * Called by the MAL when a PubSub update from another service is received
     * from a broker.
     * 
     * @param msgHeader msgHeader The header of the received message.
     * @param body body The body of the received message.
     * @param qosProperties qosProperties The QoS properties associated with the
     * message.
     * @throws org.ccsds.moims.mo.mal.MALException if an error is detected processing
     * the message.
     */
    public void notifyReceivedFromOtherService(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader,
            org.ccsds.moims.mo.mal.transport.MALNotifyBody body,
            java.util.Map qosProperties) throws org.ccsds.moims.mo.mal.MALException {
    }

}
