package org.ccsds.moims.mo.mc.aggregation.consumer;

/**
 * Consumer stub for Aggregation service.
 */
public class AggregationStub {

    private final org.ccsds.moims.mo.mal.consumer.MALConsumer consumer;

    /**
     * Wraps a MALconsumer connection with service specific methods that map from
     * the high level service API to the generic MAL API.
     * 
     * @param consumer consumer The MALConsumer to use in this stub.
     */
    public AggregationStub(org.ccsds.moims.mo.mal.consumer.MALConsumer consumer) {
        this.consumer = consumer;
    }

    /**
     * Returns the internal MAL consumer object used for sending of messages from
     * this interface.
     * 
     * @return The MAL consumer object.
     */
    public org.ccsds.moims.mo.mal.consumer.MALConsumer getConsumer() {
        return consumer;
    }

    /**
     * Register method for the monitorValue PubSub interaction.
     * 
     * @param subscription subscription the subscription to register for.
     * @param adapter adapter Listener in charge of receiving the messages from
     * the service provider.
     * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem
     * during the interaction as defined by the MAL specification.
     * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation
     * exception.
     */
    public void monitorValueRegister(org.ccsds.moims.mo.mal.structures.Subscription subscription,
            org.ccsds.moims.mo.mc.aggregation.consumer.AggregationAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException {
        consumer.register(org.ccsds.moims.mo.mc.aggregation.AggregationServiceInfo.MONITORVALUE_OP, subscription, adapter);
    }

    /**
     * Asynchronous version of method monitorValueRegister.
     * 
     * @param subscription subscription the subscription to register for.
     * @param adapter adapter Listener in charge of receiving the messages from
     * the service provider.
     * @return the MAL message sent to initiate the interaction.
     * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem
     * during the interaction as defined by the MAL specification.
     * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation
     * exception.
     */
    public org.ccsds.moims.mo.mal.transport.MALMessage asyncMonitorValueRegister(org.ccsds.moims.mo.mal.structures.Subscription subscription,
            org.ccsds.moims.mo.mc.aggregation.consumer.AggregationAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException {
        return consumer.asyncRegister(org.ccsds.moims.mo.mc.aggregation.AggregationServiceInfo.MONITORVALUE_OP, subscription, adapter);
    }

    /**
     * Deregister method for the monitorValue PubSub interaction.
     * 
     * @param identifierList identifierList the subscription identifiers to deregister.
     * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem
     * during the interaction as defined by the MAL specification.
     * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation
     * exception.
     */
    public void monitorValueDeregister(org.ccsds.moims.mo.mal.structures.IdentifierList identifierList) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException {
        consumer.deregister(org.ccsds.moims.mo.mc.aggregation.AggregationServiceInfo.MONITORVALUE_OP, identifierList);
    }

    /**
     * Asynchronous version of method monitorValueDeregister.
     * 
     * @param identifierList identifierList the subscription identifiers to deregister.
     * @param adapter adapter Listener in charge of receiving the messages from
     * the service provider.
     * @return the MAL message sent to initiate the interaction.
     * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem
     * during the interaction as defined by the MAL specification.
     * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation
     * exception.
     */
    public org.ccsds.moims.mo.mal.transport.MALMessage asyncMonitorValueDeregister(org.ccsds.moims.mo.mal.structures.IdentifierList identifierList,
            org.ccsds.moims.mo.mc.aggregation.consumer.AggregationAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException {
        return consumer.asyncDeregister(org.ccsds.moims.mo.mc.aggregation.AggregationServiceInfo.MONITORVALUE_OP, identifierList, adapter);
    }

    /**
     * The getValue operation returns the latest received value for a requested
     * aggregation.
     * 
     * @param domain .
     * @param keys .
     * @return The return value of the interaction.
     * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem
     * during the interaction as defined by the MAL specification.
     * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation
     * exception.
     */
    public org.ccsds.moims.mo.mc.structures.AggregationValueList getValue(org.ccsds.moims.mo.mal.structures.IdentifierList domain,
            org.ccsds.moims.mo.mal.structures.IdentifierList keys) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException {
        org.ccsds.moims.mo.mal.transport.MALMessageBody body = consumer.request(org.ccsds.moims.mo.mc.aggregation.AggregationServiceInfo.GETVALUE_OP, domain, keys);
        Object body0 = (Object) body.getBodyElement(0, new org.ccsds.moims.mo.mc.structures.AggregationValueList());
        return (org.ccsds.moims.mo.mc.structures.AggregationValueList) body0;
    }

    /**
     * Asynchronous version of method getValue.
     * 
     * @param domain .
     * @param keys .
     * @param adapter adapter Listener in charge of receiving the messages from
     * the service provider.
     * @return the MAL message sent to initiate the interaction.
     * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem
     * during the interaction as defined by the MAL specification.
     * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation
     * exception.
     */
    public org.ccsds.moims.mo.mal.transport.MALMessage asyncGetValue(org.ccsds.moims.mo.mal.structures.IdentifierList domain,
            org.ccsds.moims.mo.mal.structures.IdentifierList keys,
            org.ccsds.moims.mo.mc.aggregation.consumer.AggregationAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException {
        return consumer.asyncRequest(org.ccsds.moims.mo.mc.aggregation.AggregationServiceInfo.GETVALUE_OP, adapter, domain, keys);
    }

    /**
     * Continues a previously started interaction.
     * 
     * @param lastInteractionStage lastInteractionStage The last stage of the
     * interaction to continue.
     * @param initiationTimestamp initiationTimestamp Timestamp of the interaction
     * initiation message.
     * @param transactionId transactionId Transaction identifier of the interaction
     * to continue.
     * @param adapter adapter Listener in charge of receiving the messages from
     * the service provider.
     * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem
     * during the interaction as defined by the MAL specification.
     * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation
     * exception.
     */
    public void continueGetValue(org.ccsds.moims.mo.mal.structures.UOctet lastInteractionStage,
            org.ccsds.moims.mo.mal.structures.Time initiationTimestamp,
            Long transactionId,
            org.ccsds.moims.mo.mc.aggregation.consumer.AggregationAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException {
        consumer.continueInteraction(org.ccsds.moims.mo.mc.aggregation.AggregationServiceInfo.GETVALUE_OP, lastInteractionStage, initiationTimestamp, transactionId, adapter);
    }

    /**
     * The getReportingConfiguration operation allows a consumer to retrieve the
     * current configuration for the generation of reports for an aggregation.
     * 
     * @param domain .
     * @param keys .
     * @return The return value of the interaction.
     * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem
     * during the interaction as defined by the MAL specification.
     * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation
     * exception.
     */
    public org.ccsds.moims.mo.mc.structures.ReportConfigurationList getReportingConfiguration(org.ccsds.moims.mo.mal.structures.IdentifierList domain,
            org.ccsds.moims.mo.mal.structures.IdentifierList keys) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException {
        org.ccsds.moims.mo.mal.transport.MALMessageBody body = consumer.request(org.ccsds.moims.mo.mc.aggregation.AggregationServiceInfo.GETREPORTINGCONFIGURATION_OP, domain, keys);
        Object body0 = (Object) body.getBodyElement(0, new org.ccsds.moims.mo.mc.structures.ReportConfigurationList());
        return (org.ccsds.moims.mo.mc.structures.ReportConfigurationList) body0;
    }

    /**
     * Asynchronous version of method getReportingConfiguration.
     * 
     * @param domain .
     * @param keys .
     * @param adapter adapter Listener in charge of receiving the messages from
     * the service provider.
     * @return the MAL message sent to initiate the interaction.
     * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem
     * during the interaction as defined by the MAL specification.
     * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation
     * exception.
     */
    public org.ccsds.moims.mo.mal.transport.MALMessage asyncGetReportingConfiguration(org.ccsds.moims.mo.mal.structures.IdentifierList domain,
            org.ccsds.moims.mo.mal.structures.IdentifierList keys,
            org.ccsds.moims.mo.mc.aggregation.consumer.AggregationAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException {
        return consumer.asyncRequest(org.ccsds.moims.mo.mc.aggregation.AggregationServiceInfo.GETREPORTINGCONFIGURATION_OP, adapter, domain, keys);
    }

    /**
     * Continues a previously started interaction.
     * 
     * @param lastInteractionStage lastInteractionStage The last stage of the
     * interaction to continue.
     * @param initiationTimestamp initiationTimestamp Timestamp of the interaction
     * initiation message.
     * @param transactionId transactionId Transaction identifier of the interaction
     * to continue.
     * @param adapter adapter Listener in charge of receiving the messages from
     * the service provider.
     * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem
     * during the interaction as defined by the MAL specification.
     * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation
     * exception.
     */
    public void continueGetReportingConfiguration(org.ccsds.moims.mo.mal.structures.UOctet lastInteractionStage,
            org.ccsds.moims.mo.mal.structures.Time initiationTimestamp,
            Long transactionId,
            org.ccsds.moims.mo.mc.aggregation.consumer.AggregationAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException {
        consumer.continueInteraction(org.ccsds.moims.mo.mc.aggregation.AggregationServiceInfo.GETREPORTINGCONFIGURATION_OP, lastInteractionStage, initiationTimestamp, transactionId, adapter);
    }

    /**
     * The enableReporting operation allows a consumer to request the generation
     * of reports for specific aggregations.
     * 
     * @param domain .
     * @param keys .
     * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem
     * during the interaction as defined by the MAL specification.
     * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation
     * exception.
     */
    public void enableReporting(org.ccsds.moims.mo.mal.structures.IdentifierList domain,
            org.ccsds.moims.mo.mal.structures.IdentifierList keys) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException {
        consumer.submit(org.ccsds.moims.mo.mc.aggregation.AggregationServiceInfo.ENABLEREPORTING_OP, domain, keys);
    }

    /**
     * Asynchronous version of method enableReporting.
     * 
     * @param domain .
     * @param keys .
     * @param adapter adapter Listener in charge of receiving the messages from
     * the service provider.
     * @return the MAL message sent to initiate the interaction.
     * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem
     * during the interaction as defined by the MAL specification.
     * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation
     * exception.
     */
    public org.ccsds.moims.mo.mal.transport.MALMessage asyncEnableReporting(org.ccsds.moims.mo.mal.structures.IdentifierList domain,
            org.ccsds.moims.mo.mal.structures.IdentifierList keys,
            org.ccsds.moims.mo.mc.aggregation.consumer.AggregationAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException {
        return consumer.asyncSubmit(org.ccsds.moims.mo.mc.aggregation.AggregationServiceInfo.ENABLEREPORTING_OP, adapter, domain, keys);
    }

    /**
     * Continues a previously started interaction.
     * 
     * @param lastInteractionStage lastInteractionStage The last stage of the
     * interaction to continue.
     * @param initiationTimestamp initiationTimestamp Timestamp of the interaction
     * initiation message.
     * @param transactionId transactionId Transaction identifier of the interaction
     * to continue.
     * @param adapter adapter Listener in charge of receiving the messages from
     * the service provider.
     * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem
     * during the interaction as defined by the MAL specification.
     * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation
     * exception.
     */
    public void continueEnableReporting(org.ccsds.moims.mo.mal.structures.UOctet lastInteractionStage,
            org.ccsds.moims.mo.mal.structures.Time initiationTimestamp,
            Long transactionId,
            org.ccsds.moims.mo.mc.aggregation.consumer.AggregationAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException {
        consumer.continueInteraction(org.ccsds.moims.mo.mc.aggregation.AggregationServiceInfo.ENABLEREPORTING_OP, lastInteractionStage, initiationTimestamp, transactionId, adapter);
    }

    /**
     * The disableReporting operation allows a consumer to stop the generation
     * of reports for specific aggregations.
     * 
     * @param domain .
     * @param keys .
     * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem
     * during the interaction as defined by the MAL specification.
     * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation
     * exception.
     */
    public void disableReporting(org.ccsds.moims.mo.mal.structures.IdentifierList domain,
            org.ccsds.moims.mo.mal.structures.IdentifierList keys) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException {
        consumer.submit(org.ccsds.moims.mo.mc.aggregation.AggregationServiceInfo.DISABLEREPORTING_OP, domain, keys);
    }

    /**
     * Asynchronous version of method disableReporting.
     * 
     * @param domain .
     * @param keys .
     * @param adapter adapter Listener in charge of receiving the messages from
     * the service provider.
     * @return the MAL message sent to initiate the interaction.
     * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem
     * during the interaction as defined by the MAL specification.
     * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation
     * exception.
     */
    public org.ccsds.moims.mo.mal.transport.MALMessage asyncDisableReporting(org.ccsds.moims.mo.mal.structures.IdentifierList domain,
            org.ccsds.moims.mo.mal.structures.IdentifierList keys,
            org.ccsds.moims.mo.mc.aggregation.consumer.AggregationAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException {
        return consumer.asyncSubmit(org.ccsds.moims.mo.mc.aggregation.AggregationServiceInfo.DISABLEREPORTING_OP, adapter, domain, keys);
    }

    /**
     * Continues a previously started interaction.
     * 
     * @param lastInteractionStage lastInteractionStage The last stage of the
     * interaction to continue.
     * @param initiationTimestamp initiationTimestamp Timestamp of the interaction
     * initiation message.
     * @param transactionId transactionId Transaction identifier of the interaction
     * to continue.
     * @param adapter adapter Listener in charge of receiving the messages from
     * the service provider.
     * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem
     * during the interaction as defined by the MAL specification.
     * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation
     * exception.
     */
    public void continueDisableReporting(org.ccsds.moims.mo.mal.structures.UOctet lastInteractionStage,
            org.ccsds.moims.mo.mal.structures.Time initiationTimestamp,
            Long transactionId,
            org.ccsds.moims.mo.mc.aggregation.consumer.AggregationAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException {
        consumer.continueInteraction(org.ccsds.moims.mo.mc.aggregation.AggregationServiceInfo.DISABLEREPORTING_OP, lastInteractionStage, initiationTimestamp, transactionId, adapter);
    }

    /**
     * The setReportingPeriod operation allows a consumer to set the reporting
     * interval for specific aggregations.
     * 
     * @param domain .
     * @param keys .
     * @param reportInterval .
     * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem
     * during the interaction as defined by the MAL specification.
     * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation
     * exception.
     */
    public void setReportingPeriod(org.ccsds.moims.mo.mal.structures.IdentifierList domain,
            org.ccsds.moims.mo.mal.structures.IdentifierList keys,
            org.ccsds.moims.mo.mal.structures.Duration reportInterval) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException {
        consumer.submit(org.ccsds.moims.mo.mc.aggregation.AggregationServiceInfo.SETREPORTINGPERIOD_OP, domain, keys, reportInterval);
    }

    /**
     * Asynchronous version of method setReportingPeriod.
     * 
     * @param domain .
     * @param keys .
     * @param reportInterval .
     * @param adapter adapter Listener in charge of receiving the messages from
     * the service provider.
     * @return the MAL message sent to initiate the interaction.
     * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem
     * during the interaction as defined by the MAL specification.
     * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation
     * exception.
     */
    public org.ccsds.moims.mo.mal.transport.MALMessage asyncSetReportingPeriod(org.ccsds.moims.mo.mal.structures.IdentifierList domain,
            org.ccsds.moims.mo.mal.structures.IdentifierList keys,
            org.ccsds.moims.mo.mal.structures.Duration reportInterval,
            org.ccsds.moims.mo.mc.aggregation.consumer.AggregationAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException {
        return consumer.asyncSubmit(org.ccsds.moims.mo.mc.aggregation.AggregationServiceInfo.SETREPORTINGPERIOD_OP, adapter, domain, keys, reportInterval);
    }

    /**
     * Continues a previously started interaction.
     * 
     * @param lastInteractionStage lastInteractionStage The last stage of the
     * interaction to continue.
     * @param initiationTimestamp initiationTimestamp Timestamp of the interaction
     * initiation message.
     * @param transactionId transactionId Transaction identifier of the interaction
     * to continue.
     * @param adapter adapter Listener in charge of receiving the messages from
     * the service provider.
     * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem
     * during the interaction as defined by the MAL specification.
     * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation
     * exception.
     */
    public void continueSetReportingPeriod(org.ccsds.moims.mo.mal.structures.UOctet lastInteractionStage,
            org.ccsds.moims.mo.mal.structures.Time initiationTimestamp,
            Long transactionId,
            org.ccsds.moims.mo.mc.aggregation.consumer.AggregationAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException {
        consumer.continueInteraction(org.ccsds.moims.mo.mc.aggregation.AggregationServiceInfo.SETREPORTINGPERIOD_OP, lastInteractionStage, initiationTimestamp, transactionId, adapter);
    }

    /**
     * The listDefinition operation allows a consumer to retrieve the AggregationDefinition
     * objects for the supported aggregations of the provider.
     * 
     * @param domain .
     * @param keys .
     * @return The return value of the interaction.
     * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem
     * during the interaction as defined by the MAL specification.
     * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation
     * exception.
     */
    public org.ccsds.moims.mo.mc.structures.AggregationDefinitionList listDefinition(org.ccsds.moims.mo.mal.structures.IdentifierList domain,
            org.ccsds.moims.mo.mal.structures.IdentifierList keys) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException {
        org.ccsds.moims.mo.mal.transport.MALMessageBody body = consumer.request(org.ccsds.moims.mo.mc.aggregation.AggregationServiceInfo.LISTDEFINITION_OP, domain, keys);
        Object body0 = (Object) body.getBodyElement(0, new org.ccsds.moims.mo.mc.structures.AggregationDefinitionList());
        return (org.ccsds.moims.mo.mc.structures.AggregationDefinitionList) body0;
    }

    /**
     * Asynchronous version of method listDefinition.
     * 
     * @param domain .
     * @param keys .
     * @param adapter adapter Listener in charge of receiving the messages from
     * the service provider.
     * @return the MAL message sent to initiate the interaction.
     * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem
     * during the interaction as defined by the MAL specification.
     * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation
     * exception.
     */
    public org.ccsds.moims.mo.mal.transport.MALMessage asyncListDefinition(org.ccsds.moims.mo.mal.structures.IdentifierList domain,
            org.ccsds.moims.mo.mal.structures.IdentifierList keys,
            org.ccsds.moims.mo.mc.aggregation.consumer.AggregationAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException {
        return consumer.asyncRequest(org.ccsds.moims.mo.mc.aggregation.AggregationServiceInfo.LISTDEFINITION_OP, adapter, domain, keys);
    }

    /**
     * Continues a previously started interaction.
     * 
     * @param lastInteractionStage lastInteractionStage The last stage of the
     * interaction to continue.
     * @param initiationTimestamp initiationTimestamp Timestamp of the interaction
     * initiation message.
     * @param transactionId transactionId Transaction identifier of the interaction
     * to continue.
     * @param adapter adapter Listener in charge of receiving the messages from
     * the service provider.
     * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem
     * during the interaction as defined by the MAL specification.
     * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation
     * exception.
     */
    public void continueListDefinition(org.ccsds.moims.mo.mal.structures.UOctet lastInteractionStage,
            org.ccsds.moims.mo.mal.structures.Time initiationTimestamp,
            Long transactionId,
            org.ccsds.moims.mo.mc.aggregation.consumer.AggregationAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException {
        consumer.continueInteraction(org.ccsds.moims.mo.mc.aggregation.AggregationServiceInfo.LISTDEFINITION_OP, lastInteractionStage, initiationTimestamp, transactionId, adapter);
    }

    /**
     * The addAggregation operation allows a consumer to define one or more aggregations
     * that do not currently exist.
     * 
     * @param newObjects .
     * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem
     * during the interaction as defined by the MAL specification.
     * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation
     * exception.
     */
    public void addAggregation(org.ccsds.moims.mo.mc.structures.AggregationDefinitionList newObjects) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException {
        consumer.submit(org.ccsds.moims.mo.mc.aggregation.AggregationServiceInfo.ADDAGGREGATION_OP, newObjects);
    }

    /**
     * Asynchronous version of method addAggregation.
     * 
     * @param newObjects .
     * @param adapter adapter Listener in charge of receiving the messages from
     * the service provider.
     * @return the MAL message sent to initiate the interaction.
     * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem
     * during the interaction as defined by the MAL specification.
     * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation
     * exception.
     */
    public org.ccsds.moims.mo.mal.transport.MALMessage asyncAddAggregation(org.ccsds.moims.mo.mc.structures.AggregationDefinitionList newObjects,
            org.ccsds.moims.mo.mc.aggregation.consumer.AggregationAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException {
        return consumer.asyncSubmit(org.ccsds.moims.mo.mc.aggregation.AggregationServiceInfo.ADDAGGREGATION_OP, adapter, newObjects);
    }

    /**
     * Continues a previously started interaction.
     * 
     * @param lastInteractionStage lastInteractionStage The last stage of the
     * interaction to continue.
     * @param initiationTimestamp initiationTimestamp Timestamp of the interaction
     * initiation message.
     * @param transactionId transactionId Transaction identifier of the interaction
     * to continue.
     * @param adapter adapter Listener in charge of receiving the messages from
     * the service provider.
     * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem
     * during the interaction as defined by the MAL specification.
     * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation
     * exception.
     */
    public void continueAddAggregation(org.ccsds.moims.mo.mal.structures.UOctet lastInteractionStage,
            org.ccsds.moims.mo.mal.structures.Time initiationTimestamp,
            Long transactionId,
            org.ccsds.moims.mo.mc.aggregation.consumer.AggregationAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException {
        consumer.continueInteraction(org.ccsds.moims.mo.mc.aggregation.AggregationServiceInfo.ADDAGGREGATION_OP, lastInteractionStage, initiationTimestamp, transactionId, adapter);
    }

    /**
     * The removeAggregation operation allows a consumer to remove one or more
     * aggregations from the list of aggregations supported by the aggregation
     * provider.
     * 
     * @param domain .
     * @param keys .
     * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem
     * during the interaction as defined by the MAL specification.
     * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation
     * exception.
     */
    public void removeAggregation(org.ccsds.moims.mo.mal.structures.IdentifierList domain,
            org.ccsds.moims.mo.mal.structures.IdentifierList keys) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException {
        consumer.submit(org.ccsds.moims.mo.mc.aggregation.AggregationServiceInfo.REMOVEAGGREGATION_OP, domain, keys);
    }

    /**
     * Asynchronous version of method removeAggregation.
     * 
     * @param domain .
     * @param keys .
     * @param adapter adapter Listener in charge of receiving the messages from
     * the service provider.
     * @return the MAL message sent to initiate the interaction.
     * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem
     * during the interaction as defined by the MAL specification.
     * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation
     * exception.
     */
    public org.ccsds.moims.mo.mal.transport.MALMessage asyncRemoveAggregation(org.ccsds.moims.mo.mal.structures.IdentifierList domain,
            org.ccsds.moims.mo.mal.structures.IdentifierList keys,
            org.ccsds.moims.mo.mc.aggregation.consumer.AggregationAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException {
        return consumer.asyncSubmit(org.ccsds.moims.mo.mc.aggregation.AggregationServiceInfo.REMOVEAGGREGATION_OP, adapter, domain, keys);
    }

    /**
     * Continues a previously started interaction.
     * 
     * @param lastInteractionStage lastInteractionStage The last stage of the
     * interaction to continue.
     * @param initiationTimestamp initiationTimestamp Timestamp of the interaction
     * initiation message.
     * @param transactionId transactionId Transaction identifier of the interaction
     * to continue.
     * @param adapter adapter Listener in charge of receiving the messages from
     * the service provider.
     * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem
     * during the interaction as defined by the MAL specification.
     * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation
     * exception.
     */
    public void continueRemoveAggregation(org.ccsds.moims.mo.mal.structures.UOctet lastInteractionStage,
            org.ccsds.moims.mo.mal.structures.Time initiationTimestamp,
            Long transactionId,
            org.ccsds.moims.mo.mc.aggregation.consumer.AggregationAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException {
        consumer.continueInteraction(org.ccsds.moims.mo.mc.aggregation.AggregationServiceInfo.REMOVEAGGREGATION_OP, lastInteractionStage, initiationTimestamp, transactionId, adapter);
    }

}
