package org.ccsds.moims.mo.mc.alert.consumer;

/**
 * Consumer adapter for Alert service.
 */
public abstract class AlertAdapter extends org.ccsds.moims.mo.mal.consumer.MALInteractionAdapter {

    /**
     * Called by the MAL when a PubSub register acknowledgement is received from
     * a broker for the operation monitorAlert.
     * 
     * @param msgHeader msgHeader The header of the received message.
     * @param qosProperties qosProperties The QoS properties associated with the
     * message.
     */
    public void monitorAlertRegisterAckReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader,
            java.util.Map qosProperties) {
    }

    /**
     * Called by the MAL when a PubSub register acknowledgement error is received
     * from a broker for the operation monitorAlert.
     * 
     * @param msgHeader msgHeader The header of the received message.
     * @param error error The received error message.
     * @param qosProperties qosProperties The QoS properties associated with the
     * message.
     */
    public void monitorAlertRegisterErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader,
            org.ccsds.moims.mo.mal.MOErrorException error,
            java.util.Map qosProperties) {
    }

    /**
     * Called by the MAL when a PubSub deregister acknowledgement is received
     * from a broker for the operation monitorAlert.
     * 
     * @param msgHeader msgHeader The header of the received message.
     * @param qosProperties qosProperties The QoS properties associated with the
     * message.
     */
    public void monitorAlertDeregisterAckReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader,
            java.util.Map qosProperties) {
    }

    /**
     * Called by the MAL when a PubSub update is received from a broker for the
     * operation monitorAlert.
     * 
     * @param msgHeader msgHeader The header of the received message.
     * @param subscriptionId The subscriptionId of the subscription.
     * @param updateHeader The Update header.
     * @param timestamp .
     * @param arguments .
     * @param qosProperties qosProperties The QoS properties associated with the
     * message.
     */
    public void monitorAlertNotifyReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader,
            org.ccsds.moims.mo.mal.structures.Identifier subscriptionId,
            org.ccsds.moims.mo.mal.structures.UpdateHeader updateHeader,
            org.ccsds.moims.mo.mal.structures.Time timestamp,
            org.ccsds.moims.mo.mal.structures.NullableAttributeList arguments,
            java.util.Map qosProperties) {
    }

    /**
     * Called by the MAL when a PubSub update error is received from a broker
     * for the operation monitorAlert.
     * 
     * @param msgHeader msgHeader The header of the received message.
     * @param error error The received error message.
     * @param qosProperties qosProperties The QoS properties associated with the
     * message.
     */
    public void monitorAlertNotifyErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader,
            org.ccsds.moims.mo.mal.MOErrorException error,
            java.util.Map qosProperties) {
    }

    /**
     * Called by the MAL when a REQUEST response is received from a provider for
     * the operation getAlertConfiguration.
     * 
     * @param msgHeader msgHeader The header of the received message.
     * @param alertConfigs .
     * @param qosProperties qosProperties The QoS properties associated with the
     * message.
     */
    public void getAlertConfigurationResponseReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader,
            org.ccsds.moims.mo.mc.structures.AlertConfigurationList alertConfigs,
            java.util.Map qosProperties) {
    }

    /**
     * Called by the MAL when a REQUEST response error is received from a provider
     * for the operation getAlertConfiguration.
     * 
     * @param msgHeader msgHeader The header of the received message.
     * @param error error The received error message.
     * @param qosProperties qosProperties The QoS properties associated with the
     * message.
     */
    public void getAlertConfigurationErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader,
            org.ccsds.moims.mo.mal.MOErrorException error,
            java.util.Map qosProperties) {
    }

    /**
     * Called by the MAL when a SUBMIT acknowledgement is received from a provider
     * for the operation enableGeneration.
     * 
     * @param msgHeader msgHeader The header of the received message.
     * @param qosProperties qosProperties The QoS properties associated with the
     * message.
     */
    public void enableGenerationAckReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader,
            java.util.Map qosProperties) {
    }

    /**
     * Called by the MAL when a SUBMIT acknowledgement error is received from
     * a provider for the operation enableGeneration.
     * 
     * @param msgHeader msgHeader The header of the received message.
     * @param error error The received error message.
     * @param qosProperties qosProperties The QoS properties associated with the
     * message.
     */
    public void enableGenerationErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader,
            org.ccsds.moims.mo.mal.MOErrorException error,
            java.util.Map qosProperties) {
    }

    /**
     * Called by the MAL when a SUBMIT acknowledgement is received from a provider
     * for the operation disableGeneration.
     * 
     * @param msgHeader msgHeader The header of the received message.
     * @param qosProperties qosProperties The QoS properties associated with the
     * message.
     */
    public void disableGenerationAckReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader,
            java.util.Map qosProperties) {
    }

    /**
     * Called by the MAL when a SUBMIT acknowledgement error is received from
     * a provider for the operation disableGeneration.
     * 
     * @param msgHeader msgHeader The header of the received message.
     * @param error error The received error message.
     * @param qosProperties qosProperties The QoS properties associated with the
     * message.
     */
    public void disableGenerationErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader,
            org.ccsds.moims.mo.mal.MOErrorException error,
            java.util.Map qosProperties) {
    }

    /**
     * Called by the MAL when a SUBMIT acknowledgement is received from a provider.
     * 
     * @param msgHeader msgHeader The header of the received message.
     * @param qosProperties qosProperties The QoS properties associated with the
     * message.
     * @throws org.ccsds.moims.mo.mal.MALException if an error is detected processing
     * the message.
     */
    public final void submitAckReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader,
            java.util.Map qosProperties) throws org.ccsds.moims.mo.mal.MALException {
        switch (msgHeader.getOperation().getValue()) {
          case org.ccsds.moims.mo.mc.alert.AlertServiceInfo._ENABLEGENERATION_OP_NUMBER:
            enableGenerationAckReceived(msgHeader, qosProperties);
            break;
          case org.ccsds.moims.mo.mc.alert.AlertServiceInfo._DISABLEGENERATION_OP_NUMBER:
            disableGenerationAckReceived(msgHeader, qosProperties);
            break;
          default:
            throw new org.ccsds.moims.mo.mal.MALException("Consumer adapter was not expecting operation number " + msgHeader.getOperation().getValue());
        }
    }

    /**
     * Called by the MAL when a SUBMIT acknowledgement error is received from
     * a provider.
     * 
     * @param msgHeader msgHeader The header of the received message.
     * @param body body The body of the received message.
     * @param qosProperties qosProperties The QoS properties associated with the
     * message.
     * @throws org.ccsds.moims.mo.mal.MALException if an error is detected processing
     * the message.
     */
    public final void submitErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader,
            org.ccsds.moims.mo.mal.transport.MALErrorBody body,
            java.util.Map qosProperties) throws org.ccsds.moims.mo.mal.MALException {
        switch (msgHeader.getOperation().getValue()) {
          case org.ccsds.moims.mo.mc.alert.AlertServiceInfo._ENABLEGENERATION_OP_NUMBER:
            enableGenerationErrorReceived(msgHeader, body.getError(), qosProperties);
            break;
          case org.ccsds.moims.mo.mc.alert.AlertServiceInfo._DISABLEGENERATION_OP_NUMBER:
            disableGenerationErrorReceived(msgHeader, body.getError(), qosProperties);
            break;
          default:
            throw new org.ccsds.moims.mo.mal.MALException("Consumer adapter was not expecting operation number " + msgHeader.getOperation().getValue());
        }
    }

    /**
     * Called by the MAL when a REQUEST response is received from a provider.
     * 
     * @param msgHeader msgHeader The header of the received message.
     * @param body body The body of the received message.
     * @param qosProperties qosProperties The QoS properties associated with the
     * message.
     * @throws org.ccsds.moims.mo.mal.MALException if an error is detected processing
     * the message.
     */
    public final void requestResponseReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader,
            org.ccsds.moims.mo.mal.transport.MALMessageBody body,
            java.util.Map qosProperties) throws org.ccsds.moims.mo.mal.MALException {
        switch (msgHeader.getOperation().getValue()) {
          case org.ccsds.moims.mo.mc.alert.AlertServiceInfo._GETALERTCONFIGURATION_OP_NUMBER:
            getAlertConfigurationResponseReceived(msgHeader,
                (org.ccsds.moims.mo.mc.structures.AlertConfigurationList) body.getBodyElement(0, new org.ccsds.moims.mo.mc.structures.AlertConfigurationList()), qosProperties);
            break;
          default:
            throw new org.ccsds.moims.mo.mal.MALException("Consumer adapter was not expecting operation number " + msgHeader.getOperation().getValue());
        }
    }

    /**
     * Called by the MAL when a REQUEST response error is received from a provider.
     * 
     * @param msgHeader msgHeader The header of the received message.
     * @param body body The body of the received message.
     * @param qosProperties qosProperties The QoS properties associated with the
     * message.
     * @throws org.ccsds.moims.mo.mal.MALException if an error is detected processing
     * the message.
     */
    public final void requestErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader,
            org.ccsds.moims.mo.mal.transport.MALErrorBody body,
            java.util.Map qosProperties) throws org.ccsds.moims.mo.mal.MALException {
        switch (msgHeader.getOperation().getValue()) {
          case org.ccsds.moims.mo.mc.alert.AlertServiceInfo._GETALERTCONFIGURATION_OP_NUMBER:
            getAlertConfigurationErrorReceived(msgHeader, body.getError(), qosProperties);
            break;
          default:
            throw new org.ccsds.moims.mo.mal.MALException("Consumer adapter was not expecting operation number " + msgHeader.getOperation().getValue());
        }
    }

    /**
     * Called by the MAL when a PubSub register acknowledgement is received from
     * a broker.
     * 
     * @param msgHeader msgHeader The header of the received message.
     * @param qosProperties qosProperties The QoS properties associated with the
     * message.
     * @throws org.ccsds.moims.mo.mal.MALException if an error is detected processing
     * the message.
     */
    public final void registerAckReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader,
            java.util.Map qosProperties) throws org.ccsds.moims.mo.mal.MALException {
        switch (msgHeader.getOperation().getValue()) {
          case org.ccsds.moims.mo.mc.alert.AlertServiceInfo._MONITORALERT_OP_NUMBER:
            monitorAlertRegisterAckReceived(msgHeader, qosProperties);
            break;
          default:
            throw new org.ccsds.moims.mo.mal.MALException("Consumer adapter was not expecting operation number " + msgHeader.getOperation().getValue());
        }
    }

    /**
     * Called by the MAL when a PubSub register acknowledgement error is received
     * from a broker.
     * 
     * @param msgHeader msgHeader The header of the received message.
     * @param body body The body of the received message.
     * @param qosProperties qosProperties The QoS properties associated with the
     * message.
     * @throws org.ccsds.moims.mo.mal.MALException if an error is detected processing
     * the message.
     */
    public final void registerErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader,
            org.ccsds.moims.mo.mal.transport.MALErrorBody body,
            java.util.Map qosProperties) throws org.ccsds.moims.mo.mal.MALException {
        switch (msgHeader.getOperation().getValue()) {
          case org.ccsds.moims.mo.mc.alert.AlertServiceInfo._MONITORALERT_OP_NUMBER:
            monitorAlertRegisterErrorReceived(msgHeader, body.getError(), qosProperties);
            break;
          default:
            throw new org.ccsds.moims.mo.mal.MALException("Consumer adapter was not expecting operation number " + msgHeader.getOperation().getValue());
        }
    }

    /**
     * Called by the MAL when a PubSub update is received from a broker.
     * 
     * @param msgHeader msgHeader The header of the received message.
     * @param body body The body of the received message.
     * @param qosProperties qosProperties The QoS properties associated with the
     * message.
     * @throws org.ccsds.moims.mo.mal.MALException if an error is detected processing
     * the message.
     */
    public final void notifyReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader,
            org.ccsds.moims.mo.mal.transport.MALNotifyBody body,
            java.util.Map qosProperties) throws org.ccsds.moims.mo.mal.MALException {
        if ((org.ccsds.moims.mo.mc.MCHelper.MC_AREA_NUMBER.equals(msgHeader.getServiceArea())) && (org.ccsds.moims.mo.mc.alert.AlertServiceInfo.ALERT_SERVICE_NUMBER.equals(msgHeader.getService()))) {
          switch (msgHeader.getOperation().getValue()) {
            case org.ccsds.moims.mo.mc.alert.AlertServiceInfo._MONITORALERT_OP_NUMBER:
              monitorAlertNotifyReceived(msgHeader,
                (org.ccsds.moims.mo.mal.structures.Identifier) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Identifier()),
                (org.ccsds.moims.mo.mal.structures.UpdateHeader) body.getBodyElement(1, new org.ccsds.moims.mo.mal.structures.UpdateHeader()),
                (org.ccsds.moims.mo.mal.structures.Time) body.getBodyElement(2, new org.ccsds.moims.mo.mal.structures.Time()),
                (org.ccsds.moims.mo.mal.structures.NullableAttributeList) body.getBodyElement(3, new org.ccsds.moims.mo.mal.structures.NullableAttributeList()), qosProperties);
              break;
            default:
              throw new org.ccsds.moims.mo.mal.MALException("Consumer adapter was not expecting operation number " + msgHeader.getOperation().getValue());
          }
        }
        else {
          notifyReceivedFromOtherService(msgHeader, body, qosProperties);
        }
    }

    /**
     * Called by the MAL when a PubSub update error is received from a broker.
     * 
     * @param msgHeader msgHeader The header of the received message.
     * @param body body The body of the received message.
     * @param qosProperties qosProperties The QoS properties associated with the
     * message.
     * @throws org.ccsds.moims.mo.mal.MALException if an error is detected processing
     * the message.
     */
    public final void notifyErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader,
            org.ccsds.moims.mo.mal.transport.MALErrorBody body,
            java.util.Map qosProperties) throws org.ccsds.moims.mo.mal.MALException {
        switch (msgHeader.getOperation().getValue()) {
          case org.ccsds.moims.mo.mc.alert.AlertServiceInfo._MONITORALERT_OP_NUMBER:
            monitorAlertNotifyErrorReceived(msgHeader, body.getError(), qosProperties);
            break;
          default:
            throw new org.ccsds.moims.mo.mal.MALException("Consumer adapter was not expecting operation number " + msgHeader.getOperation().getValue());
        }
    }

    /**
     * Called by the MAL when a PubSub deregister acknowledgement is received
     * from a broker.
     * 
     * @param msgHeader msgHeader The header of the received message.
     * @param qosProperties qosProperties The QoS properties associated with the
     * message.
     * @throws org.ccsds.moims.mo.mal.MALException if an error is detected processing
     * the message.
     */
    public final void deregisterAckReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader,
            java.util.Map qosProperties) throws org.ccsds.moims.mo.mal.MALException {
        switch (msgHeader.getOperation().getValue()) {
          case org.ccsds.moims.mo.mc.alert.AlertServiceInfo._MONITORALERT_OP_NUMBER:
            monitorAlertDeregisterAckReceived(msgHeader, qosProperties);
            break;
          default:
            throw new org.ccsds.moims.mo.mal.MALException("Consumer adapter was not expecting operation number " + msgHeader.getOperation().getValue());
        }
    }

    /**
     * Called by the MAL when a PubSub update from another service is received
     * from a broker.
     * 
     * @param msgHeader msgHeader The header of the received message.
     * @param body body The body of the received message.
     * @param qosProperties qosProperties The QoS properties associated with the
     * message.
     * @throws org.ccsds.moims.mo.mal.MALException if an error is detected processing
     * the message.
     */
    public void notifyReceivedFromOtherService(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader,
            org.ccsds.moims.mo.mal.transport.MALNotifyBody body,
            java.util.Map qosProperties) throws org.ccsds.moims.mo.mal.MALException {
    }

}
