package org.ccsds.moims.mo.mc.packet.consumer;

/**
 * Consumer adapter for Packet service.
 */
public abstract class PacketAdapter extends org.ccsds.moims.mo.mal.consumer.MALInteractionAdapter {

    /**
     * Called by the MAL when a PubSub register acknowledgement is received from
     * a broker for the operation deliverPacket.
     * 
     * @param msgHeader msgHeader The header of the received message.
     * @param qosProperties qosProperties The QoS properties associated with the
     * message.
     */
    public void deliverPacketRegisterAckReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader,
            java.util.Map qosProperties) {
    }

    /**
     * Called by the MAL when a PubSub register acknowledgement error is received
     * from a broker for the operation deliverPacket.
     * 
     * @param msgHeader msgHeader The header of the received message.
     * @param error error The received error message.
     * @param qosProperties qosProperties The QoS properties associated with the
     * message.
     */
    public void deliverPacketRegisterErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader,
            org.ccsds.moims.mo.mal.MOErrorException error,
            java.util.Map qosProperties) {
    }

    /**
     * Called by the MAL when a PubSub deregister acknowledgement is received
     * from a broker for the operation deliverPacket.
     * 
     * @param msgHeader msgHeader The header of the received message.
     * @param qosProperties qosProperties The QoS properties associated with the
     * message.
     */
    public void deliverPacketDeregisterAckReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader,
            java.util.Map qosProperties) {
    }

    /**
     * Called by the MAL when a PubSub update is received from a broker for the
     * operation deliverPacket.
     * 
     * @param msgHeader msgHeader The header of the received message.
     * @param subscriptionId The subscriptionId of the subscription.
     * @param updateHeader The Update header.
     * @param timestamp .
     * @param spacePacket .
     * @param qosProperties qosProperties The QoS properties associated with the
     * message.
     */
    public void deliverPacketNotifyReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader,
            org.ccsds.moims.mo.mal.structures.Identifier subscriptionId,
            org.ccsds.moims.mo.mal.structures.UpdateHeader updateHeader,
            org.ccsds.moims.mo.mal.structures.Time timestamp,
            org.ccsds.moims.mo.mal.structures.Blob spacePacket,
            java.util.Map qosProperties) {
    }

    /**
     * Called by the MAL when a PubSub update error is received from a broker
     * for the operation deliverPacket.
     * 
     * @param msgHeader msgHeader The header of the received message.
     * @param error error The received error message.
     * @param qosProperties qosProperties The QoS properties associated with the
     * message.
     */
    public void deliverPacketNotifyErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader,
            org.ccsds.moims.mo.mal.MOErrorException error,
            java.util.Map qosProperties) {
    }

    /**
     * Called by the MAL when a PubSub register acknowledgement is received from
     * a broker.
     * 
     * @param msgHeader msgHeader The header of the received message.
     * @param qosProperties qosProperties The QoS properties associated with the
     * message.
     * @throws org.ccsds.moims.mo.mal.MALException if an error is detected processing
     * the message.
     */
    public final void registerAckReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader,
            java.util.Map qosProperties) throws org.ccsds.moims.mo.mal.MALException {
        switch (msgHeader.getOperation().getValue()) {
          case org.ccsds.moims.mo.mc.packet.PacketServiceInfo._DELIVERPACKET_OP_NUMBER:
            deliverPacketRegisterAckReceived(msgHeader, qosProperties);
            break;
          default:
            throw new org.ccsds.moims.mo.mal.MALException("Consumer adapter was not expecting operation number " + msgHeader.getOperation().getValue());
        }
    }

    /**
     * Called by the MAL when a PubSub register acknowledgement error is received
     * from a broker.
     * 
     * @param msgHeader msgHeader The header of the received message.
     * @param body body The body of the received message.
     * @param qosProperties qosProperties The QoS properties associated with the
     * message.
     * @throws org.ccsds.moims.mo.mal.MALException if an error is detected processing
     * the message.
     */
    public final void registerErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader,
            org.ccsds.moims.mo.mal.transport.MALErrorBody body,
            java.util.Map qosProperties) throws org.ccsds.moims.mo.mal.MALException {
        switch (msgHeader.getOperation().getValue()) {
          case org.ccsds.moims.mo.mc.packet.PacketServiceInfo._DELIVERPACKET_OP_NUMBER:
            deliverPacketRegisterErrorReceived(msgHeader, body.getError(), qosProperties);
            break;
          default:
            throw new org.ccsds.moims.mo.mal.MALException("Consumer adapter was not expecting operation number " + msgHeader.getOperation().getValue());
        }
    }

    /**
     * Called by the MAL when a PubSub update is received from a broker.
     * 
     * @param msgHeader msgHeader The header of the received message.
     * @param body body The body of the received message.
     * @param qosProperties qosProperties The QoS properties associated with the
     * message.
     * @throws org.ccsds.moims.mo.mal.MALException if an error is detected processing
     * the message.
     */
    public final void notifyReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader,
            org.ccsds.moims.mo.mal.transport.MALNotifyBody body,
            java.util.Map qosProperties) throws org.ccsds.moims.mo.mal.MALException {
        if ((org.ccsds.moims.mo.mc.MCHelper.MC_AREA_NUMBER.equals(msgHeader.getServiceArea())) && (org.ccsds.moims.mo.mc.packet.PacketServiceInfo.PACKET_SERVICE_NUMBER.equals(msgHeader.getService()))) {
          switch (msgHeader.getOperation().getValue()) {
            case org.ccsds.moims.mo.mc.packet.PacketServiceInfo._DELIVERPACKET_OP_NUMBER:
              deliverPacketNotifyReceived(msgHeader,
                (org.ccsds.moims.mo.mal.structures.Identifier) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Identifier()),
                (org.ccsds.moims.mo.mal.structures.UpdateHeader) body.getBodyElement(1, new org.ccsds.moims.mo.mal.structures.UpdateHeader()),
                (org.ccsds.moims.mo.mal.structures.Time) body.getBodyElement(2, new org.ccsds.moims.mo.mal.structures.Time()),
                (org.ccsds.moims.mo.mal.structures.Blob) body.getBodyElement(3, new org.ccsds.moims.mo.mal.structures.Blob()), qosProperties);
              break;
            default:
              throw new org.ccsds.moims.mo.mal.MALException("Consumer adapter was not expecting operation number " + msgHeader.getOperation().getValue());
          }
        }
        else {
          notifyReceivedFromOtherService(msgHeader, body, qosProperties);
        }
    }

    /**
     * Called by the MAL when a PubSub update error is received from a broker.
     * 
     * @param msgHeader msgHeader The header of the received message.
     * @param body body The body of the received message.
     * @param qosProperties qosProperties The QoS properties associated with the
     * message.
     * @throws org.ccsds.moims.mo.mal.MALException if an error is detected processing
     * the message.
     */
    public final void notifyErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader,
            org.ccsds.moims.mo.mal.transport.MALErrorBody body,
            java.util.Map qosProperties) throws org.ccsds.moims.mo.mal.MALException {
        switch (msgHeader.getOperation().getValue()) {
          case org.ccsds.moims.mo.mc.packet.PacketServiceInfo._DELIVERPACKET_OP_NUMBER:
            deliverPacketNotifyErrorReceived(msgHeader, body.getError(), qosProperties);
            break;
          default:
            throw new org.ccsds.moims.mo.mal.MALException("Consumer adapter was not expecting operation number " + msgHeader.getOperation().getValue());
        }
    }

    /**
     * Called by the MAL when a PubSub deregister acknowledgement is received
     * from a broker.
     * 
     * @param msgHeader msgHeader The header of the received message.
     * @param qosProperties qosProperties The QoS properties associated with the
     * message.
     * @throws org.ccsds.moims.mo.mal.MALException if an error is detected processing
     * the message.
     */
    public final void deregisterAckReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader,
            java.util.Map qosProperties) throws org.ccsds.moims.mo.mal.MALException {
        switch (msgHeader.getOperation().getValue()) {
          case org.ccsds.moims.mo.mc.packet.PacketServiceInfo._DELIVERPACKET_OP_NUMBER:
            deliverPacketDeregisterAckReceived(msgHeader, qosProperties);
            break;
          default:
            throw new org.ccsds.moims.mo.mal.MALException("Consumer adapter was not expecting operation number " + msgHeader.getOperation().getValue());
        }
    }

    /**
     * Called by the MAL when a PubSub update from another service is received
     * from a broker.
     * 
     * @param msgHeader msgHeader The header of the received message.
     * @param body body The body of the received message.
     * @param qosProperties qosProperties The QoS properties associated with the
     * message.
     * @throws org.ccsds.moims.mo.mal.MALException if an error is detected processing
     * the message.
     */
    public void notifyReceivedFromOtherService(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader,
            org.ccsds.moims.mo.mal.transport.MALNotifyBody body,
            java.util.Map qosProperties) throws org.ccsds.moims.mo.mal.MALException {
    }

}
