package org.ccsds.moims.mo.mc.packet.consumer;

/**
 * Consumer stub for Packet service.
 */
public class PacketStub {

    private final org.ccsds.moims.mo.mal.consumer.MALConsumer consumer;

    /**
     * Wraps a MALconsumer connection with service specific methods that map from
     * the high level service API to the generic MAL API.
     * 
     * @param consumer consumer The MALConsumer to use in this stub.
     */
    public PacketStub(org.ccsds.moims.mo.mal.consumer.MALConsumer consumer) {
        this.consumer = consumer;
    }

    /**
     * Returns the internal MAL consumer object used for sending of messages from
     * this interface.
     * 
     * @return The MAL consumer object.
     */
    public org.ccsds.moims.mo.mal.consumer.MALConsumer getConsumer() {
        return consumer;
    }

    /**
     * Register method for the deliverPacket PubSub interaction.
     * 
     * @param subscription subscription the subscription to register for.
     * @param adapter adapter Listener in charge of receiving the messages from
     * the service provider.
     * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem
     * during the interaction as defined by the MAL specification.
     * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation
     * exception.
     */
    public void deliverPacketRegister(org.ccsds.moims.mo.mal.structures.Subscription subscription,
            org.ccsds.moims.mo.mc.packet.consumer.PacketAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException {
        consumer.register(org.ccsds.moims.mo.mc.packet.PacketServiceInfo.DELIVERPACKET_OP, subscription, adapter);
    }

    /**
     * Asynchronous version of method deliverPacketRegister.
     * 
     * @param subscription subscription the subscription to register for.
     * @param adapter adapter Listener in charge of receiving the messages from
     * the service provider.
     * @return the MAL message sent to initiate the interaction.
     * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem
     * during the interaction as defined by the MAL specification.
     * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation
     * exception.
     */
    public org.ccsds.moims.mo.mal.transport.MALMessage asyncDeliverPacketRegister(org.ccsds.moims.mo.mal.structures.Subscription subscription,
            org.ccsds.moims.mo.mc.packet.consumer.PacketAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException {
        return consumer.asyncRegister(org.ccsds.moims.mo.mc.packet.PacketServiceInfo.DELIVERPACKET_OP, subscription, adapter);
    }

    /**
     * Deregister method for the deliverPacket PubSub interaction.
     * 
     * @param identifierList identifierList the subscription identifiers to deregister.
     * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem
     * during the interaction as defined by the MAL specification.
     * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation
     * exception.
     */
    public void deliverPacketDeregister(org.ccsds.moims.mo.mal.structures.IdentifierList identifierList) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException {
        consumer.deregister(org.ccsds.moims.mo.mc.packet.PacketServiceInfo.DELIVERPACKET_OP, identifierList);
    }

    /**
     * Asynchronous version of method deliverPacketDeregister.
     * 
     * @param identifierList identifierList the subscription identifiers to deregister.
     * @param adapter adapter Listener in charge of receiving the messages from
     * the service provider.
     * @return the MAL message sent to initiate the interaction.
     * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem
     * during the interaction as defined by the MAL specification.
     * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation
     * exception.
     */
    public org.ccsds.moims.mo.mal.transport.MALMessage asyncDeliverPacketDeregister(org.ccsds.moims.mo.mal.structures.IdentifierList identifierList,
            org.ccsds.moims.mo.mc.packet.consumer.PacketAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException {
        return consumer.asyncDeregister(org.ccsds.moims.mo.mc.packet.PacketServiceInfo.DELIVERPACKET_OP, identifierList, adapter);
    }

}
