package org.ccsds.moims.mo.mc.parameter.consumer;

/**
 * Consumer stub for Parameter service.
 */
public class ParameterStub {

    private final org.ccsds.moims.mo.mal.consumer.MALConsumer consumer;

    /**
     * Wraps a MALconsumer connection with service specific methods that map from
     * the high level service API to the generic MAL API.
     * 
     * @param consumer consumer The MALConsumer to use in this stub.
     */
    public ParameterStub(org.ccsds.moims.mo.mal.consumer.MALConsumer consumer) {
        this.consumer = consumer;
    }

    /**
     * Returns the internal MAL consumer object used for sending of messages from
     * this interface.
     * 
     * @return The MAL consumer object.
     */
    public org.ccsds.moims.mo.mal.consumer.MALConsumer getConsumer() {
        return consumer;
    }

    /**
     * Register method for the monitorValue PubSub interaction.
     * 
     * @param subscription subscription the subscription to register for.
     * @param adapter adapter Listener in charge of receiving the messages from
     * the service provider.
     * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem
     * during the interaction as defined by the MAL specification.
     * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation
     * exception.
     */
    public void monitorValueRegister(org.ccsds.moims.mo.mal.structures.Subscription subscription,
            org.ccsds.moims.mo.mc.parameter.consumer.ParameterAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException {
        consumer.register(org.ccsds.moims.mo.mc.parameter.ParameterServiceInfo.MONITORVALUE_OP, subscription, adapter);
    }

    /**
     * Asynchronous version of method monitorValueRegister.
     * 
     * @param subscription subscription the subscription to register for.
     * @param adapter adapter Listener in charge of receiving the messages from
     * the service provider.
     * @return the MAL message sent to initiate the interaction.
     * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem
     * during the interaction as defined by the MAL specification.
     * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation
     * exception.
     */
    public org.ccsds.moims.mo.mal.transport.MALMessage asyncMonitorValueRegister(org.ccsds.moims.mo.mal.structures.Subscription subscription,
            org.ccsds.moims.mo.mc.parameter.consumer.ParameterAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException {
        return consumer.asyncRegister(org.ccsds.moims.mo.mc.parameter.ParameterServiceInfo.MONITORVALUE_OP, subscription, adapter);
    }

    /**
     * Deregister method for the monitorValue PubSub interaction.
     * 
     * @param identifierList identifierList the subscription identifiers to deregister.
     * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem
     * during the interaction as defined by the MAL specification.
     * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation
     * exception.
     */
    public void monitorValueDeregister(org.ccsds.moims.mo.mal.structures.IdentifierList identifierList) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException {
        consumer.deregister(org.ccsds.moims.mo.mc.parameter.ParameterServiceInfo.MONITORVALUE_OP, identifierList);
    }

    /**
     * Asynchronous version of method monitorValueDeregister.
     * 
     * @param identifierList identifierList the subscription identifiers to deregister.
     * @param adapter adapter Listener in charge of receiving the messages from
     * the service provider.
     * @return the MAL message sent to initiate the interaction.
     * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem
     * during the interaction as defined by the MAL specification.
     * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation
     * exception.
     */
    public org.ccsds.moims.mo.mal.transport.MALMessage asyncMonitorValueDeregister(org.ccsds.moims.mo.mal.structures.IdentifierList identifierList,
            org.ccsds.moims.mo.mc.parameter.consumer.ParameterAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException {
        return consumer.asyncDeregister(org.ccsds.moims.mo.mc.parameter.ParameterServiceInfo.MONITORVALUE_OP, identifierList, adapter);
    }

    /**
     * The getValue operation returns the latest received value for a requested
     * parameter.
     * 
     * @param domain .
     * @param keys .
     * @return The return value of the interaction.
     * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem
     * during the interaction as defined by the MAL specification.
     * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation
     * exception.
     */
    public org.ccsds.moims.mo.mc.structures.ParameterValueList getValue(org.ccsds.moims.mo.mal.structures.IdentifierList domain,
            org.ccsds.moims.mo.mal.structures.IdentifierList keys) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException {
        org.ccsds.moims.mo.mal.transport.MALMessageBody body = consumer.request(org.ccsds.moims.mo.mc.parameter.ParameterServiceInfo.GETVALUE_OP, domain, keys);
        Object body0 = (Object) body.getBodyElement(0, new org.ccsds.moims.mo.mc.structures.ParameterValueList());
        return (org.ccsds.moims.mo.mc.structures.ParameterValueList) body0;
    }

    /**
     * Asynchronous version of method getValue.
     * 
     * @param domain .
     * @param keys .
     * @param adapter adapter Listener in charge of receiving the messages from
     * the service provider.
     * @return the MAL message sent to initiate the interaction.
     * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem
     * during the interaction as defined by the MAL specification.
     * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation
     * exception.
     */
    public org.ccsds.moims.mo.mal.transport.MALMessage asyncGetValue(org.ccsds.moims.mo.mal.structures.IdentifierList domain,
            org.ccsds.moims.mo.mal.structures.IdentifierList keys,
            org.ccsds.moims.mo.mc.parameter.consumer.ParameterAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException {
        return consumer.asyncRequest(org.ccsds.moims.mo.mc.parameter.ParameterServiceInfo.GETVALUE_OP, adapter, domain, keys);
    }

    /**
     * Continues a previously started interaction.
     * 
     * @param lastInteractionStage lastInteractionStage The last stage of the
     * interaction to continue.
     * @param initiationTimestamp initiationTimestamp Timestamp of the interaction
     * initiation message.
     * @param transactionId transactionId Transaction identifier of the interaction
     * to continue.
     * @param adapter adapter Listener in charge of receiving the messages from
     * the service provider.
     * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem
     * during the interaction as defined by the MAL specification.
     * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation
     * exception.
     */
    public void continueGetValue(org.ccsds.moims.mo.mal.structures.UOctet lastInteractionStage,
            org.ccsds.moims.mo.mal.structures.Time initiationTimestamp,
            Long transactionId,
            org.ccsds.moims.mo.mc.parameter.consumer.ParameterAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException {
        consumer.continueInteraction(org.ccsds.moims.mo.mc.parameter.ParameterServiceInfo.GETVALUE_OP, lastInteractionStage, initiationTimestamp, transactionId, adapter);
    }

    /**
     * The setValue operation allows a consumer to set the raw value for one or
     * more parameters.
     * 
     * @param domain .
     * @param keys .
     * @param newRawValues .
     * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem
     * during the interaction as defined by the MAL specification.
     * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation
     * exception.
     */
    public void setValue(org.ccsds.moims.mo.mal.structures.IdentifierList domain,
            org.ccsds.moims.mo.mal.structures.IdentifierList keys,
            org.ccsds.moims.mo.mal.structures.NullableAttributeList newRawValues) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException {
        consumer.submit(org.ccsds.moims.mo.mc.parameter.ParameterServiceInfo.SETVALUE_OP, domain, keys, newRawValues);
    }

    /**
     * Asynchronous version of method setValue.
     * 
     * @param domain .
     * @param keys .
     * @param newRawValues .
     * @param adapter adapter Listener in charge of receiving the messages from
     * the service provider.
     * @return the MAL message sent to initiate the interaction.
     * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem
     * during the interaction as defined by the MAL specification.
     * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation
     * exception.
     */
    public org.ccsds.moims.mo.mal.transport.MALMessage asyncSetValue(org.ccsds.moims.mo.mal.structures.IdentifierList domain,
            org.ccsds.moims.mo.mal.structures.IdentifierList keys,
            org.ccsds.moims.mo.mal.structures.NullableAttributeList newRawValues,
            org.ccsds.moims.mo.mc.parameter.consumer.ParameterAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException {
        return consumer.asyncSubmit(org.ccsds.moims.mo.mc.parameter.ParameterServiceInfo.SETVALUE_OP, adapter, domain, keys, newRawValues);
    }

    /**
     * Continues a previously started interaction.
     * 
     * @param lastInteractionStage lastInteractionStage The last stage of the
     * interaction to continue.
     * @param initiationTimestamp initiationTimestamp Timestamp of the interaction
     * initiation message.
     * @param transactionId transactionId Transaction identifier of the interaction
     * to continue.
     * @param adapter adapter Listener in charge of receiving the messages from
     * the service provider.
     * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem
     * during the interaction as defined by the MAL specification.
     * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation
     * exception.
     */
    public void continueSetValue(org.ccsds.moims.mo.mal.structures.UOctet lastInteractionStage,
            org.ccsds.moims.mo.mal.structures.Time initiationTimestamp,
            Long transactionId,
            org.ccsds.moims.mo.mc.parameter.consumer.ParameterAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException {
        consumer.continueInteraction(org.ccsds.moims.mo.mc.parameter.ParameterServiceInfo.SETVALUE_OP, lastInteractionStage, initiationTimestamp, transactionId, adapter);
    }

    /**
     * The getReportingConfiguration operation allows a consumer to retrieve the
     * current configuration for the generation of reports for a parameter.
     * 
     * @param domain .
     * @param keys .
     * @return The return value of the interaction.
     * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem
     * during the interaction as defined by the MAL specification.
     * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation
     * exception.
     */
    public org.ccsds.moims.mo.mc.structures.ReportConfigurationList getReportingConfiguration(org.ccsds.moims.mo.mal.structures.IdentifierList domain,
            org.ccsds.moims.mo.mal.structures.IdentifierList keys) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException {
        org.ccsds.moims.mo.mal.transport.MALMessageBody body = consumer.request(org.ccsds.moims.mo.mc.parameter.ParameterServiceInfo.GETREPORTINGCONFIGURATION_OP, domain, keys);
        Object body0 = (Object) body.getBodyElement(0, new org.ccsds.moims.mo.mc.structures.ReportConfigurationList());
        return (org.ccsds.moims.mo.mc.structures.ReportConfigurationList) body0;
    }

    /**
     * Asynchronous version of method getReportingConfiguration.
     * 
     * @param domain .
     * @param keys .
     * @param adapter adapter Listener in charge of receiving the messages from
     * the service provider.
     * @return the MAL message sent to initiate the interaction.
     * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem
     * during the interaction as defined by the MAL specification.
     * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation
     * exception.
     */
    public org.ccsds.moims.mo.mal.transport.MALMessage asyncGetReportingConfiguration(org.ccsds.moims.mo.mal.structures.IdentifierList domain,
            org.ccsds.moims.mo.mal.structures.IdentifierList keys,
            org.ccsds.moims.mo.mc.parameter.consumer.ParameterAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException {
        return consumer.asyncRequest(org.ccsds.moims.mo.mc.parameter.ParameterServiceInfo.GETREPORTINGCONFIGURATION_OP, adapter, domain, keys);
    }

    /**
     * Continues a previously started interaction.
     * 
     * @param lastInteractionStage lastInteractionStage The last stage of the
     * interaction to continue.
     * @param initiationTimestamp initiationTimestamp Timestamp of the interaction
     * initiation message.
     * @param transactionId transactionId Transaction identifier of the interaction
     * to continue.
     * @param adapter adapter Listener in charge of receiving the messages from
     * the service provider.
     * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem
     * during the interaction as defined by the MAL specification.
     * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation
     * exception.
     */
    public void continueGetReportingConfiguration(org.ccsds.moims.mo.mal.structures.UOctet lastInteractionStage,
            org.ccsds.moims.mo.mal.structures.Time initiationTimestamp,
            Long transactionId,
            org.ccsds.moims.mo.mc.parameter.consumer.ParameterAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException {
        consumer.continueInteraction(org.ccsds.moims.mo.mc.parameter.ParameterServiceInfo.GETREPORTINGCONFIGURATION_OP, lastInteractionStage, initiationTimestamp, transactionId, adapter);
    }

    /**
     * The enableReporting operation allows a consumer to request the generation
     * of reports for specific parameters.
     * 
     * @param domain .
     * @param keys .
     * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem
     * during the interaction as defined by the MAL specification.
     * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation
     * exception.
     */
    public void enableReporting(org.ccsds.moims.mo.mal.structures.IdentifierList domain,
            org.ccsds.moims.mo.mal.structures.IdentifierList keys) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException {
        consumer.submit(org.ccsds.moims.mo.mc.parameter.ParameterServiceInfo.ENABLEREPORTING_OP, domain, keys);
    }

    /**
     * Asynchronous version of method enableReporting.
     * 
     * @param domain .
     * @param keys .
     * @param adapter adapter Listener in charge of receiving the messages from
     * the service provider.
     * @return the MAL message sent to initiate the interaction.
     * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem
     * during the interaction as defined by the MAL specification.
     * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation
     * exception.
     */
    public org.ccsds.moims.mo.mal.transport.MALMessage asyncEnableReporting(org.ccsds.moims.mo.mal.structures.IdentifierList domain,
            org.ccsds.moims.mo.mal.structures.IdentifierList keys,
            org.ccsds.moims.mo.mc.parameter.consumer.ParameterAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException {
        return consumer.asyncSubmit(org.ccsds.moims.mo.mc.parameter.ParameterServiceInfo.ENABLEREPORTING_OP, adapter, domain, keys);
    }

    /**
     * Continues a previously started interaction.
     * 
     * @param lastInteractionStage lastInteractionStage The last stage of the
     * interaction to continue.
     * @param initiationTimestamp initiationTimestamp Timestamp of the interaction
     * initiation message.
     * @param transactionId transactionId Transaction identifier of the interaction
     * to continue.
     * @param adapter adapter Listener in charge of receiving the messages from
     * the service provider.
     * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem
     * during the interaction as defined by the MAL specification.
     * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation
     * exception.
     */
    public void continueEnableReporting(org.ccsds.moims.mo.mal.structures.UOctet lastInteractionStage,
            org.ccsds.moims.mo.mal.structures.Time initiationTimestamp,
            Long transactionId,
            org.ccsds.moims.mo.mc.parameter.consumer.ParameterAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException {
        consumer.continueInteraction(org.ccsds.moims.mo.mc.parameter.ParameterServiceInfo.ENABLEREPORTING_OP, lastInteractionStage, initiationTimestamp, transactionId, adapter);
    }

    /**
     * The disableReporting operation allows a consumer to stop the generation
     * of reports for specific parameters.
     * 
     * @param domain .
     * @param keys .
     * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem
     * during the interaction as defined by the MAL specification.
     * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation
     * exception.
     */
    public void disableReporting(org.ccsds.moims.mo.mal.structures.IdentifierList domain,
            org.ccsds.moims.mo.mal.structures.IdentifierList keys) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException {
        consumer.submit(org.ccsds.moims.mo.mc.parameter.ParameterServiceInfo.DISABLEREPORTING_OP, domain, keys);
    }

    /**
     * Asynchronous version of method disableReporting.
     * 
     * @param domain .
     * @param keys .
     * @param adapter adapter Listener in charge of receiving the messages from
     * the service provider.
     * @return the MAL message sent to initiate the interaction.
     * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem
     * during the interaction as defined by the MAL specification.
     * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation
     * exception.
     */
    public org.ccsds.moims.mo.mal.transport.MALMessage asyncDisableReporting(org.ccsds.moims.mo.mal.structures.IdentifierList domain,
            org.ccsds.moims.mo.mal.structures.IdentifierList keys,
            org.ccsds.moims.mo.mc.parameter.consumer.ParameterAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException {
        return consumer.asyncSubmit(org.ccsds.moims.mo.mc.parameter.ParameterServiceInfo.DISABLEREPORTING_OP, adapter, domain, keys);
    }

    /**
     * Continues a previously started interaction.
     * 
     * @param lastInteractionStage lastInteractionStage The last stage of the
     * interaction to continue.
     * @param initiationTimestamp initiationTimestamp Timestamp of the interaction
     * initiation message.
     * @param transactionId transactionId Transaction identifier of the interaction
     * to continue.
     * @param adapter adapter Listener in charge of receiving the messages from
     * the service provider.
     * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem
     * during the interaction as defined by the MAL specification.
     * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation
     * exception.
     */
    public void continueDisableReporting(org.ccsds.moims.mo.mal.structures.UOctet lastInteractionStage,
            org.ccsds.moims.mo.mal.structures.Time initiationTimestamp,
            Long transactionId,
            org.ccsds.moims.mo.mc.parameter.consumer.ParameterAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException {
        consumer.continueInteraction(org.ccsds.moims.mo.mc.parameter.ParameterServiceInfo.DISABLEREPORTING_OP, lastInteractionStage, initiationTimestamp, transactionId, adapter);
    }

    /**
     * The setReportingPeriod operation allows a consumer to set the reporting
     * interval for specific parameters.
     * 
     * @param domain .
     * @param keys .
     * @param reportInterval .
     * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem
     * during the interaction as defined by the MAL specification.
     * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation
     * exception.
     */
    public void setReportingPeriod(org.ccsds.moims.mo.mal.structures.IdentifierList domain,
            org.ccsds.moims.mo.mal.structures.IdentifierList keys,
            org.ccsds.moims.mo.mal.structures.Duration reportInterval) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException {
        consumer.submit(org.ccsds.moims.mo.mc.parameter.ParameterServiceInfo.SETREPORTINGPERIOD_OP, domain, keys, reportInterval);
    }

    /**
     * Asynchronous version of method setReportingPeriod.
     * 
     * @param domain .
     * @param keys .
     * @param reportInterval .
     * @param adapter adapter Listener in charge of receiving the messages from
     * the service provider.
     * @return the MAL message sent to initiate the interaction.
     * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem
     * during the interaction as defined by the MAL specification.
     * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation
     * exception.
     */
    public org.ccsds.moims.mo.mal.transport.MALMessage asyncSetReportingPeriod(org.ccsds.moims.mo.mal.structures.IdentifierList domain,
            org.ccsds.moims.mo.mal.structures.IdentifierList keys,
            org.ccsds.moims.mo.mal.structures.Duration reportInterval,
            org.ccsds.moims.mo.mc.parameter.consumer.ParameterAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException {
        return consumer.asyncSubmit(org.ccsds.moims.mo.mc.parameter.ParameterServiceInfo.SETREPORTINGPERIOD_OP, adapter, domain, keys, reportInterval);
    }

    /**
     * Continues a previously started interaction.
     * 
     * @param lastInteractionStage lastInteractionStage The last stage of the
     * interaction to continue.
     * @param initiationTimestamp initiationTimestamp Timestamp of the interaction
     * initiation message.
     * @param transactionId transactionId Transaction identifier of the interaction
     * to continue.
     * @param adapter adapter Listener in charge of receiving the messages from
     * the service provider.
     * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem
     * during the interaction as defined by the MAL specification.
     * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation
     * exception.
     */
    public void continueSetReportingPeriod(org.ccsds.moims.mo.mal.structures.UOctet lastInteractionStage,
            org.ccsds.moims.mo.mal.structures.Time initiationTimestamp,
            Long transactionId,
            org.ccsds.moims.mo.mc.parameter.consumer.ParameterAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException {
        consumer.continueInteraction(org.ccsds.moims.mo.mc.parameter.ParameterServiceInfo.SETREPORTINGPERIOD_OP, lastInteractionStage, initiationTimestamp, transactionId, adapter);
    }

}
