/*
 * Decompiled with CFR 0.152.
 */
package io._57blocks.email.config;

import io._57blocks.email.EmailService;
import io._57blocks.email.EmailServiceImpl;
import io._57blocks.email.config.properties.EmailServiceProperties;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.mail.javamail.JavaMailSender;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.spring5.SpringTemplateEngine;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateresolver.ClassLoaderTemplateResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;

@Configuration
@ConditionalOnMissingBean(value={EmailService.class})
@ConditionalOnBean(value={JavaMailSender.class})
@AutoConfigureAfter(name={"io._57blocks.email.config.DummyEmailServiceAutoConfig", "org.springframework.boot.autoconfigure.mail.MailSenderAutoConfiguration", "org.springframework.cloud.aws.autoconfigure.mail.MailSenderAutoConfiguration"})
@EnableConfigurationProperties(value={EmailServiceProperties.class})
public class EmailServiceAutoConfig {
    @Autowired
    private EmailServiceProperties properties;
    @Autowired
    private JavaMailSender mailSender;

    private ResourceBundleMessageSource emailMessageSource() {
        ResourceBundleMessageSource messageSource = new ResourceBundleMessageSource();
        messageSource.setBasename(this.properties.getTemplate().getFullMessageBaseName());
        return messageSource;
    }

    private TemplateEngine emailTemplateEngine() {
        SpringTemplateEngine templateEngine = new SpringTemplateEngine();
        templateEngine.addTemplateResolver(this.textTemplateResolver());
        templateEngine.addTemplateResolver(this.htmlTemplateResolver());
        templateEngine.addTemplateResolver(this.subjectTemplateResolver());
        templateEngine.setTemplateEngineMessageSource((MessageSource)this.emailMessageSource());
        return templateEngine;
    }

    private ITemplateResolver textTemplateResolver() {
        return this.createTemplateResolver(this.properties.getTemplate().getText(), TemplateMode.TEXT);
    }

    private ITemplateResolver htmlTemplateResolver() {
        return this.createTemplateResolver(this.properties.getTemplate().getHtml(), TemplateMode.HTML);
    }

    private ITemplateResolver subjectTemplateResolver() {
        return this.createTemplateResolver(this.properties.getTemplate().getSubject(), TemplateMode.TEXT);
    }

    private ITemplateResolver createTemplateResolver(EmailServiceProperties.TemplateResolverProperties props, TemplateMode templateMode) {
        ClassLoaderTemplateResolver templateResolver = new ClassLoaderTemplateResolver();
        templateResolver.setOrder(props.getOrder());
        templateResolver.setResolvablePatterns(Collections.singleton(props.getPattern()));
        templateResolver.setPrefix(this.properties.getTemplate().getPrefix());
        templateResolver.setSuffix(props.getSuffix());
        templateResolver.setTemplateMode(templateMode);
        templateResolver.setCharacterEncoding(props.getCharacterEncoding());
        templateResolver.setCacheable(props.getCacheable().booleanValue());
        return templateResolver;
    }

    @Bean
    @ConditionalOnMissingBean
    public EmailService htmlEmailService() {
        return new EmailServiceImpl(this.mailSender, this.emailTemplateEngine(), this.properties);
    }
}

