/*
 * Decompiled with CFR 0.152.
 */
package izumi.functional.bio;

import izumi.functional.bio.DivergenceHelper;
import izumi.functional.bio.Entropy1$;
import izumi.functional.bio.SyncSafe1;
import izumi.fundamentals.platform.uuid.IzUUID$;
import java.util.UUID;
import scala.;
import scala.$less$colon$less$;
import scala.Predef$;
import scala.collection.BuildFrom;
import scala.collection.IterableOnce;
import scala.math.package$;
import scala.runtime.RichInt$;
import scala.util.Random;

public interface Entropy1<F>
extends DivergenceHelper {
    public static <F> Entropy1<F> apply(Entropy1<F> entropy1) {
        return Entropy1$.MODULE$.apply(entropy1);
    }

    public static <F, G> Entropy1<G> covarianceConversion(Entropy1<F> entropy1, .less.colon.less<Object, Object> less2) {
        return Entropy1$.MODULE$.covarianceConversion(entropy1, less2);
    }

    public static <F> Entropy1<F> fromImpure(Entropy1<Object> entropy1, SyncSafe1<F> syncSafe1) {
        return Entropy1$.MODULE$.fromImpure(entropy1, syncSafe1);
    }

    public static <F> Entropy1<F> fromImpureEntropy(Entropy1<Object> entropy1, SyncSafe1<F> syncSafe1) {
        return Entropy1$.MODULE$.fromImpureEntropy((Entropy1)entropy1, (SyncSafe1)syncSafe1);
    }

    public static Entropy1<Object> impureEntropy() {
        return Entropy1$.MODULE$.impureEntropy();
    }

    public static <C extends Entropy1<Object>, F, E> Entropy1 limitedCovariance2(Entropy1 entropy1) {
        return Entropy1$.MODULE$.limitedCovariance2(entropy1);
    }

    public static <C extends Entropy1<Object>, FR, R0, E> Entropy1 limitedCovariance3(Entropy1 entropy1) {
        return Entropy1$.MODULE$.limitedCovariance3(entropy1);
    }

    public F nextBoolean();

    public F nextInt();

    public F nextInt(int var1);

    public F nextLong();

    public F nextLong(long var1);

    public F nextFloat();

    public F nextDouble();

    public F nextGaussian();

    public F nextBytes(int var1);

    public F nextPrintableChar();

    public F nextString(int var1);

    public F nextTimeUUID();

    public F nextUUID();

    public <T, CC extends IterableOnce<Object>> F shuffle(IterableOnce<T> var1, BuildFrom<IterableOnce<T>, T, IterableOnce<T>> var2);

    public Entropy1<F> withSeed(long var1);

    public F setSeed(long var1);

    public F writeRandomBytes(byte[] var1);

    public static Entropy1 widen$(Entropy1 $this) {
        return $this.widen();
    }

    default public <G> Entropy1<G> widen() {
        return Entropy1$.MODULE$.covarianceConversion(this, (.less.colon.less<Object, Object>)$less$colon$less$.MODULE$.refl());
    }

    public static class Deterministic
    implements Entropy1,
    ScalaEntropy {
        private final Random random;

        public Deterministic(long seed) {
            this.random = new Random(seed);
        }

        @Override
        public Random random() {
            return this.random;
        }

        @Override
        public UUID nextTimeUUID() {
            return IzUUID$.MODULE$.getTimeUUID(package$.MODULE$.abs(this.random().nextLong()));
        }

        @Override
        public UUID nextUUID() {
            return new UUID(this.random().nextLong(), this.random().nextLong());
        }
    }

    public static interface ScalaEntropy
    extends Entropy1<Object> {
        public Random random();

        public static IterableOnce shuffle$(ScalaEntropy $this, IterableOnce xs, BuildFrom bf) {
            return $this.shuffle(xs, bf);
        }

        @Override
        default public <T, CC extends IterableOnce<Object>> IterableOnce<T> shuffle(IterableOnce<T> xs, BuildFrom<IterableOnce<T>, T, IterableOnce<T>> bf) {
            return (IterableOnce)this.random().shuffle(xs, bf);
        }

        public static Entropy1 withSeed$(ScalaEntropy $this, long seed) {
            return $this.withSeed(seed);
        }

        @Override
        default public Entropy1<Object> withSeed(long seed) {
            return new Deterministic(seed);
        }

        public static boolean nextBoolean$(ScalaEntropy $this) {
            return $this.nextBoolean();
        }

        @Override
        default public boolean nextBoolean() {
            return this.random().nextBoolean();
        }

        public static float nextFloat$(ScalaEntropy $this) {
            return $this.nextFloat();
        }

        @Override
        default public float nextFloat() {
            return this.random().nextFloat();
        }

        public static double nextDouble$(ScalaEntropy $this) {
            return $this.nextDouble();
        }

        @Override
        default public double nextDouble() {
            return this.random().nextDouble();
        }

        public static double nextGaussian$(ScalaEntropy $this) {
            return $this.nextGaussian();
        }

        @Override
        default public double nextGaussian() {
            return this.random().nextGaussian();
        }

        public static int nextInt$(ScalaEntropy $this) {
            return $this.nextInt();
        }

        @Override
        default public int nextInt() {
            return this.random().nextInt();
        }

        public static int nextInt$(ScalaEntropy $this, int max) {
            return $this.nextInt(max);
        }

        @Override
        default public int nextInt(int max) {
            return this.random().nextInt(max);
        }

        public static long nextLong$(ScalaEntropy $this) {
            return $this.nextLong();
        }

        @Override
        default public long nextLong() {
            return this.random().nextLong();
        }

        public static long nextLong$(ScalaEntropy $this, long max) {
            return $this.nextLong(max);
        }

        @Override
        default public long nextLong(long max) {
            if (max <= 0L) {
                throw new IllegalArgumentException("bound must be positive");
            }
            return package$.MODULE$.abs(this.random().nextLong()) % max;
        }

        public static char nextPrintableChar$(ScalaEntropy $this) {
            return $this.nextPrintableChar();
        }

        @Override
        default public char nextPrintableChar() {
            return this.random().nextPrintableChar();
        }

        public static String nextString$(ScalaEntropy $this, int length) {
            return $this.nextString(length);
        }

        @Override
        default public String nextString(int length) {
            return this.random().nextString(length);
        }

        public static byte[] nextBytes$(ScalaEntropy $this, int length) {
            return $this.nextBytes(length);
        }

        @Override
        default public byte[] nextBytes(int length) {
            byte[] bytes = new byte[RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(0), length)];
            this.random().nextBytes(bytes);
            return bytes;
        }

        public static void writeRandomBytes$(ScalaEntropy $this, byte[] bytes) {
            $this.writeRandomBytes(bytes);
        }

        @Override
        default public void writeRandomBytes(byte[] bytes) {
            this.random().nextBytes(bytes);
        }

        public static void setSeed$(ScalaEntropy $this, long seed) {
            $this.setSeed(seed);
        }

        @Override
        default public void setSeed(long seed) {
            this.random().setSeed(seed);
        }
    }
}

