/*
 * Decompiled with CFR 0.152.
 */
package izumi.functional.bio.retry;

import izumi.functional.bio.Applicative2;
import izumi.functional.bio.package$;
import izumi.functional.bio.retry.RetryPolicy;
import izumi.functional.bio.retry.RetryPolicy$ControllerDecision$;
import izumi.functional.bio.retry.RetryPolicy$ControllerDecision$Repeat$;
import izumi.functional.bio.retry.RetryPolicy$ControllerDecision$Stop$;
import izumi.functional.bio.retry.RetryPolicy$RetryFunction$;
import izumi.functional.bio.retry.RetryPolicy$State$3$;
import java.io.Serializable;
import java.time.ZonedDateTime;
import java.util.concurrent.TimeUnit;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.FiniteDuration$;
import scala.math.BigInt;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

public final class RetryPolicy$
implements Serializable {
    private static final BigInt LongMax;
    public static final RetryPolicy$RetryFunction$ RetryFunction;
    public static final RetryPolicy$ControllerDecision$ ControllerDecision;
    public static final RetryPolicy$ MODULE$;

    private RetryPolicy$() {
    }

    static {
        MODULE$ = new RetryPolicy$();
        LongMax = scala.package$.MODULE$.BigInt().apply(Long.MAX_VALUE);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(RetryPolicy$.class);
    }

    public <F, A, B> RetryPolicy<F, A, B> apply(Function2<ZonedDateTime, A, Object> action) {
        return new RetryPolicy(action);
    }

    public <F, A> RetryPolicy<F, A, A> identity(Applicative2<F> evidence$1) {
        LazyRef lazyRef = new LazyRef();
        return this.apply(this.loop$5(lazyRef, evidence$1));
    }

    public <F> RetryPolicy<F, Object, BoxedUnit> giveUp(Applicative2<F> evidence$1) {
        return this.apply(RetryPolicy$RetryFunction$.MODULE$.done(BoxedUnit.UNIT, evidence$1));
    }

    public <F> RetryPolicy<F, Object, FiniteDuration> elapsed(Applicative2<F> evidence$1) {
        return this.apply(this.loop$6(evidence$1, (Option)None$.MODULE$));
    }

    public <F> RetryPolicy<F, Object, Object> forever(Applicative2<F> evidence$1) {
        return this.apply(this.loop$7(evidence$1, 0L));
    }

    public <F> RetryPolicy<F, Object, Object> recurs(int n, Applicative2<F> evidence$1) {
        return this.forever(evidence$1).whileOutput((Function1<Object, Object>)(JFunction1.mcZJ.sp & Serializable)_$19 -> _$19 < (long)n, evidence$1);
    }

    public <F> RetryPolicy<F, Object, Object> spaced(FiniteDuration timeInterval, Applicative2<F> evidence$1) {
        return this.forever(evidence$1).modifyDelay((Function1<Object, FiniteDuration>)(Function1 & Serializable)_$22 -> timeInterval, evidence$1);
    }

    public <F, A> RetryPolicy<F, A, A> recursWhile(Function1<A, Object> f, Applicative2<F> evidence$1) {
        return this.identity(evidence$1).whileInput(f, evidence$1);
    }

    public <F> RetryPolicy<F, Object, Object> fixed(FiniteDuration period, Applicative2<F> evidence$1) {
        LazyRef lazyRef = new LazyRef();
        long intervalMillis = period.toMillis();
        return this.apply(this.loop$8(evidence$1, intervalMillis, period, lazyRef, (Option)None$.MODULE$, 0L));
    }

    public <F> RetryPolicy<F, Object, FiniteDuration> exponential(FiniteDuration baseDelay, Applicative2<F> evidence$1) {
        return this.forever(evidence$1).map((Function1 & Serializable)retriesSoFar -> RetryPolicy$.MODULE$.multiply(baseDelay, (long)Math.pow(2.0, BoxesRunTime.unboxToLong((Object)retriesSoFar))), evidence$1).modifyDelay((Function1 & Serializable)d -> d, evidence$1);
    }

    public <F> RetryPolicy<F, Object, Tuple2<FiniteDuration, Object>> exponentialWithBound(FiniteDuration baseDelay, int maxRetries, Applicative2<F> evidence$1) {
        return this.exponential(baseDelay, evidence$1).$amp$amp(this.recurs(maxRetries, evidence$1), evidence$1);
    }

    private FiniteDuration multiply(FiniteDuration delay, long multiplier) {
        BigInt base = scala.package$.MODULE$.BigInt().apply(delay.toNanos());
        BigInt result = base.$times(scala.package$.MODULE$.BigInt().apply(multiplier));
        BigInt cappedResult = result.min(LongMax);
        return FiniteDuration$.MODULE$.apply(cappedResult.toLong(), TimeUnit.NANOSECONDS);
    }

    private final Function2 loop$lzyINIT1$1(LazyRef loop$lzy1$1, Applicative2 evidence$1$1) {
        Function2 function2;
        LazyRef lazyRef = loop$lzy1$1;
        synchronized (lazyRef) {
            function2 = (Function2)(loop$lzy1$1.initialized() ? loop$lzy1$1.value() : loop$lzy1$1.initialize((Function2 & Serializable)(now, in) -> ((Applicative2)package$.MODULE$.F(evidence$1$1)).pure(RetryPolicy$ControllerDecision$Repeat$.MODULE$.apply(in, (ZonedDateTime)now, this.loop$5(loop$lzy1$1, evidence$1$1)))));
        }
        return function2;
    }

    private final Function2 loop$5(LazyRef loop$lzy1$3, Applicative2 evidence$1$3) {
        return (Function2)(loop$lzy1$3.initialized() ? loop$lzy1$3.value() : this.loop$lzyINIT1$1(loop$lzy1$3, evidence$1$3));
    }

    private final Function2 loop$6(Applicative2 evidence$1$4, Option start) {
        return (Function2 & Serializable)(now, _$13) -> {
            RetryPolicy.ControllerDecision.Repeat repeat;
            Applicative2 applicative2 = (Applicative2)package$.MODULE$.F(evidence$1$4);
            Option option = start;
            if (option instanceof Some) {
                ZonedDateTime start = (ZonedDateTime)((Some)option).value();
                FiniteDuration duration = FiniteDuration$.MODULE$.apply(now.toInstant().toEpochMilli() - start.toInstant().toEpochMilli(), TimeUnit.MILLISECONDS);
                repeat = RetryPolicy$ControllerDecision$Repeat$.MODULE$.apply(duration, (ZonedDateTime)now, this.loop$6(evidence$1$4, (Option)Some$.MODULE$.apply((Object)start)));
            } else if (None$.MODULE$.equals(option)) {
                repeat = RetryPolicy$ControllerDecision$Repeat$.MODULE$.apply(FiniteDuration$.MODULE$.apply(0L, TimeUnit.MILLISECONDS), (ZonedDateTime)now, this.loop$6(evidence$1$4, (Option)Some$.MODULE$.apply(now)));
            } else {
                throw new MatchError((Object)option);
            }
            return applicative2.pure(repeat);
        };
    }

    private final Function2 loop$7(Applicative2 evidence$1$6, long n) {
        return (Function2 & Serializable)(now, _$16) -> ((Applicative2)package$.MODULE$.F(evidence$1$6)).pure(RetryPolicy$ControllerDecision$Repeat$.MODULE$.apply(BoxesRunTime.boxToLong((long)n), (ZonedDateTime)now, this.loop$7(evidence$1$6, n + 1L)));
    }

    private final RetryPolicy$State$3$ State$lzyINIT1$1(LazyRef State$lzy1$1) {
        RetryPolicy$State$3$ retryPolicy$State$3$;
        LazyRef lazyRef = State$lzy1$1;
        synchronized (lazyRef) {
            retryPolicy$State$3$ = (RetryPolicy$State$3$)(State$lzy1$1.initialized() ? State$lzy1$1.value() : State$lzy1$1.initialize((Object)new RetryPolicy$State$3$()));
        }
        return retryPolicy$State$3$;
    }

    private final RetryPolicy$State$3$ State$2(LazyRef State$lzy1$2) {
        return (RetryPolicy$State$3$)(State$lzy1$2.initialized() ? State$lzy1$2.value() : this.State$lzyINIT1$1(State$lzy1$2));
    }

    private final Function2 loop$8(Applicative2 evidence$1$8, long intervalMillis$1, FiniteDuration period$1, LazyRef State$lzy1$3, Option state, long n) {
        return (Function2 & Serializable)(now, _$27) -> {
            RetryPolicy.ControllerDecision.Repeat repeat;
            public final class Izumi_functional_bio_retry_RetryPolicy$State$1
            implements Product,
            Serializable {
                private final long startMillis;
                private final long lastRun;

                public Izumi_functional_bio_retry_RetryPolicy$State$1(long startMillis, long lastRun) {
                    this.startMillis = startMillis;
                    this.lastRun = lastRun;
                }

                public int hashCode() {
                    int n = -889275714;
                    n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
                    n = Statics.mix((int)n, (int)Statics.longHash((long)this.startMillis()));
                    n = Statics.mix((int)n, (int)Statics.longHash((long)this.lastRun()));
                    return Statics.finalizeHash((int)n, (int)2);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public boolean equals(Object x$0) {
                    if (this == x$0) return true;
                    Object object = x$0;
                    if (!(object instanceof Izumi_functional_bio_retry_RetryPolicy$State$1)) return false;
                    Izumi_functional_bio_retry_RetryPolicy$State$1 var3_3 = (Izumi_functional_bio_retry_RetryPolicy$State$1)object;
                    if (this.startMillis() != var3_3.startMillis()) return false;
                    if (this.lastRun() != var3_3.lastRun()) return false;
                    return true;
                }

                public String toString() {
                    return ScalaRunTime$.MODULE$._toString((Product)this);
                }

                public boolean canEqual(Object that) {
                    return that instanceof Izumi_functional_bio_retry_RetryPolicy$State$1;
                }

                public int productArity() {
                    return 2;
                }

                public String productPrefix() {
                    return "State";
                }

                public Object productElement(int n) {
                    long l;
                    int n2 = n;
                    if (0 == n2) {
                        l = this._1();
                    } else if (1 == n2) {
                        l = this._2();
                    } else {
                        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                    }
                    return BoxesRunTime.boxToLong((long)l);
                }

                public String productElementName(int n) {
                    int n2 = n;
                    if (0 == n2) {
                        return "startMillis";
                    }
                    if (1 == n2) {
                        return "lastRun";
                    }
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }

                public long startMillis() {
                    return this.startMillis;
                }

                public long lastRun() {
                    return this.lastRun;
                }

                public Izumi_functional_bio_retry_RetryPolicy$State$1 copy(long startMillis, long lastRun) {
                    return new Izumi_functional_bio_retry_RetryPolicy$State$1(startMillis, lastRun);
                }

                public long copy$default$1() {
                    return this.startMillis();
                }

                public long copy$default$2() {
                    return this.lastRun();
                }

                public long _1() {
                    return this.startMillis();
                }

                public long _2() {
                    return this.lastRun();
                }
            }
            Izumi_functional_bio_retry_RetryPolicy$State$1 var12_10;
            Applicative2 applicative2 = (Applicative2)package$.MODULE$.F(evidence$1$8);
            Option option = state;
            if (option instanceof Some && (var12_10 = (Izumi_functional_bio_retry_RetryPolicy$State$1)((Some)option).value()) != null) {
                Izumi_functional_bio_retry_RetryPolicy$State$1 var13_11 = this.State$2(State$lzy1$3).unapply(var12_10);
                long l = var13_11._1();
                long l2 = var13_11._2();
                long startMillis = l;
                long lastRun = l2;
                long nowMillis = now.toInstant().toEpochMilli();
                boolean runningBehind = nowMillis > lastRun + intervalMillis$1;
                FiniteDuration boundary = period$1.length() == 0L ? period$1 : FiniteDuration$.MODULE$.apply(intervalMillis$1 - (nowMillis - startMillis) % intervalMillis$1, TimeUnit.MILLISECONDS);
                FiniteDuration sleepTime = boundary.length() == 0L ? period$1 : boundary;
                ZonedDateTime nextRun = runningBehind ? now : now.plusNanos(sleepTime.toNanos());
                repeat = RetryPolicy$ControllerDecision$Repeat$.MODULE$.apply(BoxesRunTime.boxToLong((long)(n + 1L)), nextRun, this.loop$8(evidence$1$8, intervalMillis$1, period$1, State$lzy1$3, (Option)Some$.MODULE$.apply((Object)this.State$2(State$lzy1$3).apply(startMillis, nextRun.toInstant().toEpochMilli())), n + 1L));
            } else if (None$.MODULE$.equals(option)) {
                long nowMillis = now.toInstant().toEpochMilli();
                ZonedDateTime nextRun = now.plusNanos(period$1.toNanos());
                repeat = RetryPolicy$ControllerDecision$Repeat$.MODULE$.apply(BoxesRunTime.boxToLong((long)(n + 1L)), nextRun, this.loop$8(evidence$1$8, intervalMillis$1, period$1, State$lzy1$3, (Option)Some$.MODULE$.apply((Object)this.State$2(State$lzy1$3).apply(nowMillis, nextRun.toInstant().toEpochMilli())), n + 1L));
            } else {
                throw new MatchError((Object)option);
            }
            return applicative2.pure(repeat);
        };
    }

    public static final /* synthetic */ Object izumi$functional$bio$retry$RetryPolicy$RetryFunction$$$_$done$$anonfun$1(Applicative2 evidence$1$10, Object value$1, ZonedDateTime _$36, Object _$37) {
        return ((Applicative2)package$.MODULE$.F(evidence$1$10)).pure(RetryPolicy$ControllerDecision$Stop$.MODULE$.apply(value$1));
    }
}

