/*
 * Decompiled with CFR 0.152.
 */
package izumi.functional.quasi;

import cats.effect.IO;
import cats.effect.IOPlatform;
import cats.effect.std.Dispatcher;
import cats.effect.unsafe.IORuntime;
import izumi.functional.bio.UnsafeRun2;
import izumi.functional.bio.UnsafeRun2$;
import izumi.functional.quasi.QuasiIORunner$;
import izumi.fundamentals.orphans.cats;
import scala.Function0;

public interface QuasiIORunner<F> {
    public static <F> QuasiIORunner<F> apply(QuasiIORunner<F> quasiIORunner) {
        return QuasiIORunner$.MODULE$.apply(quasiIORunner);
    }

    public static <F> QuasiIORunner<?> fromBIO(UnsafeRun2<F> unsafeRun2) {
        return QuasiIORunner$.MODULE$.fromBIO(unsafeRun2);
    }

    public static <F, Dispatcher> QuasiIORunner<F> fromCatsDispatcher(cats.u002Eeffect.u002Estd.u002EDispatcher<Dispatcher> u002EDispatcher2, Object object) {
        return QuasiIORunner$.MODULE$.fromCatsDispatcher((cats.u002Eeffect.u002Estd.u002EDispatcher)u002EDispatcher2, object);
    }

    public static <IO, IORuntime> QuasiIORunner<IO> fromCatsIORuntime(cats.u002Eeffect.u002EIO<IO> u002EIO2, cats.u002Eeffect.u002Eunsafe.u002EIORuntime<IORuntime> u002EIORuntime2, IORuntime IORuntime2) {
        return QuasiIORunner$.MODULE$.fromCatsIORuntime((cats.u002Eeffect.u002EIO)u002EIO2, (cats.u002Eeffect.u002Eunsafe.u002EIORuntime)u002EIORuntime2, (Object)IORuntime2);
    }

    public static <F> QuasiIORunner<F> mkFromCatsDispatcher(Dispatcher<F> dispatcher) {
        return QuasiIORunner$.MODULE$.mkFromCatsDispatcher((Dispatcher)dispatcher);
    }

    public static QuasiIORunner<IO> mkFromCatsIORuntime(IORuntime iORuntime) {
        return QuasiIORunner$.MODULE$.mkFromCatsIORuntime(iORuntime);
    }

    public <A> A run(Function0<F> var1);

    public static final class BIOImpl<F>
    implements QuasiIORunner<?> {
        private final UnsafeRun2<F> evidence$1;

        public BIOImpl(UnsafeRun2<F> evidence$1) {
            this.evidence$1 = evidence$1;
        }

        @Override
        public <A> A run(Function0<F> f) {
            return UnsafeRun2$.MODULE$.apply(this.evidence$1).unsafeRun(f);
        }
    }

    public static final class CatsDispatcherImpl<F>
    implements QuasiIORunner<F> {
        private final Dispatcher<F> dispatcher;

        public CatsDispatcherImpl(Dispatcher<F> dispatcher) {
            this.dispatcher = dispatcher;
        }

        @Override
        public <A> A run(Function0<F> f) {
            return (A)this.dispatcher.unsafeRunSync(f.apply());
        }
    }

    public static final class CatsIOImpl
    implements QuasiIORunner<IO> {
        private final IORuntime ioRuntime;

        public CatsIOImpl(IORuntime ioRuntime) {
            this.ioRuntime = ioRuntime;
        }

        @Override
        public <A> A run(Function0<IO<A>> f) {
            return (A)((IOPlatform)f.apply()).unsafeRunSync(this.ioRuntime);
        }
    }
}

