/*
 * Decompiled with CFR 0.152.
 */
package izumi.fundamentals.platform.files;

import izumi.functional.lifecycle.Lifecycle;
import izumi.functional.lifecycle.Lifecycle$;
import izumi.functional.lifecycle.Lifecycle$SyntaxUse$;
import izumi.functional.quasi.QuasiAsync;
import izumi.functional.quasi.QuasiIO;
import izumi.functional.quasi.QuasiIO$syntax$;
import izumi.functional.quasi.QuasiIO$syntax$QuasiIOSyntax$;
import izumi.functional.quasi.QuasiTemporal;
import java.io.File;
import java.io.Serializable;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.CompletionHandler;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.StandardOpenOption;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;

public final class FileLockMutex$
implements Serializable {
    public static final FileLockMutex$ MODULE$ = new FileLockMutex$();

    private FileLockMutex$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(FileLockMutex$.class);
    }

    public <F, A> Object withLocalMutex(String filename, FiniteDuration retryWait, int maxAttempts, Function2<Object, Object, Object> attemptLog, Function1<Object, Object> failLog, Function0<Object> lockAlreadyExistedLog, Function0<Object> effect, QuasiIO<F> F, QuasiAsync<F> P, QuasiTemporal<F> T) {
        Lifecycle lifecycle = Lifecycle$.MODULE$.SyntaxUse(this.allocate(filename, retryWait, maxAttempts, attemptLog, failLog, lockAlreadyExistedLog, F, P, T));
        return Lifecycle$SyntaxUse$.MODULE$.use$extension(lifecycle, (Function1 & Serializable)_$2 -> effect.apply(), F);
    }

    public <F> Lifecycle<F, Option<FileLock>> allocate(String filename, FiniteDuration retryWait, int maxAttempts, Function2<Object, Object, Object> attemptLog, Function1<Object, Object> failLog, Function0<Object> lockAlreadyExistedLog, QuasiIO<F> F, QuasiAsync<F> P, QuasiTemporal<F> T) {
        return Lifecycle$.MODULE$.make((Function0<Object>)((Function0 & Serializable)() -> this.allocate$$anonfun$1(F, filename, lockAlreadyExistedLog)), (Function1 & Serializable)channel -> F.definitelyRecoverUnsafeIgnoreTrace(() -> FileLockMutex$.allocate$$anonfun$2$$anonfun$1(F, channel), (Function1 & Serializable)_$8 -> F.unit())).flatMap((Function1 & Serializable)channel -> Lifecycle$.MODULE$.make((Function0<Object>)((Function0 & Serializable)() -> this.allocate$$anonfun$3$$anonfun$1(channel, P, F, attemptLog, maxAttempts, T, retryWait, failLog)), (Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                FileLock lock = (FileLock)((Some)option).value();
                return F.maybeSuspend((Function0 & Serializable)() -> {
                    FileLockMutex$.allocate$$anonfun$3$$anonfun$2$$anonfun$1(lock);
                    return BoxedUnit.UNIT;
                });
            }
            if (None$.MODULE$.equals(option)) {
                return F.unit();
            }
            throw new MatchError((Object)option);
        }), F);
    }

    private static final Object retryOnFileLock$1$$anonfun$1$$anonfun$1(Function2 attemptLog$3, int attempts$1, int maxAttempts$3) {
        return attemptLog$3.apply((Object)BoxesRunTime.boxToInteger((int)attempts$1), (Object)BoxesRunTime.boxToInteger((int)maxAttempts$3));
    }

    private static final Object retryOnFileLock$1$$anonfun$1$$anonfun$2$$anonfun$1(Function0 doAcquire$3, QuasiIO F$4) {
        Object object = QuasiIO$syntax$.MODULE$.QuasiIOSyntax(doAcquire$3.apply());
        return QuasiIO$syntax$QuasiIOSyntax$.MODULE$.map$extension(object, (Function1 & Serializable)lock -> package$.MODULE$.Right().apply((Object)Option$.MODULE$.apply(lock)), F$4);
    }

    private static final Throwable retryOnFileLock$1$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$3(Throwable err$1) {
        return err$1;
    }

    private static final /* synthetic */ Object retryOnFileLock$1$$anonfun$1(QuasiIO F$2, Function2 attemptLog$2, int maxAttempts$2, Function0 doAcquire$1, QuasiTemporal T$2, FiniteDuration retryWait$2, Function1 failLog$2, int attempts) {
        Object object = QuasiIO$syntax$.MODULE$.QuasiIOSyntax(F$2.when(attempts != 0, () -> FileLockMutex$.retryOnFileLock$1$$anonfun$1$$anonfun$1(attemptLog$2, attempts, maxAttempts$2)));
        return QuasiIO$syntax$QuasiIOSyntax$.MODULE$.flatMap$extension(object, (Function1 & Serializable)_$4 -> F$2.definitelyRecoverUnsafeIgnoreTrace(() -> FileLockMutex$.retryOnFileLock$1$$anonfun$1$$anonfun$2$$anonfun$1(doAcquire$1, F$2), (Function1 & Serializable)x$1 -> {
            Throwable throwable = x$1;
            if (throwable instanceof OverlappingFileLockException) {
                if (attempts < maxAttempts$2) {
                    Object object = QuasiIO$syntax$.MODULE$.QuasiIOSyntax(T$2.sleep(retryWait$2));
                    return QuasiIO$syntax$QuasiIOSyntax$.MODULE$.map$extension(object, (Function1 & Serializable)_$5 -> package$.MODULE$.Left().apply((Object)BoxesRunTime.boxToInteger((int)(attempts + 1))), F$2);
                }
                Object object = QuasiIO$syntax$.MODULE$.QuasiIOSyntax(failLog$2.apply((Object)BoxesRunTime.boxToInteger((int)attempts)));
                return QuasiIO$syntax$QuasiIOSyntax$.MODULE$.map$extension(object, (Function1 & Serializable)_$6 -> package$.MODULE$.Right().apply((Object)None$.MODULE$), F$2);
            }
            Throwable err = throwable;
            return F$2.fail((Function0<Throwable>)((Function0 & Serializable)() -> FileLockMutex$.retryOnFileLock$1$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$3(err)));
        }), F$2);
    }

    private final Object retryOnFileLock$1(QuasiIO F$1, Function2 attemptLog$1, int maxAttempts$1, QuasiTemporal T$1, FiniteDuration retryWait$1, Function1 failLog$1, Function0 doAcquire) {
        return F$1.tailRecM(BoxesRunTime.boxToInteger((int)0), (Function1 & Serializable)attempts -> FileLockMutex$.retryOnFileLock$1$$anonfun$1(F$1, attemptLog$1, maxAttempts$1, doAcquire, T$1, retryWait$1, failLog$1, BoxesRunTime.unboxToInt((Object)attempts)));
    }

    private static final void createChannel$1$$anonfun$1$$anonfun$1(File file$1) {
        file$1.deleteOnExit();
    }

    private static final AsynchronousFileChannel createChannel$1$$anonfun$1$$anonfun$2$$anonfun$1(File file$3) {
        return AsynchronousFileChannel.open(file$3.toPath(), StandardOpenOption.WRITE);
    }

    private static final Object createChannel$1$$anonfun$1(String filename$2, QuasiIO F$7, Function0 lockAlreadyExistedLog$2) {
        String tmpDir = System.getProperty("java.io.tmpdir");
        File file = new File(new StringBuilder(5).append(tmpDir).append("/").append(filename$2).append(".tmp").toString());
        boolean newFileCreated = file.createNewFile();
        Object object = QuasiIO$syntax$.MODULE$.QuasiIOSyntax(newFileCreated ? F$7.maybeSuspend((Function0 & Serializable)() -> {
            FileLockMutex$.createChannel$1$$anonfun$1$$anonfun$1(file);
            return BoxedUnit.UNIT;
        }) : lockAlreadyExistedLog$2.apply());
        return QuasiIO$syntax$QuasiIOSyntax$.MODULE$.flatMap$extension(object, (Function1 & Serializable)_$7 -> F$7.maybeSuspend(() -> FileLockMutex$.createChannel$1$$anonfun$1$$anonfun$2$$anonfun$1(file)), F$7);
    }

    private final Object createChannel$1(QuasiIO F$6, String filename$1, Function0 lockAlreadyExistedLog$1) {
        return F$6.suspendF(() -> FileLockMutex$.createChannel$1$$anonfun$1(filename$1, F$6, lockAlreadyExistedLog$1));
    }

    private final Object acquireLock$1$$anonfun$1(QuasiAsync P$2, AsynchronousFileChannel channel$1) {
        return P$2.async((JProcedure1 & Serializable)cb -> {
            CompletionHandler<FileLock, BoxedUnit> handler = new CompletionHandler<FileLock, BoxedUnit>(cb){
                private final Function1 cb$1;
                {
                    this.cb$1 = cb$2;
                }

                public void completed(FileLock result, BoxedUnit attachment) {
                    this.cb$1.apply((Object)package$.MODULE$.Right().apply((Object)result));
                }

                public void failed(Throwable exc, BoxedUnit attachment) {
                    this.cb$1.apply((Object)package$.MODULE$.Left().apply((Object)exc));
                }
            };
            channel$1.lock(BoxedUnit.UNIT, handler);
        });
    }

    private final Object acquireLock$1(QuasiAsync P$1, QuasiIO F$9, Function2 attemptLog$4, int maxAttempts$6, QuasiTemporal T$5, FiniteDuration retryWait$5, Function1 failLog$5, AsynchronousFileChannel channel) {
        return this.retryOnFileLock$1(F$9, attemptLog$4, maxAttempts$6, T$5, retryWait$5, failLog$5, () -> this.acquireLock$1$$anonfun$1(P$1, channel));
    }

    private final Object allocate$$anonfun$1(QuasiIO F$17, String filename$3, Function0 lockAlreadyExistedLog$3) {
        return this.createChannel$1(F$17, filename$3, lockAlreadyExistedLog$3);
    }

    private static final void allocate$$anonfun$2$$anonfun$1$$anonfun$1(AsynchronousFileChannel channel$4) {
        channel$4.close();
    }

    private static final Object allocate$$anonfun$2$$anonfun$1(QuasiIO F$11, AsynchronousFileChannel channel$3) {
        return F$11.maybeSuspend((Function0 & Serializable)() -> {
            FileLockMutex$.allocate$$anonfun$2$$anonfun$1$$anonfun$1(channel$3);
            return BoxedUnit.UNIT;
        });
    }

    private final Object allocate$$anonfun$3$$anonfun$1(AsynchronousFileChannel channel$5, QuasiAsync P$3, QuasiIO F$13, Function2 attemptLog$5, int maxAttempts$7, QuasiTemporal T$6, FiniteDuration retryWait$6, Function1 failLog$6) {
        return this.acquireLock$1(P$3, F$13, attemptLog$5, maxAttempts$7, T$6, retryWait$6, failLog$6, channel$5);
    }

    private static final void allocate$$anonfun$3$$anonfun$2$$anonfun$1(FileLock lock$1) {
        lock$1.close();
    }
}

