/*
 * Decompiled with CFR 0.152.
 */
package izumi.fundamentals.platform.uuid;

import izumi.fundamentals.platform.uuid.IzUUID;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Random;
import java.util.UUID;
import scala.Function1;
import scala.Predef$;
import scala.jdk.CollectionConverters$;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.Scala3RunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public interface IzUUIDImpl
extends IzUUID {
    public static void $init$(IzUUIDImpl $this) {
        $this.izumi$fundamentals$platform$uuid$IzUUIDImpl$_setter_$izumi$fundamentals$platform$uuid$IzUUIDImpl$$START_EPOCH_$eq(-12219292800000L);
        $this.izumi$fundamentals$platform$uuid$IzUUIDImpl$_setter_$izumi$fundamentals$platform$uuid$IzUUIDImpl$$clockSeqAndNode_$eq($this.makeClockSeqAndNode());
        $this.izumi$fundamentals$platform$uuid$IzUUIDImpl$_setter_$izumi$fundamentals$platform$uuid$IzUUIDImpl$$MIN_CLOCK_SEQ_AND_NODE_$eq(-9187201950435737472L);
        $this.izumi$fundamentals$platform$uuid$IzUUIDImpl$_setter_$izumi$fundamentals$platform$uuid$IzUUIDImpl$$MAX_CLOCK_SEQ_AND_NODE_$eq(0x7F7F7F7F7F7F7F7FL);
        $this.izumi$fundamentals$platform$uuid$IzUUIDImpl$_setter_$izumi$fundamentals$platform$uuid$IzUUIDImpl$$secureRandom_$eq(new SecureRandom());
        if ($this.izumi$fundamentals$platform$uuid$IzUUIDImpl$$clockSeqAndNode() == 0L) {
            throw new RuntimeException("singleton instantiation is misplaced.");
        }
    }

    public long izumi$fundamentals$platform$uuid$IzUUIDImpl$$START_EPOCH();

    @Override
    public void izumi$fundamentals$platform$uuid$IzUUIDImpl$_setter_$izumi$fundamentals$platform$uuid$IzUUIDImpl$$START_EPOCH_$eq(long var1);

    public long izumi$fundamentals$platform$uuid$IzUUIDImpl$$clockSeqAndNode();

    @Override
    public void izumi$fundamentals$platform$uuid$IzUUIDImpl$_setter_$izumi$fundamentals$platform$uuid$IzUUIDImpl$$clockSeqAndNode_$eq(long var1);

    public long izumi$fundamentals$platform$uuid$IzUUIDImpl$$MIN_CLOCK_SEQ_AND_NODE();

    @Override
    public void izumi$fundamentals$platform$uuid$IzUUIDImpl$_setter_$izumi$fundamentals$platform$uuid$IzUUIDImpl$$MIN_CLOCK_SEQ_AND_NODE_$eq(long var1);

    public long izumi$fundamentals$platform$uuid$IzUUIDImpl$$MAX_CLOCK_SEQ_AND_NODE();

    @Override
    public void izumi$fundamentals$platform$uuid$IzUUIDImpl$_setter_$izumi$fundamentals$platform$uuid$IzUUIDImpl$$MAX_CLOCK_SEQ_AND_NODE_$eq(long var1);

    public SecureRandom izumi$fundamentals$platform$uuid$IzUUIDImpl$$secureRandom();

    @Override
    public void izumi$fundamentals$platform$uuid$IzUUIDImpl$_setter_$izumi$fundamentals$platform$uuid$IzUUIDImpl$$secureRandom_$eq(SecureRandom var1);

    public long izumi$fundamentals$platform$uuid$IzUUIDImpl$$lastNanos();

    public void izumi$fundamentals$platform$uuid$IzUUIDImpl$$lastNanos_$eq(long var1);

    private long createTimeSafe() {
        long l;
        IzUUIDImpl izUUIDImpl = this;
        synchronized (izUUIDImpl) {
            long nanosSince = (System.currentTimeMillis() - this.izumi$fundamentals$platform$uuid$IzUUIDImpl$$START_EPOCH()) * 10000L;
            if (nanosSince > this.izumi$fundamentals$platform$uuid$IzUUIDImpl$$lastNanos()) {
                this.izumi$fundamentals$platform$uuid$IzUUIDImpl$$lastNanos_$eq(nanosSince);
            } else {
                this.izumi$fundamentals$platform$uuid$IzUUIDImpl$$lastNanos_$eq(this.izumi$fundamentals$platform$uuid$IzUUIDImpl$$lastNanos() + 1L);
                nanosSince = this.izumi$fundamentals$platform$uuid$IzUUIDImpl$$lastNanos();
            }
            l = this.createTime(nanosSince);
        }
        return l;
    }

    private long createTimeUnsafe(long when) {
        return this.createTimeUnsafe(when, 0);
    }

    private long createTimeUnsafe(long when, int nanos) {
        long nanosSince = (when - this.izumi$fundamentals$platform$uuid$IzUUIDImpl$$START_EPOCH()) * 10000L + (long)nanos;
        return this.createTime(nanosSince);
    }

    public static UUID generateTimeUUID$(IzUUIDImpl $this) {
        return $this.generateTimeUUID();
    }

    @Override
    default public UUID generateTimeUUID() {
        return new UUID(this.createTimeSafe(), this.izumi$fundamentals$platform$uuid$IzUUIDImpl$$clockSeqAndNode());
    }

    public static UUID getTimeUUID$(IzUUIDImpl $this, long when) {
        return $this.getTimeUUID(when);
    }

    @Override
    default public UUID getTimeUUID(long when) {
        return new UUID(this.createTime(this.fromUnixTimestamp(when)), this.izumi$fundamentals$platform$uuid$IzUUIDImpl$$clockSeqAndNode());
    }

    public static UUID getTimeUUIDFromMicros$(IzUUIDImpl $this, long whenInMicros) {
        return $this.getTimeUUIDFromMicros(whenInMicros);
    }

    @Override
    default public UUID getTimeUUIDFromMicros(long whenInMicros) {
        long whenInMillis = whenInMicros / 1000L;
        long nanos = (whenInMicros - whenInMillis * 1000L) * 10L;
        return this.getTimeUUID(whenInMillis, nanos);
    }

    public static UUID getRandomTimeUUIDFromMicros$(IzUUIDImpl $this, long whenInMicros) {
        return $this.getRandomTimeUUIDFromMicros(whenInMicros);
    }

    @Override
    default public UUID getRandomTimeUUIDFromMicros(long whenInMicros) {
        long whenInMillis = whenInMicros / 1000L;
        long nanos = (whenInMicros - whenInMillis * 1000L) * 10L;
        return new UUID(this.createTime(this.fromUnixTimestamp(whenInMillis, nanos)), this.izumi$fundamentals$platform$uuid$IzUUIDImpl$$secureRandom().nextLong());
    }

    public static UUID getTimeUUID$(IzUUIDImpl $this, long when, long nanos) {
        return $this.getTimeUUID(when, nanos);
    }

    @Override
    default public UUID getTimeUUID(long when, long nanos) {
        return new UUID(this.createTime(this.fromUnixTimestamp(when, nanos)), this.izumi$fundamentals$platform$uuid$IzUUIDImpl$$clockSeqAndNode());
    }

    public static UUID getTimeUUID$(IzUUIDImpl $this, long when, long nanos, long clockSeqAndNode) {
        return $this.getTimeUUID(when, nanos, clockSeqAndNode);
    }

    @Override
    default public UUID getTimeUUID(long when, long nanos, long clockSeqAndNode) {
        return new UUID(this.createTime(this.fromUnixTimestamp(when, nanos)), clockSeqAndNode);
    }

    public static UUID getUUID$(IzUUIDImpl $this, ByteBuffer raw) {
        return $this.getUUID(raw);
    }

    @Override
    default public UUID getUUID(ByteBuffer raw) {
        return new UUID(raw.getLong(raw.position()), raw.getLong(raw.position() + 8));
    }

    public static byte[] decompose$(IzUUIDImpl $this, UUID uuid) {
        return $this.decompose(uuid);
    }

    @Override
    default public byte[] decompose(UUID uuid) {
        long most = uuid.getMostSignificantBits();
        long least = uuid.getLeastSignificantBits();
        byte[] b = new byte[16];
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 8).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            b$1[i] = (byte)(most >>> (7 - i) * 8);
            b$1[8 + i] = (byte)(least >>> (7 - i) * 8);
        });
        return b;
    }

    public static byte[] generateTimeUUIDBytes$(IzUUIDImpl $this) {
        return $this.generateTimeUUIDBytes();
    }

    @Override
    default public byte[] generateTimeUUIDBytes() {
        return this.createTimeUUIDBytes(this.createTimeSafe());
    }

    public static UUID minTimeUUID$(IzUUIDImpl $this, long timestamp) {
        return $this.minTimeUUID(timestamp);
    }

    @Override
    default public UUID minTimeUUID(long timestamp) {
        return new UUID(this.createTime(this.fromUnixTimestamp(timestamp)), this.izumi$fundamentals$platform$uuid$IzUUIDImpl$$MIN_CLOCK_SEQ_AND_NODE());
    }

    public static UUID maxTimeUUID$(IzUUIDImpl $this, long timestamp) {
        return $this.maxTimeUUID(timestamp);
    }

    @Override
    default public UUID maxTimeUUID(long timestamp) {
        long uuidTstamp = this.fromUnixTimestamp(timestamp + 1L) - 1L;
        return new UUID(this.createTime(uuidTstamp), this.izumi$fundamentals$platform$uuid$IzUUIDImpl$$MAX_CLOCK_SEQ_AND_NODE());
    }

    public static long unixTimestamp$(IzUUIDImpl $this, UUID uuid) {
        return $this.unixTimestamp(uuid);
    }

    @Override
    default public long unixTimestamp(UUID uuid) {
        return uuid.timestamp() / 10000L + this.izumi$fundamentals$platform$uuid$IzUUIDImpl$$START_EPOCH();
    }

    public static long microsTimestamp$(IzUUIDImpl $this, UUID uuid) {
        return $this.microsTimestamp(uuid);
    }

    @Override
    default public long microsTimestamp(UUID uuid) {
        return uuid.timestamp() / 10L + this.izumi$fundamentals$platform$uuid$IzUUIDImpl$$START_EPOCH() * 1000L;
    }

    private long fromUnixTimestamp(long timestamp) {
        return this.fromUnixTimestamp(timestamp, 0L);
    }

    private long fromUnixTimestamp(long timestamp, long nanos) {
        return (timestamp - this.izumi$fundamentals$platform$uuid$IzUUIDImpl$$START_EPOCH()) * 10000L + nanos;
    }

    public static byte[] getTimeUUIDBytes$(IzUUIDImpl $this, long timeMillis) {
        return $this.getTimeUUIDBytes(timeMillis);
    }

    @Override
    default public byte[] getTimeUUIDBytes(long timeMillis) {
        return this.createTimeUUIDBytes(this.createTimeUnsafe(timeMillis));
    }

    public static byte[] getTimeUUIDBytes$(IzUUIDImpl $this, long timeMillis, int nanos) {
        return $this.getTimeUUIDBytes(timeMillis, nanos);
    }

    @Override
    default public byte[] getTimeUUIDBytes(long timeMillis, int nanos) {
        if (nanos >= 10000) {
            throw new IllegalArgumentException();
        }
        return this.createTimeUUIDBytes(this.createTimeUnsafe(timeMillis, nanos));
    }

    private byte[] createTimeUUIDBytes(long msb) {
        long lsb = this.izumi$fundamentals$platform$uuid$IzUUIDImpl$$clockSeqAndNode();
        byte[] uuidBytes = new byte[16];
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 8).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            uuidBytes$1[i] = (byte)(msb >>> 8 * (7 - i));
        });
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(8), 16).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            uuidBytes$2[i] = (byte)(lsb >>> 8 * (7 - i));
        });
        return uuidBytes;
    }

    public static long getAdjustedTimestamp$(IzUUIDImpl $this, UUID uuid) {
        return $this.getAdjustedTimestamp(uuid);
    }

    @Override
    default public long getAdjustedTimestamp(UUID uuid) {
        if (uuid.version() != 1) {
            throw new IllegalArgumentException(new StringBuilder(32).append("incompatible with uuid version: ").append(uuid.version()).toString());
        }
        return uuid.timestamp() / 10000L + this.izumi$fundamentals$platform$uuid$IzUUIDImpl$$START_EPOCH();
    }

    private long makeClockSeqAndNode() {
        long clock = new Random(System.currentTimeMillis()).nextLong();
        long lsb = 0L;
        lsb |= Long.MIN_VALUE;
        lsb |= (clock & 0x3FFFL) << 48;
        return lsb |= this.makeNode();
    }

    private long createTime(long nanosSince) {
        long msb = 0L;
        msb |= (0xFFFFFFFFL & nanosSince) << 32;
        msb |= (0xFFFF00000000L & nanosSince) >>> 16;
        msb |= (0xFFFF000000000000L & nanosSince) >>> 48;
        return msb |= 0x1000L;
    }

    private Collection<InetAddress> getAllLocalAddresses() {
        HashSet<InetAddress> localAddresses = new HashSet<InetAddress>();
        Enumeration<NetworkInterface> nets = NetworkInterface.getNetworkInterfaces();
        while (nets.hasMoreElements()) {
            localAddresses.addAll(Collections.list(nets.nextElement().getInetAddresses()));
        }
        return localAddresses;
    }

    private long makeNode() {
        Collection<InetAddress> localAddresses = this.getAllLocalAddresses();
        if (localAddresses.isEmpty()) {
            throw new RuntimeException("Cannot generate the node component of the UUID because cannot retrieve any IP addresses.");
        }
        byte[] hash = this.doHash(localAddresses);
        LongRef node = LongRef.create((long)0L);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), Math.min(6, hash.length)).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> node$1.elem |= (0xFFL & (long)hash[i]) << (5 - i) * 8);
        if ((0xFF00000000000000L & node.elem) != 0L) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        return node.elem | 0x10000000000L;
    }

    private byte[] doHash(Collection<InetAddress> data) {
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        CollectionConverters$.MODULE$.CollectionHasAsScala(data).asScala().foreach((Function1)(JProcedure1 & Serializable)addr -> messageDigest.update(addr.getAddress()));
        return messageDigest.digest();
    }
}

