/*
 * Decompiled with CFR 0.152.
 */
package izumi.fundamentals.graphs.dotml;

import izumi.fundamentals.graphs.dotml.GraphVizDotML$;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;

public abstract class GraphVizDotML {
    private String name;
    private String comment;
    private boolean strict;
    private Map graphAttr;
    private Map nodeAttr;
    private Map edgeAttr;
    private final ArrayBuffer body;
    private final String _comment;
    private final String _subgraph;
    private final String _node;
    private final String _tail;
    private final Regex HTML_STRING;

    public static String $lessinit$greater$default$1() {
        return GraphVizDotML$.MODULE$.$lessinit$greater$default$1();
    }

    public static String $lessinit$greater$default$2() {
        return GraphVizDotML$.MODULE$.$lessinit$greater$default$2();
    }

    public static boolean $lessinit$greater$default$3() {
        return GraphVizDotML$.MODULE$.$lessinit$greater$default$3();
    }

    public static Map<String, String> $lessinit$greater$default$4() {
        return GraphVizDotML$.MODULE$.$lessinit$greater$default$4();
    }

    public static Map<String, String> $lessinit$greater$default$5() {
        return GraphVizDotML$.MODULE$.$lessinit$greater$default$5();
    }

    public static Map<String, String> $lessinit$greater$default$6() {
        return GraphVizDotML$.MODULE$.$lessinit$greater$default$6();
    }

    public static ArrayBuffer<String> $lessinit$greater$default$7() {
        return GraphVizDotML$.MODULE$.$lessinit$greater$default$7();
    }

    public GraphVizDotML(String name, String comment, boolean strict, Map<String, String> graphAttr, Map<String, String> nodeAttr, Map<String, String> edgeAttr, ArrayBuffer<String> body) {
        this.name = name;
        this.comment = comment;
        this.strict = strict;
        this.graphAttr = graphAttr;
        this.nodeAttr = nodeAttr;
        this.edgeAttr = edgeAttr;
        this.body = body;
        this._comment = "// %s";
        this._subgraph = "subgraph %s{";
        this._node = "\t%s %s";
        this._tail = "}";
        this.HTML_STRING = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("</?\\w+((\\s+\\w+(\\s*=\\s*(?:\".*?\"|'.*?'|[\\^'\">\\s]+))?)+\\s*|\\s*)/?>"));
    }

    public String name() {
        return this.name;
    }

    public void name_$eq(String x$1) {
        this.name = x$1;
    }

    public String comment() {
        return this.comment;
    }

    public void comment_$eq(String x$1) {
        this.comment = x$1;
    }

    public boolean strict() {
        return this.strict;
    }

    public void strict_$eq(boolean x$1) {
        this.strict = x$1;
    }

    public Map<String, String> graphAttr() {
        return this.graphAttr;
    }

    public void graphAttr_$eq(Map<String, String> x$1) {
        this.graphAttr = x$1;
    }

    public Map<String, String> nodeAttr() {
        return this.nodeAttr;
    }

    public void nodeAttr_$eq(Map<String, String> x$1) {
        this.nodeAttr = x$1;
    }

    public Map<String, String> edgeAttr() {
        return this.edgeAttr;
    }

    public void edgeAttr_$eq(Map<String, String> x$1) {
        this.edgeAttr = x$1;
    }

    public ArrayBuffer<String> body() {
        return this.body;
    }

    public abstract String _head();

    public abstract String _edge();

    public abstract String _edgePlain();

    public String _comment() {
        return this._comment;
    }

    public String _subgraph() {
        return this._subgraph;
    }

    public String _node() {
        return this._node;
    }

    public String _tail() {
        return this._tail;
    }

    public Regex HTML_STRING() {
        return this.HTML_STRING;
    }

    public String quote(String identifier) {
        if (this.HTML_STRING().findAllMatchIn((CharSequence)identifier).length() <= 0) {
            String result = identifier;
            if (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(result), 0) != '\"') {
                result = new StringBuilder(1).append("\"").append(result).toString();
            }
            if (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(result), result.length() - 1) != '\"') {
                result = new StringBuilder(1).append(result).append("\"").toString();
            }
            return result;
        }
        return identifier;
    }

    public String attribute(String label, Map<String, String> attrs) {
        Map tmpAttr;
        Map map = tmpAttr = attrs == null ? (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0])) : attrs;
        if (label != null) {
            return new StringBuilder(8).append("[label=").append(this.quote(label)).append(" ").append(new StringBuilder(1).append(tmpAttr.foldLeft((Object)"", (Function2 & Serializable)(acc, elem) -> new StringBuilder(2).append((String)acc).append(" ").append(elem._1()).append("=").append(this.quote((String)elem._2())).toString())).append("]").toString()).toString();
        }
        return new StringBuilder(2).append("[").append(tmpAttr.foldLeft((Object)"", (Function2 & Serializable)(acc, elem) -> new StringBuilder(2).append((String)acc).append(" ").append(elem._1()).append("=").append(this.quote((String)elem._2())).toString())).append("]").toString();
    }

    public String attribute$default$1() {
        return null;
    }

    public Map<String, String> attribute$default$2() {
        return null;
    }

    public void node(String name, String label, Map<String, String> attrs) {
        this.body().$plus$eq((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(this._node()), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.quote(name), this.attribute(label, attrs)})));
    }

    public String node$default$2() {
        return null;
    }

    public Map<String, String> node$default$3() {
        return null;
    }

    public void edge(String tailName, String headName, String label, Map<String, String> attrs) {
        this.body().$plus$eq((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(this._edge()), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.quote(tailName), this.quote(headName), this.attribute(label, attrs)})));
    }

    public String edge$default$3() {
        return null;
    }

    public Map<String, String> edge$default$4() {
        return null;
    }

    public void edges(String tailName, String[] headNames) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])headNames);
        this.edges((Tuple2[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)h -> Tuple2$.MODULE$.apply((Object)tailName, h), ClassTag$.MODULE$.apply(Tuple2.class)));
    }

    public void edges(Tuple2<String, String>[] tailHeads) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])tailHeads);
        ArrayOps$.MODULE$.withFilter$extension(object, (Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String t = (String)tuple2._1();
                String h = (String)tuple2._2();
                return true;
            }
            return false;
        }).foreach((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String t = (String)tuple2._1();
                String h = (String)tuple2._2();
                return (ArrayBuffer)this.body().$plus$eq((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(this._edgePlain()), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{t, h})));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public void attr(String kw, Map<String, String> attrs) {
        List list = (List)new .colon.colon((Object)"graph", (List)new .colon.colon((Object)"node", (List)new .colon.colon((Object)"edge", (List)Nil$.MODULE$)));
        Predef$.MODULE$.require(list.contains((Object)kw.toLowerCase()), () -> GraphVizDotML.attr$$anonfun$1(kw));
        String line = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\t%s %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{kw, this.attribute(null, attrs)}));
        this.body().$plus$eq((Object)line);
    }

    public Map<String, String> attr$default$2() {
        return null;
    }

    public String source(boolean subGraph) {
        boolean styled;
        String sj;
        ArrayBuffer result = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        String string = sj = subGraph ? "\t" : "";
        if (this.comment() != null) {
            result.$plus$eq((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(this._comment()), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.comment()})));
        }
        String head = subGraph ? this._subgraph() : this._head();
        String na = this.name() != null ? new StringBuilder(1).append(this.name()).append(" ").toString() : "";
        ArrayBuffer arrayBuffer = this.strict() ? (ArrayBuffer)result.$plus$eq((Object)new StringBuilder(7).append(sj).append("strict ").append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(head), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{na}))).toString()) : (ArrayBuffer)result.$plus$eq((Object)new StringBuilder(0).append(sj).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(head), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{na}))).toString());
        boolean bl = styled = this.graphAttr().nonEmpty() || this.nodeAttr().nonEmpty() || this.edgeAttr().nonEmpty();
        if (this.graphAttr().nonEmpty()) {
            result.$plus$eq((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(new StringBuilder(6).append(sj).append("\t%s %s").toString()), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"graph", this.attribute(null, this.graphAttr())})));
        }
        if (this.nodeAttr().nonEmpty()) {
            result.$plus$eq((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(new StringBuilder(6).append(sj).append("\t%s %s").toString()), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"node", this.attribute(null, this.nodeAttr())})));
        }
        if (this.edgeAttr().nonEmpty()) {
            result.$plus$eq((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(new StringBuilder(6).append(sj).append("\t%s %s").toString()), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"edge", this.attribute(null, this.edgeAttr())})));
        }
        String indent = styled ? "\t" : "";
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.body().toArray(ClassTag$.MODULE$.apply(String.class)));
        ArrayOps$.MODULE$.foreach$extension(object, (Function1 & Serializable)l -> (ArrayBuffer)result.$plus$eq((Object)new StringBuilder(0).append(sj).append(indent).append((String)l).toString()));
        result.$plus$eq((Object)new StringBuilder(0).append(sj).append(this._tail()).toString());
        return Predef$.MODULE$.wrapRefArray((Object[])result.toArray(ClassTag$.MODULE$.apply(String.class))).mkString("\n");
    }

    public boolean source$default$1() {
        return false;
    }

    public void subGraph(GraphVizDotML graph) {
        Class<?> clazz = this.getClass();
        Class<?> clazz2 = graph.getClass();
        Predef$.MODULE$.require(!(clazz != null ? !clazz.equals(clazz2) : clazz2 != null), GraphVizDotML::subGraph$$anonfun$1);
        this.body().$plus$eq((Object)graph.source(true));
    }

    public String save(String fileName, String directory) {
        String path = new StringBuilder(0).append(directory).append(File.separator).append(fileName).toString();
        try (PrintWriter writer = new PrintWriter(path);){
            String data = this.source(this.source$default$1());
            writer.println(data);
            writer.flush();
        }
        return path;
    }

    private static final Object attr$$anonfun$1(String kw$1) {
        return new StringBuilder(49).append("attr statement must target graph, node, or edge: ").append(kw$1).toString();
    }

    private static final Object subGraph$$anonfun$1() {
        return "cannot add subgraphs of different kind";
    }
}

