/*
 * Decompiled with CFR 0.152.
 */
package izumi.fundamentals.graphs.tools;

import izumi.fundamentals.graphs.ToposortError;
import izumi.fundamentals.graphs.ToposortError$InconsistentInput$;
import izumi.fundamentals.graphs.ToposortError$UnexpectedLoop$;
import izumi.fundamentals.graphs.struct.IncidenceMatrix$;
import izumi.fundamentals.graphs.tools.ToposortLoopBreaker$;
import izumi.fundamentals.graphs.tools.ToposortLoopBreaker$ResolvedLoop$;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

public interface ToposortLoopBreaker<T> {
    public static <T> ToposortLoopBreaker<T> breakOn(Function1<Set<T>, Option<T>> function1) {
        return ToposortLoopBreaker$.MODULE$.breakOn(function1);
    }

    public static <T> ToposortLoopBreaker<T> dontBreak() {
        return ToposortLoopBreaker$.MODULE$.dontBreak();
    }

    public Either<ToposortError<T>, ResolvedLoop<T>> onLoop(Seq<T> var1, Map<T, Set<T>> var2);

    public static final class ResolvedLoop<T>
    implements Product,
    Serializable {
        private final Set breakAt;

        public static <T> Set apply(Set<T> set) {
            return ToposortLoopBreaker$ResolvedLoop$.MODULE$.apply(set);
        }

        public static <T> Set unapply(Set set) {
            return ToposortLoopBreaker$ResolvedLoop$.MODULE$.unapply(set);
        }

        public static <T> Set<T> _1$extension(Set set) {
            return ToposortLoopBreaker$ResolvedLoop$.MODULE$._1$extension(set);
        }

        public static <T> boolean canEqual$extension(Set set, Object object) {
            return ToposortLoopBreaker$ResolvedLoop$.MODULE$.canEqual$extension(set, object);
        }

        public static <T, T> Set copy$extension(Set set, Set<T> set2) {
            return ToposortLoopBreaker$ResolvedLoop$.MODULE$.copy$extension(set, set2);
        }

        public static <T> boolean equals$extension(Set set, Object object) {
            return ToposortLoopBreaker$ResolvedLoop$.MODULE$.equals$extension(set, object);
        }

        public static <T> int hashCode$extension(Set set) {
            return ToposortLoopBreaker$ResolvedLoop$.MODULE$.hashCode$extension(set);
        }

        public static <T> int productArity$extension(Set set) {
            return ToposortLoopBreaker$ResolvedLoop$.MODULE$.productArity$extension(set);
        }

        public static <T> Object productElement$extension(Set set, int n) {
            return ToposortLoopBreaker$ResolvedLoop$.MODULE$.productElement$extension(set, n);
        }

        public static <T> String productElementName$extension(Set set, int n) {
            return ToposortLoopBreaker$ResolvedLoop$.MODULE$.productElementName$extension(set, n);
        }

        public static <T> String productPrefix$extension(Set set) {
            return ToposortLoopBreaker$ResolvedLoop$.MODULE$.productPrefix$extension(set);
        }

        public static <T> String toString$extension(Set set) {
            return ToposortLoopBreaker$ResolvedLoop$.MODULE$.toString$extension(set);
        }

        public static <T, T> Set<T> copy$default$1$extension(Set set) {
            return ToposortLoopBreaker$ResolvedLoop$.MODULE$.copy$default$1$extension(set);
        }

        public ResolvedLoop(Set<T> breakAt) {
            this.breakAt = breakAt;
        }

        public int hashCode() {
            return ToposortLoopBreaker$ResolvedLoop$.MODULE$.hashCode$extension(this.breakAt());
        }

        public boolean equals(Object x$0) {
            return ToposortLoopBreaker$ResolvedLoop$.MODULE$.equals$extension(this.breakAt(), x$0);
        }

        public String toString() {
            return ToposortLoopBreaker$ResolvedLoop$.MODULE$.toString$extension(this.breakAt());
        }

        public boolean canEqual(Object that) {
            return ToposortLoopBreaker$ResolvedLoop$.MODULE$.canEqual$extension(this.breakAt(), that);
        }

        public int productArity() {
            return ToposortLoopBreaker$ResolvedLoop$.MODULE$.productArity$extension(this.breakAt());
        }

        public String productPrefix() {
            return ToposortLoopBreaker$ResolvedLoop$.MODULE$.productPrefix$extension(this.breakAt());
        }

        public Object productElement(int n) {
            return ToposortLoopBreaker$ResolvedLoop$.MODULE$.productElement$extension(this.breakAt(), n);
        }

        public String productElementName(int n) {
            return ToposortLoopBreaker$ResolvedLoop$.MODULE$.productElementName$extension(this.breakAt(), n);
        }

        public Set<T> breakAt() {
            return this.breakAt;
        }

        public <T> Set copy(Set<T> breakAt) {
            return ToposortLoopBreaker$ResolvedLoop$.MODULE$.copy$extension(this.breakAt(), breakAt);
        }

        public <T> Set<T> copy$default$1() {
            return ToposortLoopBreaker$ResolvedLoop$.MODULE$.copy$default$1$extension(this.breakAt());
        }

        public Set<T> _1() {
            return ToposortLoopBreaker$ResolvedLoop$.MODULE$._1$extension(this.breakAt());
        }
    }

    public static abstract class SingleElementBreaker<T>
    implements ToposortLoopBreaker<T> {
        public abstract Option<T> find(Seq<T> var1, Map<T, Set<T>> var2);

        @Override
        public final Either<ToposortError<T>, ResolvedLoop<T>> onLoop(Seq<T> done, Map<T, Set<T>> hasPreds) {
            Map loopMembers = hasPreds.view().filterKeys((Function1 & Serializable)key -> this.isInvolvedIntoCycle(hasPreds, key)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            if (loopMembers.nonEmpty()) {
                Option<T> option = this.find(done, loopMembers);
                if (option instanceof Some) {
                    Object breakLoopAt = ((Some)option).value();
                    Set found = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{breakLoopAt}));
                    return package$.MODULE$.Right().apply(new ResolvedLoop(ToposortLoopBreaker$ResolvedLoop$.MODULE$.apply(found)));
                }
                if (None$.MODULE$.equals(option)) {
                    return package$.MODULE$.Left().apply(ToposortError$UnexpectedLoop$.MODULE$.apply(done, IncidenceMatrix$.MODULE$.apply(loopMembers)));
                }
                throw new MatchError(option);
            }
            return package$.MODULE$.Left().apply(ToposortError$InconsistentInput$.MODULE$.apply(IncidenceMatrix$.MODULE$.apply(hasPreds)));
        }

        private boolean isInvolvedIntoCycle(Map<T, Set<T>> toPreds, T key) {
            return this.test(toPreds, Predef$.MODULE$.Set().empty(), key, key);
        }

        private boolean test(Map<T, Set<T>> toPreds, Set<T> stack, T toTest, T needle) {
            Set deps = (Set)toPreds.getOrElse(toTest, ToposortLoopBreaker$::izumi$fundamentals$graphs$tools$ToposortLoopBreaker$SingleElementBreaker$$_$_$$anonfun$2);
            if (deps.contains(needle)) {
                return true;
            }
            return deps.exists((Function1 & Serializable)d -> {
                if (stack.contains(d)) {
                    return false;
                }
                return this.test(toPreds, (Set)stack.$plus(d), d, needle);
            });
        }
    }
}

