/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.platform;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import io.ably.lib.transport.NetworkConnectivity;
import io.ably.lib.types.ErrorInfo;
import java.util.WeakHashMap;

public class AndroidNetworkConnectivity
extends NetworkConnectivity {
    private final Context applicationContext;
    private NetworkStateReceiver networkStateReceiver;
    private static WeakHashMap<Context, AndroidNetworkConnectivity> contexts = new WeakHashMap();

    AndroidNetworkConnectivity(Context applicationContext) {
        this.applicationContext = applicationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AndroidNetworkConnectivity getNetworkConnectivity(Context applicationContext) {
        AndroidNetworkConnectivity networkConnectivity;
        WeakHashMap<Context, AndroidNetworkConnectivity> weakHashMap = contexts;
        synchronized (weakHashMap) {
            networkConnectivity = contexts.get(applicationContext);
            if (networkConnectivity == null) {
                networkConnectivity = new AndroidNetworkConnectivity(applicationContext);
                contexts.put(applicationContext, networkConnectivity);
            }
        }
        return networkConnectivity;
    }

    @Override
    protected void onNonempty() {
        this.activate();
    }

    @Override
    protected void onEmpty() {
        this.deactivate();
    }

    private void activate() {
        if (this.networkStateReceiver == null && this.applicationContext != null) {
            this.networkStateReceiver = new NetworkStateReceiver();
            this.applicationContext.registerReceiver((BroadcastReceiver)this.networkStateReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        }
    }

    private void deactivate() {
        if (this.networkStateReceiver != null) {
            this.applicationContext.unregisterReceiver((BroadcastReceiver)this.networkStateReceiver);
            this.networkStateReceiver = null;
        }
    }

    private class NetworkStateReceiver
    extends BroadcastReceiver {
        public void onReceive(Context context, Intent intent) {
            if (intent == null || intent.getExtras() == null) {
                return;
            }
            ConnectivityManager manager = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo ni = manager.getActiveNetworkInfo();
            if (ni != null && ni.getState() == NetworkInfo.State.CONNECTED) {
                AndroidNetworkConnectivity.this.notifyNetworkAvailable();
            } else if (intent.getBooleanExtra("noConnectivity", Boolean.FALSE.booleanValue())) {
                AndroidNetworkConnectivity.this.notifyNetworkUnavailable(new ErrorInfo("No network connection available", 503, 80003));
            }
        }
    }
}

