/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.transport;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class SafeSSLSocketFactory
extends SSLSocketFactory {
    private final String[] SAFE_PROTOCOLS = new String[]{"TLSv1.2", "TLSv1.3"};
    private final SSLSocketFactory factory;

    public SafeSSLSocketFactory(SSLSocketFactory factory) {
        this.factory = factory;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.factory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.factory.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket() throws IOException {
        return this.getSocketWithOnlySafeProtocolsEnabled(this.factory.createSocket());
    }

    @Override
    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
        return this.getSocketWithOnlySafeProtocolsEnabled(this.factory.createSocket(socket, host, port, autoClose));
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return this.getSocketWithOnlySafeProtocolsEnabled(this.factory.createSocket(host, port));
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        return this.getSocketWithOnlySafeProtocolsEnabled(this.factory.createSocket(host, port, localHost, localPort));
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        return this.getSocketWithOnlySafeProtocolsEnabled(this.factory.createSocket(host, port));
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.getSocketWithOnlySafeProtocolsEnabled(this.factory.createSocket(address, port, localAddress, localPort));
    }

    private Socket getSocketWithOnlySafeProtocolsEnabled(Socket socket) {
        if (!(socket instanceof SSLSocket)) {
            throw new IllegalArgumentException("The socket is not an instance of the SSL socket");
        }
        SSLSocket sslSocket = (SSLSocket)socket;
        HashSet<String> allSupportedProtocols = new HashSet<String>(Arrays.asList(sslSocket.getSupportedProtocols()));
        ArrayList<String> safeSupportedProtocols = new ArrayList<String>();
        for (String safeProtocol : this.SAFE_PROTOCOLS) {
            if (!allSupportedProtocols.contains(safeProtocol)) continue;
            safeSupportedProtocols.add(safeProtocol);
        }
        if (safeSupportedProtocols.isEmpty()) {
            throw new SecurityException("No safe protocol version is supported for this SSL socket");
        }
        sslSocket.setEnabledProtocols(safeSupportedProtocols.toArray(new String[0]));
        return sslSocket;
    }
}

