/*
 * Decompiled with CFR 0.152.
 */
package io.accelerate.challenge.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.util.List;
import java.util.Map;

public class ParamAccessor {
    private final JsonNode jsonNode;
    private final ObjectMapper objectMapper;

    public ParamAccessor(JsonNode jsonNode) {
        this.jsonNode = jsonNode;
        this.objectMapper = ((JsonMapper.Builder)JsonMapper.builder().configure(MapperFeature.ALLOW_COERCION_OF_SCALARS, false)).build();
    }

    public String getAsString() {
        return this.getAsObject(String.class);
    }

    public Integer getAsInteger() {
        return this.getAsObject(Integer.class);
    }

    public <T> List<T> getAsListOf(Class<T> classType) {
        try {
            return (List)this.objectMapper.treeToValue((TreeNode)this.jsonNode, new TypeReference<List<T>>(this){});
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to deserialize jsonNode to List of " + classType.getName(), e);
        }
    }

    public <T> Map<String, T> getAsMapOf(Class<T> classType) {
        try {
            return (Map)this.objectMapper.treeToValue((TreeNode)this.jsonNode, new TypeReference<Map<String, T>>(this){});
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to deserialize jsonNode to Map of " + classType.getName(), e);
        }
    }

    public <T> T getAsObject(Class<T> itemClass) {
        try {
            return (T)this.objectMapper.treeToValue((TreeNode)this.jsonNode, itemClass);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to deserialize jsonNode to " + itemClass.getName(), e);
        }
    }
}

