/*
 * Decompiled with CFR 0.152.
 */
package io.accelerate.challenge.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.accelerate.challenge.client.ImplementationMap;
import io.accelerate.challenge.client.ParamAccessor;
import io.accelerate.challenge.client.ReferenceSolution;
import io.accelerate.challenge.client.RequestFromServer;
import io.accelerate.challenge.client.ResponseToServer;
import io.accelerate.challenge.client.UserImplementation;
import java.util.List;

public class ReferenceClient {
    public ResponseToServer respondToRequest(RequestFromServer requestFromServer, ReferenceSolution referenceSolution) {
        String requestId = requestFromServer.requestId();
        String methodName = requestFromServer.methodName();
        ParamAccessor[] serializedParams = this.serializeAndDeserializeArgs(requestFromServer);
        ImplementationMap implementations = referenceSolution.participantUpdatesImplementationMap();
        UserImplementation userImplementation = implementations.getImplementationFor(methodName);
        Object actualReturnedValue = userImplementation.process(serializedParams);
        return new ResponseToServer(requestId, actualReturnedValue);
    }

    private ParamAccessor[] serializeAndDeserializeArgs(RequestFromServer requestFromServer) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            Object[] originalArgs = requestFromServer.args().toArray();
            String serializedArgs = objectMapper.writeValueAsString((Object)originalArgs);
            List elements = (List)objectMapper.readValue(serializedArgs, (TypeReference)new TypeReference<List<JsonNode>>(this){});
            ParamAccessor[] paramAccessors = new ParamAccessor[elements.size()];
            for (int i = 0; i < elements.size(); ++i) {
                paramAccessors[i] = new ParamAccessor((JsonNode)elements.get(i));
            }
            return paramAccessors;
        }
        catch (Exception e) {
            throw new RuntimeException("Error during serialization and deserialization of params", e);
        }
    }
}

