/*
 * Decompiled with CFR 0.152.
 */
package io.accelerate.tracking.sync.credentials;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3AsyncClientBuilder;

public class AWSSecretProperties {
    private final Properties privateProperties;

    private AWSSecretProperties(Properties privateProperties) {
        this.privateProperties = privateProperties;
    }

    public static AWSSecretProperties fromPlainTextFile(Path plainTextPropertyFile) {
        return new AWSSecretProperties(AWSSecretProperties.loadPrivateProperties(plainTextPropertyFile));
    }

    public static AWSSecretProperties fromProperties(Properties privateProperties) {
        return new AWSSecretProperties(privateProperties);
    }

    public S3AsyncClient createClient() {
        String awsAccessKeyId = this.privateProperties.getProperty("aws_access_key_id");
        String awsSecretAccessKey = this.privateProperties.getProperty("aws_secret_access_key");
        String awsSessionToken = this.privateProperties.getProperty("aws_session_token");
        String s3Region = this.privateProperties.getProperty("s3_region");
        AwsBasicCredentials awsCredentials = awsSessionToken != null && !awsSessionToken.isBlank() ? AwsSessionCredentials.create((String)awsAccessKeyId, (String)awsSecretAccessKey, (String)awsSessionToken) : AwsBasicCredentials.create((String)awsAccessKeyId, (String)awsSecretAccessKey);
        return (S3AsyncClient)((S3AsyncClientBuilder)((S3AsyncClientBuilder)S3AsyncClient.builder().credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)awsCredentials))).region(Region.of((String)s3Region))).build();
    }

    public String getS3Bucket() {
        return this.privateProperties.getProperty("s3_bucket");
    }

    public String getS3Prefix() {
        return this.privateProperties.getProperty("s3_prefix");
    }

    private static Properties loadPrivateProperties(Path privatePropertiesPath) {
        Properties properties;
        block8: {
            Properties properties2 = new Properties();
            InputStream inStream = Files.newInputStream(privatePropertiesPath, new OpenOption[0]);
            try {
                properties2.load(inStream);
                properties = properties2;
                if (inStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inStream != null) {
                        try {
                            inStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
            inStream.close();
        }
        return properties;
    }
}

