/*
 * Decompiled with CFR 0.152.
 */
package io.accelerate.tracking.sync.helpers;

import java.io.File;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public final class FileHelper {
    private FileHelper() {
    }

    public static boolean lockFileExists(File file) {
        Path lockFilePath = FileHelper.getLockFilePath(file);
        return Files.exists(lockFilePath, new LinkOption[0]);
    }

    public static Path getLockFilePath(File file) {
        String lockFileName = file.getName() + ".lock";
        Path fileDirectory = file.toPath().toAbsolutePath().normalize().getParent();
        return fileDirectory.resolve(lockFileName);
    }

    public static String getRelativeFilePathToCwd(File file) {
        URI baseUri = Paths.get(".", new String[0]).toUri();
        URI fileUri = file.toURI();
        URI relativeUri = baseUri.relativize(fileUri);
        return relativeUri.getPath();
    }
}

