/*
 * Decompiled with CFR 0.152.
 */
package io.accelerate.tracking.sync.sync;

import io.accelerate.tracking.sync.sync.Filter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public class Filters {
    private final List<Filter> includes = new ArrayList<Filter>();
    private final List<Filter> excludes = new ArrayList<Filter>();

    private Filters() {
        this.exclude(Filters.getDefaultLockFilter());
    }

    public static Builder getBuilder() {
        return new Builder();
    }

    public final void exclude(Filter filter) {
        this.excludes.add(filter);
    }

    public final void include(Filter filter) {
        this.includes.add(filter);
    }

    public boolean accept(Path path) {
        boolean accept = this.includes.stream().anyMatch(e -> e.accept(path));
        boolean reject = this.excludes.stream().anyMatch(e -> e.accept(path));
        return accept && !reject;
    }

    public static final Filter getDefaultLockFilter() {
        return path -> path.getFileName().toString().endsWith(".lock");
    }

    public static final Filter endsWith(String string) {
        return path -> path.getFileName().toString().endsWith(string);
    }

    public static final Filter startsWith(String string) {
        return path -> path.getFileName().toString().startsWith(string);
    }

    public static final Filter matches(String regex) {
        return path -> path.getFileName().toString().matches(regex);
    }

    public static final Filter name(String name) {
        return path -> path.getFileName().toString().equals(name);
    }

    public static class Builder {
        private final Filters filters = new Filters();

        public Filters create() {
            if (this.filters.includes.isEmpty()) {
                throw new RuntimeException("No filters for inclusion found.");
            }
            return this.filters;
        }

        public final Builder exclude(Filter filter) {
            this.filters.exclude(filter);
            return this;
        }

        public final Builder include(Filter filter) {
            this.filters.include(filter);
            return this;
        }
    }
}

