/*
 * Decompiled with CFR 0.152.
 */
package io.accelerate.tracking.sync.sync;

import io.accelerate.tracking.sync.sync.Source;
import io.accelerate.tracking.sync.sync.progress.ProgressListener;
import io.accelerate.tracking.sync.upload.FileUploadingService;
import java.io.File;
import java.util.List;

class FolderSynchronizer {
    private final Source sourceFolder;
    private final FileUploadingService fileUploadingService;

    FolderSynchronizer(Source sourceFolder, FileUploadingService fileUploadingService) {
        this.sourceFolder = sourceFolder;
        this.fileUploadingService = fileUploadingService;
    }

    void synchronize() {
        List<String> paths = this.sourceFolder.getFilesToUpload();
        paths.forEach(filePath -> {
            File folder = this.sourceFolder.getPath().toFile();
            File uploadFile = new File(folder, (String)filePath);
            this.fileUploadingService.upload(uploadFile, (String)filePath);
        });
    }

    void setListener(ProgressListener listener) {
        this.fileUploadingService.setListener(listener);
    }
}

