/*
 * Decompiled with CFR 0.152.
 */
package io.accelerate.tracking.sync.sync;

import io.accelerate.tracking.sync.sync.Filters;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;

public class Source {
    private Path path;
    private boolean isRecursive;
    private Filters filters;

    public static Builder getBuilder(Path path) {
        return new Builder(path);
    }

    public Path getPath() {
        return this.path;
    }

    public Filters getFilters() {
        return this.filters;
    }

    public boolean isRecursive() {
        return this.isRecursive;
    }

    public boolean isValidPath() {
        File file = this.path.toFile();
        return file.isDirectory();
    }

    public List<String> getFilesToUpload() {
        try {
            int maxDepth = this.isRecursive ? Integer.MAX_VALUE : 1;
            File base = this.path.toFile();
            BiPredicate<Path, BasicFileAttributes> matcher = (filePath, fileAttr) -> fileAttr.isRegularFile() && this.filters.accept((Path)filePath);
            return Files.find(this.path, maxDepth, matcher, new FileVisitOption[0]).map(filePath -> base.toURI().relativize(filePath.toFile().toURI()).getPath()).collect(Collectors.toList());
        }
        catch (IOException ex) {
            return new ArrayList<String>();
        }
    }

    public static class Builder {
        private final Source source = new Source();

        public Builder(Path path) {
            this.source.path = path;
        }

        public Builder traverseDirectories(boolean traverse) {
            return this;
        }

        public Builder setRecursive(boolean isRecursive) {
            this.source.isRecursive = isRecursive;
            return this;
        }

        public Builder setFilters(Filters filters) {
            this.source.filters = filters;
            return this;
        }

        public Source create() {
            if (this.source.filters == null) {
                throw new RuntimeException("Cannot found filters.");
            }
            return this.source;
        }
    }
}

